# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def checkFanStatus(cmd, cliRet, lang, isCtrlId=False):
    """
    # *****************************************************************************************#
    # 类名称: checkFanStatus(cmd, cliRet, lang)
    # 功能说明: 判断当前风扇状态是否正常
    # 输入参数: cmd, cliRet, isCtrlId, lang
    # 输出参数: flag, errMsg
    # *****************************************************************************************#
    """
    flag = True
    errMsg = ""
    
    #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
    preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
    if RET_FAIL == preRet:
        flag = False
        PY_LOGGER.error("Inspect[FanStatus] not pass(cliRet2 invalid)")
        return flag, errMsg
                
    formatFunction = cHandleTypeList(cliRet)
    listDict = formatFunction.handle()
    
    #判断每个框风扇数量是否是两个
    if len(listDict) < 2:
        flag = False
        PY_LOGGER.error("Inspect[FanStatus] not pass(status abnormal)")
        if "zh" == lang:
            errMsg += u"\n" + (u"控制框" if isCtrlId else u"级联框") + u"（Subrack ID：" + cmd.split()[-1] + u"）风扇数量不足。"
        else: 
            errMsg += u"\nThe number of fans in the " + (u"controller" if isCtrlId else u"expander") + u"(Subrack ID：" + cmd.split()[-1] + u") is insufficient."   
          
    for dictInfo in listDict:
        if "Normal" != dictInfo.get("Status"):
            flag = False
            PY_LOGGER.error("Inspect[FanStatus] not pass(status abnormal)")
            if "zh" == lang:
                errMsg += u"\n" + (u"控制框" if isCtrlId else u"级联框") + u"风扇（Subrack ID：" + str(dictInfo.get("Subrack ID")) + u"，Fan Group ID：" + str(dictInfo.get("Fan Group ID")) + u"）状态不正常（" + str(dictInfo.get("Status")) + u"）。"
            else: 
                errMsg += u"\nThe Status of " + (u"controller" if isCtrlId else u"expander") + u"'s fan(Subrack ID: " + str(dictInfo.get("Subrack ID")) + u", Fan Group ID: " + str(dictInfo.get("Fan Group ID")) + u") is abnormal(" + str(dictInfo.get("Status")) + u")."   
    
    return flag, errMsg

           
def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        ctrlId = ""
        subrackIdList = []
        
        cmd = "showsubrack"
        cliRet = cliMgt.execCmd(cli, cmd)
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[FanStatus] not pass(cliRet1 invalid)")
            return flag, cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet)
        listDict = formatFunction.handle()
        
        #获取正常状态下的控制框及级联框信息
        ctrlInfo = {}
        expList = []
        for dictInfo in listDict:
            if "Controller" == dictInfo.get("Type") and "Online" == dictInfo.get("Status"):
                ctrlInfo = dictInfo
            elif "Expander" == dictInfo.get("Type") and "Online" == dictInfo.get("Status"):
                expList.append(dictInfo)
            else:
                pass
            
        #控制框风扇
        if ctrlInfo:
            subrackId = ctrlInfo.get("Subrack ID")       
            cmd = "showfan -s " + str(subrackId)
            itemCliRet = cliMgt.execCmd(cli, cmd)
            cliRet += itemCliRet
            itemFlag, itemErrMsg = checkFanStatus(cmd, itemCliRet, lang, True)
            if not itemFlag:
                flag = False
                errMsg += itemErrMsg
        
        #级联框风扇
        for expInfo in expList:
            subrackId = expInfo.get("Subrack ID")       
            cmd = "showfan -s " + str(subrackId)
            itemCliRet = cliMgt.execCmd(cli, cmd)
            cliRet += itemCliRet
            itemFlag, itemErrMsg = checkFanStatus(cmd, itemCliRet, lang)
            if not itemFlag:
                flag = False
                errMsg += itemErrMsg
                
        if flag:
            PY_LOGGER.info("Inspect[FanStatus] pass!")
                         
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[FanStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[FanStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
