# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        cmd = "showfibremodule"
        
        cliRet = cliMgt.execCmd(cli, cmd)
        
        #不存在光模块情况，需要特殊处理
        if len(cliRet.splitlines()) == 3 and ("Error showfibremodule: The command name is invalid" in cliRet):
            PY_LOGGER.info("Inspect[FibreModuleStatus] pass!(no fibre module)")
            return True, cliRet, errMsg
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[FibreModuleStatus] not pass(cliRet invalid)")
            return flag, cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeDict(cliRet)
        listDict = formatFunction.handle()
        
        for dictInfo in listDict:
			#光模块状态巡检结果信息显示不正确 2014/08/07 modified Begin
            if "Normal" != dictInfo.get("Status") and dictInfo.get("Controller ID"):
                flag = False
                PY_LOGGER.error("Inspect[FibreModuleStatus] not pass(controller status abnormal)")
                if "zh" == lang:
                    moduleSign = u"，Module：" + str(dictInfo.get("Module")) if dictInfo.get("Module") else u"，Moudle：" + str(dictInfo.get("Moudle"))
                    errMsg += u"\n控制框（Controller ID：" + str(dictInfo.get("Controller ID")) + u"，Interface ID：" + str(dictInfo.get("Interface ID")) + moduleSign + u"）光模块状态不正常（" + str(dictInfo.get("Status")) + u")。"
                else:
                    moduleSign = u", Module:" + str(dictInfo.get("Module"))if dictInfo.get("Module") else  u", Moudle:" + str(dictInfo.get("Moudle"))
                    errMsg += u"\nThe Status of optical module(Controller ID: " + str(dictInfo.get("Controller ID")) + u", Interface ID: " + str(dictInfo.get("Interface ID")) + moduleSign + u") in the controller is abnormal(" + str(dictInfo.get("Status")) + u")."
            #控制器的光模块可能出现级联框的位置，2014/08/28 modified Begin
            elif "Normal" != dictInfo.get("Status") and dictInfo.get("Subrack ID") and ("Controller" in str(dictInfo.get("Subrack Location"))):
                flag = False
                PY_LOGGER.error("Inspect[FibreModuleStatus] not pass(expander status abnormal)")   
                if "zh" == lang:
                    moduleSign = u"，Module：" + str(dictInfo.get("Module")) if dictInfo.get("Module") else u"，Moudle：" + str(dictInfo.get("Moudle"))
                    errMsg += u"\n控制框（Subrack ID：" + str(dictInfo.get("Subrack ID")) + u"，Subrack Location：" + str(dictInfo.get("Subrack Location")) + moduleSign + u"）光模块状态不正常（" + str(dictInfo.get("Status")) + u")。"
                else:
                    moduleSign = u", Module:" + str(dictInfo.get("Module"))if dictInfo.get("Module") else  u", Moudle:" + str(dictInfo.get("Moudle"))
                    errMsg += u"\nThe Status of optical module(Subrack ID: " + str(dictInfo.get("Subrack ID")) + u", Subrack Location: " + str(dictInfo.get("Subrack Location")) + moduleSign + u") in the controller is abnormal(" + str(dictInfo.get("Status")) + u")."
            #控制器的光模块可能出现级联框的位置，2014/08/28 modified End
            elif "Normal" != dictInfo.get("Status") and dictInfo.get("Subrack ID") and ("Controller" not in str(dictInfo.get("Subrack Location"))):
                flag = False
                PY_LOGGER.error("Inspect[FibreModuleStatus] not pass(expander status abnormal)")   
                if "zh" == lang:
                    moduleSign = u"，Module：" + str(dictInfo.get("Module")) if dictInfo.get("Module") else u"，Moudle：" + str(dictInfo.get("Moudle"))
                    errMsg += u"\n级联框（Subrack ID：" + str(dictInfo.get("Subrack ID")) + u"，Subrack Location：" + str(dictInfo.get("Subrack Location")) + moduleSign + u"）光模块状态不正常（" + str(dictInfo.get("Status")) + u")。"
                else:
                    moduleSign = u", Module:" + str(dictInfo.get("Module"))if dictInfo.get("Module") else  u", Moudle:" + str(dictInfo.get("Moudle"))
                    errMsg += u"\nThe Status of optical module(Subrack ID: " + str(dictInfo.get("Subrack ID")) + u", Subrack Location: " + str(dictInfo.get("Subrack Location")) + moduleSign + u") in the enclosure is abnormal(" + str(dictInfo.get("Status")) + u")."
            #光模块状态巡检结果信息显示不正确 2014/08/07 modified End
        if flag:
            PY_LOGGER.info("Inspect[FibreModuleStatus] pass!")
            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[FibreModuleStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[FibreModuleStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)