# -*- coding: UTF-8 -*-
import traceback
import re
from common.cTV1R1 import *
from common.utils import *

#10GE光模块需要在归属控制器查询, 2014/09/24 modified Begin
def _isValidCliRet(cliRet):
    """
    # *****************************************************************************************#
    # 函数名称: _isValidCliRet(cliRet)
    # 功能说明: 判断CLI回显是否有效
    # 输入参数: cliRet
    # 输出参数: True or False
    # *****************************************************************************************#
    """
    if re.search("TxPower", cliRet, re.IGNORECASE) and re.search("RxPower", cliRet, re.IGNORECASE):
        return True
    return False

def _getLocalCtrlID(cli, lang):
    """
    # *****************************************************************************************#
    # 函数名称: _getLocalCtrlID(cli,lang)
    # 功能说明: 获取当前登陆的控制器ID，A控还是B控
    # 输入参数: cli
    # 输出参数: flag, ctrlID, cliRet
    # *****************************************************************************************#
    """
    itemCliRet = cliMgt.execCmd(cli, 'showctrlip')
    #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
    preRet, itemErrMsg = preCheckCliRet('showctrlip', itemCliRet, lang)
    if RET_FAIL == preRet:
        PY_LOGGER.error("Inspect[FibreModuleStatus] cliRet invalid")
        return False, "", itemCliRet
    
    localIp = getLocalIpAddr(py_java_env)
    localCtrl = ""
    formatFunction = cHandleTypeList(itemCliRet)
    listDict = formatFunction.handle()
    
    for ctrlInfo in listDict:
        if ctrlInfo.get("IP Address") == localIp:
            localCtrl = ctrlInfo.get("Controller")
            PY_LOGGER.error("Inspect[FibreModuleStatus] local CtrlID is " + str(localCtrl))
            return True , localCtrl, itemCliRet
    else:
        PY_LOGGER.error("Inspect[FibreModuleStatus] local CtrlID is None.")
        return False, "", itemCliRet
#10GE光模块需要在归属控制器查询, 2014/09/24 modified End

#光模块检查错误信息未指明光模块位置 2015/7/24 Begin
def _getFrameId(cli, py_java_env, PY_LOGGER):
    """
    # *****************************************************************************************#
    # 函数名称: _getFrameId(cli, py_java_env, PY_LOGGER)
    # 功能说明: 获得用户框号和内部框号对应关系
    # 输入参数: cli, py_java_env, PY_LOGGER
    # 输出参数: flag, fraIdDict, cliRetList, errMsg
    # *****************************************************************************************#
    """
    flag = True
    fraIdDict = {}
    cliRetTmp = ""
    errMsg = ""
    mmlCmd = "dev framerecord"
    curMode = getCurrentMode(cli)
    lang = py_java_env.get("lang")

    try:     
        flag, cliRetTmp, errMsg = changeAnyMode2Mml(cli, py_java_env)
        if not flag:
            PY_LOGGER.error("[_getFrameId] change to mml mode failed.")
            return False, fraIdDict, cliRetTmp, errMsg
              
        cliRetTmp = cliMgt.execCmd(cli, mmlCmd)      
        cliRetTmpLines = cliRetTmp.splitlines()
        for line in cliRetTmpLines:
            if 'user, inner, mac' in line:
                pattern = '\[(\d+), (\d+), .+?\]'
                ret4Search = re.search(pattern, line)
                if ret4Search:
                    userId = str(ret4Search.group(1))
                    innerId = str(ret4Search.group(2))
                    fraIdDict[userId] = innerId 
                                      
        return True, fraIdDict, cliRetTmp, errMsg
    
    except:
        PY_LOGGER.error("[_getFrameId] catch except of trace back:" + str(traceback.format_exc()))
        return False, fraIdDict, cliRetTmp, getExceptionMsg(lang)
    finally:
        change2AimMode(cli, py_java_env, curMode)

def _getFibreModuleInfo(itemCliRet, fraIdDict):
    """
    # *****************************************************************************************#
    # 函数名称: _getFibreModuleInfo(itemCliRet, fraIdDict)
    # 功能说明: 在回显信息中提取光模块信息
    # 输入参数: itemCliRet, fraIdDict
    # 输出参数: ctrlID,subID,boardType,boardID,portID
    # *****************************************************************************************#
    """
    rectrlIdDict = {"0":"A", "1":"B"}
    reboardTypeDict = {"1":"CtrlBoard", "2":"ExpBoard", "3":"Interface"}
    refraIdDic = dict(map(lambda t:(t[1], t[0]), fraIdDict.items()))
    
    lines = itemCliRet.splitlines()
    for line in lines:
        if "dev getsfp" in line:
            mmlcmd = line
            break 
             
    mmlcmditem = mmlcmd.split()[2:] #查询光模块的mml命令有5个参数，分别为fraID,ctrlID,boardType,boardID,portID
    ctrlID = str(rectrlIdDict.get(mmlcmditem[1])) #将0、1转换成A，B                      
    subID = str(refraIdDic.get(mmlcmditem[0], mmlcmditem[0])) #将内部框号转换为用户框号
    boardType = str(reboardTypeDict.get(mmlcmditem[2])) #板类型:1 控制板，2 级联板，3 接口板                       
    boardID = str(mmlcmditem[3])
    portID = str(mmlcmditem[4])
    
    return ctrlID, subID, boardType, boardID, portID
#光模块检查错误信息未指明光模块位置 2015/7/24 End

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    ctrlIdDict = {"A":"0", "B":"1"}
    boardTypeDict = {"CtrlBoard":"1", "ExpBoard":"2", "Interface":"3"}
    
    try:
        errMsg = ""
        
        #10GE光模块需要在归属控制器查询, 2014/09/24 modified Begin
        itemFlag, localCtrlID, itemCliRet = _getLocalCtrlID(cli, lang)
        if not itemFlag:
            PY_LOGGER.error("Inspect[FibreModuleStatus] not pass(invalid local CtrlID)")
            if "zh" == lang:
                errMsg = u"\n获取控制器信息失败。"
            else:
                errMsg = u"\nFailed to get controller information."
            return False, itemCliRet, errMsg
        #10GE光模块需要在归属控制器查询, 2014/09/24 modified End
        
        cmd = "showfibremodule"

        cliRet = cliMgt.execCmd(cli, cmd)
        
        #不存在光模块情况，需要特殊处理
        if len(cliRet.splitlines()) == 3 and ("Error showfibremodule: The command name is invalid" in cliRet):
            PY_LOGGER.info("Inspect[FibreModuleStatus] pass!(no fibre module)")
            return True, cliRet, errMsg
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[FibreModuleStatus] not pass(cliRet invalid)")
            return flag, cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeDict(cliRet)
        listDict = formatFunction.handle()
        localMmlCmdList = []
        peerMmlCmdList = []
        
        #根据用户框号与内部框号的对应关系生成字典        
        flag, fraIdDict, cliRetTmp, errMsg = _getFrameId(cli, py_java_env, PY_LOGGER)
        cliRet += "\n" + cliRetTmp
        if not flag:
            PY_LOGGER.error("Inspect[FibreModuleStatus] not pass(execute MML command failed")
            return False, cliRet, errMsg
        
        for dictInfo in listDict:
            ctrlId = str(dictInfo.get("Controller ID"))
            ctrlIdRef = str(ctrlIdDict.get(ctrlId))#将A、B转换成0，1
            subId = str(dictInfo.get("Subrack ID"))
            fraID = str(fraIdDict.get(subId, subId)) #将用户框号转换为内部框号
            boardType = str(dictInfo.get("Board Type")) 
            boardTypeRef = str(boardTypeDict.get(boardType))#板类型:0,管理版，1 控制板，2 级联板，3 接口板
            boardID = str(dictInfo.get("Board ID"))
            portID = str(dictInfo.get("Port Id"))
            
            #dev getsfp 框ID 控制器ID 板类型 板id 端口ID
            mmlCmd = "dev getsfp %s %s %s %s %s" % (fraID, ctrlIdRef, boardTypeRef, boardID, portID)
            if ctrlId == localCtrlID:
                localMmlCmdList.append(mmlCmd)
            else:
                peerMmlCmdList.append(mmlCmd)         

        flag, cliRetList, errMsg = executeMmlCmdList(cli, localMmlCmdList, peerMmlCmdList, py_java_env, PY_LOGGER)
        cliRet += "\n" + "\n".join(cliRetList)
        if not flag:
            PY_LOGGER.error("Inspect[FibreModuleStatus] not pass(execute MML command failed")
            return False, cliRet, errMsg
        
        retValidFlag = True
        #光模块参数正常范围默认为正确获得   Begin
        paramisValid = True
        #光模块参数正常范围默认为正确获得   End
        abnormalMsg = ""
        for itemCliRet in cliRetList:
            if not _isValidCliRet(itemCliRet):
                retValidFlag = False
                #S5000R5光模块检查错误信息未指明光模块位置 2015/7/24 Begin
                ctrlID, subID, boardType, boardID, portID = _getFibreModuleInfo(itemCliRet, fraIdDict) 
                if "zh" == lang:
                    errMsg += u"\n查询光模块（Controller ID：%s，Subrack ID：%s，Board Type：%s，Board ID：%s，Port Id：%s）状态失败。" % (ctrlID, subID, boardType, boardID, portID)
                else:
                    errMsg += u"\nFailed to query the status of optical module(Controller ID: %s, Subrack ID: %s, Board Type: %s, Board ID: %s, Port Id: %s)." % (ctrlID, subID, boardType, boardID, portID)
                continue
                #S5000R5光模块检查错误信息未指明光模块位置 2015/7/24 End
                
            lines = itemCliRet.splitlines()
            isLinked = False
            if "State: Link-up" in itemCliRet:
                isLinked = True
            #光模块默认正常 Begin
            isNormalStatus = True
            #光模块默认正常 End
            abnoramalLines = ""
            for line in lines:
                numPattern = "\s*(-?\d+\.*\d*)\s*"
                if re.match("[^:]+:" + numPattern + "\[" + numPattern + "\s-\s" + numPattern + "\]", line):
                    nums = re.findall(numPattern, line)
                    #linkdown的光模块不应该检查RxPower 2014/09/15 modified Begin
                    if not isLinked and line.strip().startswith("RxPower"):
                    #linkdown的光模块不应该检查RxPower 2014/09/15 modified End
                        continue
                    #当光模块参数正常范围都得到0时认为参数不正常 Begin
                    if float(nums[1]) == float(nums[2]) == float(0):
                        paramisValid = False
                    #当光模块参数正常范围都得到0时认为参数不正常 End
                    #这里三组数值，第0个为实际值，第1个为下线值，第2个为上限值，要求实际值在上下线值之间
                    if not float(nums[1]) <= float(nums[0]) <= float(nums[2]):
                        flag = False
                        PY_LOGGER.error("Inspect[FibreModuleStatus] not pass(FibreModule Status abnormal)")
                        #S5000R5光模块检查错误信息未指明光模块位置 2015/7/24 Begin
                        isNormalStatus = False
                        abnoramalLines += "\n" + line.strip()
                        
            if not isNormalStatus:
                ctrlID, subID, boardType, boardID, portID = _getFibreModuleInfo(itemCliRet, fraIdDict)  
                #S5000R5光模块故障原始信息显示不全 2014/09/15 modified Begin
                if "zh" == lang: 
                    abnormalMsg += u"\n光模块（Controller ID：%s，Subrack ID：%s，Board Type：%s，Board ID：%s，Port Id：%s）状态不正常：" % (ctrlID, subID, boardType, boardID, portID)
                    abnormalMsg += abnoramalLines
                else:
                    abnormalMsg += u"\nThe Status of optical module (Controller ID: %s, Subrack ID: %s, Board Type: %s, Board ID: %s, Port Id: %s) is abnormal:" % (ctrlID, subID, boardType, boardID, portID)
                    abnormalMsg += abnoramalLines
                #S5000R5光模块故障原始信息显示不全 2014/09/15 modified End
        
        errMsg += abnormalMsg
        #S5000R5光模块检查错误信息未指明光模块位置 2015/7/24 End
        
        if flag:
            PY_LOGGER.info("Inspect[FibreModuleStatus] pass!")
  
        #光模块参数正常范围未正确获得,可能是因版本过低引起,增加错误描述信息   Begin
        if not paramisValid:
            lowerVersion = ""
            productType = str(py_java_env.get("devInfo").getDeviceType())
            
            if productType in ["S5300", "S5500", "S5600"]:
                lowerVersion = "1.03.05.130.T06"
            elif productType in ["S6800E"]:
                lowerVersion = "1.03.03.530.T06"
            if flag == True:
                flag = WARNING
            if "zh" == lang:
                errMsg = u"\n部分光模块参数查询失败，请确认系统软件版本是否低于" + str(lowerVersion) + u"，如果是，建议升级后重新巡检。" + errMsg
            else:
                errMsg = u"\nFailed to query some optical module parameters. Check whether the system software version is earlier than " + str(lowerVersion) + ". If yes, upgrade the software version and perform the check again." + errMsg
        #光模块参数正常范围未正确获得,可能是因版本过低引起,增加错误描述信息  End
                
        if not retValidFlag:
            PY_LOGGER.info("Inspect[FibreModuleStatus]not pass ret invalid!")
            flag = False
            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[FibreModuleStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[FibreModuleStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    
def executeMmlCmdList(cli, localCmdList, peerCmdList, py_java_env, PY_LOGGER):
    """
    # *****************************************************************************************#
    # 函数名称: executeMmlCmdList(cli, localCmdList, peerCmdList, py_java_env, PY_LOGGER)
    # 功能说明: 发送多个MML命令，区分执行控制器，并获取回显信息
    # 输入参数: cli, localCmdList, peerCmdList, py_java_env, PY_LOGGER
    # 返 回 值: 失败：False, cliRetList, errMsg
    #        成功：True，cliRetList, errMsg
    # *****************************************************************************************#
    """
    flag = True
    cliRet = ""
    errMsg = ""
    cliRetList = []
    
    curMode = getCurrentMode(cli)
    
    lang = py_java_env.get("lang")
    try:
        if localCmdList:
            flag, cliRet, errMsg = changeAnyMode2Mml(cli, py_java_env)
            if not flag:
                cliRetList.append(cliRet)
                PY_LOGGER.error("[executeMmlCmdList] change to mml mode failed.")
                return False, cliRetList, errMsg
            
            for mmlCmd in localCmdList:
                cliRetList.append(cliMgt.execCmd(cli, mmlCmd))
        
        if peerCmdList:
            flagItem, cliRetItem, errMsg = heartToPeerCtrl(cli, py_java_env, PY_LOGGER, 30)
            if flagItem:
                try:
                    flag, cliRet, errMsg = changeAnyMode2Mml(cli, py_java_env)
                    if not flag:
                        cliRetList.append(cliRet)
                        PY_LOGGER.error("[executeMmlCmdList] change to mml mode failed.")
                        return False, cliRetList, errMsg
                    
                    for mmlCmd in peerCmdList:
                        cliRetList.append(cliMgt.execCmd(cli, mmlCmd))
                finally:
                    switchToLocal(cli, PY_LOGGER)
               
            else:                
                PY_LOGGER.info("[executeMmlCmdList] Failed to connect to peer!")
                cliRetList.append(cliRetItem)
                return False, cliRetList, errMsg
                                      
        return True, cliRetList, errMsg
    
    except:
        PY_LOGGER.error("[executeMmlCmdList] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRetList, getExceptionMsg(lang)
    finally:
        change2AimMode(cli, py_java_env, curMode)

