# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def _chkLocalHeartBeatIP(cli, localIP):
    flag = True
    errMsg = ""
    lang = py_java_env.get("lang")
    
    cliRet = cliMgt.execCmd(cli, "ifconfig")
    cliRetList = cliRet.splitlines()
    
    canFind = False
    ip = ""
    for lineInfo in cliRetList:
        lineInfo = lineInfo.strip()
        #产品不同获取心跳IP关键字不同，2015/03/09 modified Begin
        if lineInfo.startswith("eth0 "):
            canFind = True
            continue
        
        #可以查找心跳IP了
        if canFind and lineInfo.startswith("inet addr:"):
            ip = lineInfo.split("Bcast")[0].replace("inet addr:", "").strip()
            break
         #产品不同获取心跳IP关键字不同，2015/03/09 modified End

    if ip != localIP:
        flag = False
        if "zh" == lang:
            errMsg += u"\n本端不是默认心跳IP（" + str(localIP) + u"）。"
        else:
            errMsg += u"\nLocal heart beat IP(" + str(localIP) + u") is not default."

    return flag, cliRet, errMsg, ip
 
def _chkPeerHeartBeatIP(cli, peerIP, localIP): 
    flag = True
    errMsg = ""
    lang = py_java_env.get("lang")
    cliRet = ""
    
    if peerIP == localIP:
        flag = False
        if "zh" == lang:
            errMsg = u"\n对端不是默认心跳IP（" + str(peerIP) + u"）。"
        else:
            errMsg = u"\nPeer heart beat IP(" + str(peerIP) + u") is not default."
        return flag, cliRet, errMsg
    
    cliRet = cliMgt.execCmd(cli, "ping " + str(peerIP) + " -c 3")
    if "ttl" not in cliRet.lower():
        flag = False
        if "zh" == lang:
            errMsg = u"\n对端不是默认心跳IP（" + str(peerIP) + u"）。"
        else:
            errMsg = u"\nPeer heart beat IP(" + str(peerIP) + u") is not default."
    
    return flag, cliRet, errMsg

        
def execute(cli):
    flag = PASS
    cliRet = ""
    lang = py_java_env.get("lang")
    
    expectHeadIP = {'A':'192.168.2.10', 'B':'192.168.2.11'}
    
    try:
        errMsg = ""
        
        #获取系统是否为单控还是双控
        sysMode, itemCliRet, itemErrMsg = getSysModeState(cli, py_java_env)
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[HeartBeatIP] not pass(Get unkown system mode)")
            return False, itemCliRet, itemErrMsg
        
        isDoubleSys = True if MODE_DOUBLE == sysMode else False
        
        itemCliRet = cliMgt.execCmd(cli, 'showctrlip')
        cliRet += itemCliRet
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, itemErrMsg = preCheckCliRet('showctrlip', itemCliRet, lang)
        if RET_FAIL == preRet:
            flag = NOT_PASS
            errMsg += itemErrMsg
            PY_LOGGER.error("Inspect[HeartBeatIP] not pass(cliRet2 invalid)")
            return flag , cliRet, errMsg
        
        localIp = getLocalIpAddr(py_java_env)
        localCtrl = ""
        peerCtrl = ""
        formatFunction = cHandleTypeList(itemCliRet)
        listDict = formatFunction.handle()
        
        for ctrlInfo in listDict:
            if ctrlInfo.get("IP Address") == localIp:
                localCtrl = ctrlInfo.get("Controller")
                peerCtrl = "B" if localCtrl == "A" else "A"
                break
        else:
            flag = False
            if "zh" == lang:
                errMsg = u"\n获取控制器信息失败。"
            else:
                errMsg = u"\nFailed to get controller information."
            return False, cliRet, errMsg
            
            
        PY_LOGGER.info("Inspect[HeartBeatIP] Current Controller:" + str(localCtrl))
        
        flagItem, cliRetItem, errMsgItem = changeAnyMode2Debug(cli, py_java_env)
        if not flagItem:
            cliRet += cliRetItem
            PY_LOGGER.error("Inspect[HeartBeatIP] not pass(change to debug mode failed)")
            return False, cliRet, errMsgItem
        
        #检查本端心跳IP
        itemFlag, itemCliRet, itemErrMsg, localHeartBeatIP = _chkLocalHeartBeatIP(cli, expectHeadIP.get(localCtrl))
        cliRet += itemCliRet
        if not itemFlag:
            flag = False
            errMsg += itemErrMsg
            PY_LOGGER.error("Inspect[HeartBeatIP] not pass(wrong local heart beat IP)")

        
        #检查对端心跳IP
        if isDoubleSys:
            itemFlag, itemCliRet, itemErrMsg = _chkPeerHeartBeatIP(cli, expectHeadIP.get(peerCtrl), localHeartBeatIP)
            cliRet += itemCliRet
            if not itemFlag:
                flag = False
                errMsg += itemErrMsg
                PY_LOGGER.error("Inspect[HeartBeatIP] not pass(wrong peer heart beat IP)")
 
        if PASS == flag:
            PY_LOGGER.info("Inspect[HeartBeatIP] pass!")
        else:
            if "zh" == lang:
                errMsg += u"\n注意：当前心跳IP为非默认值，这将会导致部分巡检项的检查结果不准确。本次巡检结束后，建议恢复阵列心跳IP为默认值，并重新巡检。"
            else:
                errMsg += u"\nNote: If the current heartbeat IP address is not the default value, some preventive maintenance results may be inaccurate. After this preventive maintenance, recover the heartbeat IP address to the default value, and perform preventive maintenance again."
                     
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[HeartBeatIP] catch parse except of trace back:" + str(traceback.format_exc()))
        return NOT_PASS, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[HeartBeatIP] catch except of trace back:" + str(traceback.format_exc()))
        return NOT_PASS, cliRet, getExceptionMsg(lang)
    
    finally:
        changeAnyMode2Cli(cli)
