# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet1, cliRet2, cliRet3 = '', '', ''
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        cliRet1 = cliMgt.execCmd(cli, "showrg")
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet('showrg', cliRet1, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[HotSpareDisk] not pass(cliRet1 invalid)")
            return False, cliRet1, errMsg
        elif RET_SUC == preRet:
            PY_LOGGER.info("Inspect[HotSpareDisk] pass!(No rg information)")
            return True, cliRet1, errMsg
        
        formatFunction = cHandleTypeList(cliRet1)
        rgList = formatFunction.handle()
        needSpareRgList = []
        
        if 0 == len(rgList):
            return True, cliRet1, errMsg
        
        for rgInfo in rgList:
            rgLvl = rgInfo.get('Level')
            rgSta = rgInfo.get('Status')
            if rgSta in ['Fault']:
                flag = False
                PY_LOGGER.error("Inspect[DiskPhysicalStatus] not pass(fault raid group)")
                if "zh" == lang:
                    errMsg += u"\nRAID组（ID：" + rgInfo['ID'] + u"）状态不正常（" + str(rgSta) + u")。"
                else:
                    errMsg += u"\nThe RAID Group(ID: " + str(rgInfo['ID']) + u") Status is abnormal(" + str(rgSta) + u")."
                continue
            if rgLvl not in ['RAID0','0']:
                needSpareRgList.append(rgInfo)
       
        if not needSpareRgList:#No RAID group or only has RAID0 group, check pass.
            PY_LOGGER.info("Inspect[HotSpareDisk] pass!(no not raid0 group)")
            return True, cliRet1, errMsg
        
        PY_LOGGER.info('Inspect[HotSpareDisk] Need spare disk RAID group list:' + str(needSpareRgList))
        
        #Get Free spare disk list.
        cliRet2 = cliMgt.execCmd(cli, 'showdisk -l')
        formatFunction = cHandleTypeList(cliRet2)
        logicDiskList = formatFunction.handle()
        freeSpareDiskList = []
        
        preRet, itemErrMsg = preCheckCliRet('showdisk -l', cliRet2, lang)
        if RET_FAIL == preRet:
            errMsg += itemErrMsg
            PY_LOGGER.error("Inspect[HotSpareDisk] not pass(cliRet2 invalid)")
            return False, cliRet1 + cliRet2, errMsg
        
        for diskInfo in logicDiskList:
            logicStatus = diskInfo.get('Logical status')
            #兼容R5版本
            if not logicStatus:
                logicStatus = diskInfo.get('Logic Status')
                
            if logicStatus in ['Free spare']:
                freeSpareDiskList.append(diskInfo)
        
        PY_LOGGER.info('Inspect[HotSpareDisk] Free spare disk list:' + str(freeSpareDiskList))
        
        #Get the disk physical type of every single free spare disk.
        cliRet3 = cliMgt.execCmd(cli, 'showdisk -p')
        
        preRet, itemErrMsg = preCheckCliRet('showdisk -p', cliRet3, lang)
        if RET_FAIL == preRet:
            errMsg += itemErrMsg
            PY_LOGGER.error("Inspect[HotSpareDisk] not pass(cliRet2 invalid)")
            return False, cliRet1 + cliRet2 + cliRet3, errMsg
        
        
        formatFunction = cHandleTypeList(cliRet3)
        phyDiskList = formatFunction.handle()
        
        for freeSpareDisk in freeSpareDiskList:
            diskLoc = freeSpareDisk.get('Disk Location')
            for disk in phyDiskList:
                if disk.get('Disk Location') == diskLoc:
                    #兼容R5版本Physical Type显示，2014/09/16 modified Begin
                    freeSpareDisk['Physical type'] = str(disk.get('Physical type')) if disk.get('Physical type') else str(disk.get('Physical Type'))
                    #兼容R5版本Physical Type显示，2014/09/16 modified End
                    break
            else:
                PY_LOGGER.info('Inspect[HotSpareDisk] Can not get get the physical type of disk:' + str(diskLoc))
                
        PY_LOGGER.info('Inspect[HotSpareDisk] Free spare disk list with disk type info:' + str(freeSpareDiskList))
       
        for rgInfo in needSpareRgList:
            memDiskList = rgInfo.get('Disk list').split(';')
            #去掉无效的盘位
            memDiskList = [locStr for locStr in memDiskList if locStr]
             
            PY_LOGGER.info('Free spare disk list:' + str(freeSpareDiskList))
            memDiskLocList = []#Member disk location list.
            for locStr in memDiskList:
                [frameIDStr, slotIDStr] = locStr.split(',')
                location = '(' + frameIDStr + ',' + slotIDStr + ')'
                memDiskLocList.append(location.replace(" ", ""))
            
            PY_LOGGER.info('Member disk location list:' + str(memDiskLocList))
            
            #Get RAID group disk type.
            for diskLoc in memDiskLocList:
                for phyDisk in phyDiskList:
                    if diskLoc == str(phyDisk.get('Disk Location')).replace(" ", ""):
                        #兼容R5版本Physical Type显示，2014/09/16 modified Begin
                        rgDiskType = str(phyDisk.get('Physical type')) if phyDisk.get('Physical type') else str(phyDisk.get('Physical Type'))
                        #兼容R5版本Physical Type显示，2014/09/16 modified End
                        if rgDiskType and rgDiskType not in ['--']:
                            rgInfo['Physical type'] = rgDiskType
                            break
                
                #成员盘中获取成功任意一个正常的硬盘类型才退出，2014/08/08 modified Begin
                if rgInfo.get('Physical type'):
                    break
                #成员盘中获取成功任意一个正常的硬盘类型才退出，2014/08/08 modified End
                 
            PY_LOGGER.info('Inspect[HotSpareDisk] This RAID group info:' + str(rgInfo))
            
            #Calculate the minimum capacity of member disks.               
            memDiskCapacityList = []
            for diskLoc in memDiskLocList:
                for logicDisk in logicDiskList:
                    if diskLoc == logicDisk.get('Disk Location').replace(" ", ""):
                        try:
                            diskCapacity = logicDisk.get('Usable Capacity(GB)')
							#部分版本是Capacity(GB)
                            if diskCapacity == None:
                                diskCapacity = logicDisk.get('Capacity(GB)')
                            diskCapacity = int(diskCapacity)
                        except:
                            PY_LOGGER.error("Failed to calculate the minimum capacity of member disks.")
                            pass
                        else:
                            memDiskCapacityList.append(diskCapacity)
                        finally:
                            break
                else:
                    PY_LOGGER.info('Inspect[HotSpareDisk] Can not get get the disk location in logic disk list:' + str(diskLoc))
            
            if not memDiskCapacityList:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n获取RAID组（ID：" + str(rgInfo['ID']) + u"）硬盘逻辑信息错误。"
                else:
                    errMsg += u"\nThe obtained logical information about the disks in the RAID group(ID: " + rgInfo['ID'] + u") is incorrect ."
                continue
                    
            PY_LOGGER.info('This member disk capacity list:' + str(memDiskCapacityList))
            minMemDiskCapacity = min(memDiskCapacityList)
            PY_LOGGER.info('This RAID Group minimum disk capacity(GB):' + str(minMemDiskCapacity))
            
            for spareDisk in freeSpareDiskList:
                #兼容R5版本Physical Type显示，2014/09/16 modified Begin
                diskType = str(spareDisk.get('Physical type')) if spareDisk.get('Physical type') else str(spareDisk.get('Physical Type'))
                #兼容R5版本Physical Type显示，2014/09/16 modified End
                if diskType and diskType == rgInfo.get('Physical type'):
                    #部分版本是Capacity(GB)，2014/08/18 modified Begin
                    freeSpareDiskCapacity = spareDisk.get('Usable Capacity(GB)')
                    if not freeSpareDiskCapacity:
                        freeSpareDiskCapacity = spareDisk.get('Capacity(GB)')
                     
                    if freeSpareDiskCapacity and freeSpareDiskCapacity.isdigit() and int(freeSpareDiskCapacity) >= minMemDiskCapacity:
                        break
                    #部分版本是Capacity(GB)，2014/08/18 modified End
            else:
                flag = False
                PY_LOGGER.error("Inspect[HotSpareDisk] not pass(no spare)")
                if "zh" == lang:
                    errMsg += u"\nRAID组（ID：" + str(rgInfo['ID']) + u"）没有空闲热备盘。"
                else:
                    errMsg += u"\nThe RAID group(ID: " + rgInfo['ID'] + u") does not have free hot spare disks."

        if flag:
            PY_LOGGER.info("Inspect[HotSpareDisk] pass!")
                            
        return (flag, cliRet1 + cliRet2 + cliRet3, errMsg)

    except ParseException, e:
        PY_LOGGER.error("Inspect[HotSpareDisk] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet1 + cliRet2 + cliRet3, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[HotSpareDisk] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet1 + cliRet2 + cliRet3, getExceptionMsg(lang)
