# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    allCliRet = ''
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        cliRet = cliMgt.execCmd(cli, "showlun")
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet('showlun', cliRet, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[LUNAscription] not pass(cliRet invalid)")
            return False, cliRet, errMsg        
        elif RET_SUC == preRet:
            PY_LOGGER.info("Inspect[LUNAscription] pass(no lun information)!")
            return True, cliRet, errMsg
        
        allCliRet += cliRet
        formatFunction = cHandleTypeList(cliRet, ['ID'])
        lunList = formatFunction.handle()
        
        lunIDList = []
        for lunInfo in lunList:
            lunID = lunInfo.get('ID')
            lunIDList.append(lunID)
        #LUN回显过多，存在风险。只显示检查不通过的LUN前10条 Begin
        errCounter = 0
        for lunID in lunIDList:
            qryLunDetailInfoCmd = 'showlun -i ' + lunID
            cliRet = cliMgt.execCmd(cli, qryLunDetailInfoCmd)
            
            preRet, failMsg = preCheckCliRet(qryLunDetailInfoCmd, cliRet, lang, True)
            if RET_FAIL == preRet:
                flag = False
                PY_LOGGER.error("Inspect[LUNAscription] not pass(query failed)")
                #错误回显次数叠加
                if errCounter < 10:
                    allCliRet += cliRet
                    errCounter += 1
                if "zh" == lang:
                    errMsg += u'\n查询LUN（ID：' + str(lunID) + u'）结果异常。'
                else:
                    errMsg += u'\nThe LUN(ID: ' + str(lunID) + u') result is abnormal.'
                continue
            formatFunction = cHandleTypeDict(cliRet)
            lunDictList = formatFunction.handle()
            for lunInfoDict in lunDictList:
                #私有LUN不检查LUN归属，2014/09/04 modified Begin
                if "yes"  == str(lunInfoDict.get("Whether Private LUN")).lower():
                    continue
                #私有LUN不检查LUN归属，2014/09/04 modified End
                
                ownerCtrlID = str(lunInfoDict.get('Ascription Controller'))
                workCtrlID = str(lunInfoDict.get('Working Controller'))
                if ownerCtrlID != workCtrlID:
                    flag = WARNING
                    PY_LOGGER.error("Inspect[LUNAscription] not pass(not the same)")
                    #错误回显次数叠加
                    if errCounter < 10:
                        allCliRet += cliRet
                        errCounter += 1
                        
                    if "zh" == lang:
                        errMsg += (u'\nLUN（ID：' + str(lunID) + u'）归属控制器和工作控制器不同（Ascription Controller：' + str(ownerCtrlID) 
                                  + u'，Working Controller：' + str(workCtrlID) + u'）。')
                    else:
                        errMsg += (u'\nThe Ascription Controller of LUN(ID: ' + str(lunID) + u') is not the same as the Working Controller(Ascription Controller: ' + str(ownerCtrlID) 
                                  + u', Working Controller: ' + str(workCtrlID) + u').')
        #LUN回显过多，存在风险。只显示检查不通过的LUN前10条 End
        if flag:
            PY_LOGGER.info("Inspect[LUNAscription] pass!")
            
        return flag, allCliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[LUNAscription] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[LUNAscription] catch except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, getExceptionMsg(lang)
