# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    #全局变量定义
    flag = PASS
    cliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    
    try:
        #在cli模式下执行"showhycpinfo"命令
        cmd = "showhycpinfo"
        cliRet1 = cliMgt.execCmd(cli, cmd)
        cliRet += cliRet1

        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet1, lang)
        if RET_FAIL == preRet:
            flag = NOT_PASS
            PY_LOGGER.error("Inspect[LUNCopy] not pass(cliRet invalid)")
            return flag, cliRet, errMsg
        elif RET_SUC == preRet:
            flag = PASS
            PY_LOGGER.error("Inspect[LUNCopy] pass!")
            return flag, cliRet, errMsg
        
        #根据回显获取字典的列表,举例：[{a:x},{b:v}]
        formatFunction = cHandleTypeList(cliRet1)
        listDict = formatFunction.handle()
        
        #遍历字典列表
        for dictInfo in listDict:
            #根据上面的字典获取“HyperCopy Status”及“HyperCopy State”项的值判断lun拷贝是否正常
            hyperCopyStatus = str(dictInfo.get("HyperCopy Status"))
            hyperCopyState = str(dictInfo.get("HyperCopy State"))
            hyHyperCopyID = str(dictInfo.get("HyperCopy ID"))
            #巡检不通过
            if hyperCopyStatus != "Normal":
                flag = NOT_PASS
                PY_LOGGER.error("Inspect[RemoteReplication] not pass(status abnormal)")
                if "zh" == lang:
                    errMsg += u"\nLUN拷贝（HyperCopy ID:" + hyHyperCopyID + u"）HyperCopy Status状态不正常（" + hyperCopyStatus + u"）。"
                else:    
                    errMsg += u"\nThe HyperCopy Status of LUN Copy(" + hyHyperCopyID + u") is abnormal(" + hyperCopyStatus + u")."
                continue
            
            #存在LUN拷贝，工具仅作警告提示
            if hyperCopyState == "Copying":           
                if NOT_PASS != flag:
                    flag = WARNING
                PY_LOGGER.error("Inspect[RemoteReplication] warning(State abnormal)")
                if "zh" == lang:
                    errMsg += u"\nLUN拷贝（HyperCopy ID:" + hyHyperCopyID + u"）HyperCopy State状态不正常（" + hyperCopyState + u"）。"
                else:    
                    errMsg += u"\nThe HyperCopy State of LUN Copy(" + hyHyperCopyID + u") is abnormal(" + hyperCopyState + u")."
                continue

        if PASS == flag:
            PY_LOGGER.info("Inspect[LUNCopy] pass!")
            
        return flag, cliRet, errMsg
    
    except ParseException, e:
        PY_LOGGER.error("Inspect[LUNCopy] catch parse except of trace back:" + str(traceback.format_exc()))
        return NOT_PASS, cliRet, getParseExceptionMsg(lang)
    except:
        PY_LOGGER.error("Inspect[LUNCopy] catch except of trace back:" + str(traceback.format_exc()))
        return NOT_PASS, cliRet, getExceptionMsg(lang)
    
    
    
