# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        flag = True
        errMsg = ""
        cliRet = cliMgt.execCmd(cli, "showlun")
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet('showlun', cliRet, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[LUNStatus] not pass(cliRet invalid)")
            return False, cliRet, errMsg
        elif RET_SUC == preRet:
            PY_LOGGER.info("Inspect[LUNStatus] pass(no lun information)!")
            return True, cliRet, errMsg
        
        formatFunction = cHandleTypeList(cliRet, ['ID', 'Status'])
        lunList = formatFunction.handle()
        
        for lunInfo in lunList:
            lunID = str(lunInfo.get('ID'))
            lunStatus = str(lunInfo.get('Status'))
            
            if lunStatus not in ['Normal', 'Formatting']:
                flag = False
                PY_LOGGER.error("Inspect[LUNStatus] not pass(status abnormal)")
                if "zh" == lang:
                    errMsg += u"\nLUN（ID：" + str(lunID) + u"）状态不正常（" + lunStatus + u"）。"
                else:
                    errMsg += u"\nThe Status of LUN(ID: " + str(lunID) + u") is abnormal(" + lunStatus + u")."
        
        if flag:
            PY_LOGGER.info("Inspect[LUNStatus] pass!")
            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[LUNStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[LUNStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
