# -*- coding: UTF-8 -*-
import os
import re
import traceback
from common.cTV1R1 import *
from common.utils import *

#原始的md5校验文件存放的目录
MD5_FILE_PATH = "/cf_data/image/boot/" 

#原始的md5校验的配置文件
MD5_FILE_NAME = "versions.conf" 

#三个和md5校验相关的文件名
MD5_FILE_INITRD = "initrd_osp" 
MD5_FILE_BZIMAGE = "bzImage_osp"

#两个和md5校验有关的命令
CMD1 = "md5sum -c " + MD5_FILE_NAME
CMD2 = "echo $?"

#根据CMD1,CMD2两个连续命令执行后的回文进行校验md5是否通过
def _isMd5Pass(cliRet, ipAddr):
    """
    # *****************************************************************************************#
    # 函数名称: _isMd5Pass(cliRet, ipAddr)
    #功能说明：传入对应的md5校验的最终的回文数据，以及以及对应的ip地址，进行md5的校验
    #参数说明：cliRet：md5校验的核心回文；ipAddr:要md5校验的控制器ip
    #返回值：falg:校验是否通过；errMsg:错误消息
    # *****************************************************************************************#
    """
    errMsg = ""
    lang = py_java_env.get("lang")
    #针对CMD2的回显做最终的判断
    cliRetList = cliRet.splitlines()
    for lineInfo in cliRetList[0:2]:
        if "0" == lineInfo.strip():
            return True, errMsg

    PY_LOGGER.error("Inspect[MD5Verify] faild!")
    if "zh" == lang:
        errMsg = u"\n控制器（" + str(ipAddr) + u"）MD5校验失败。"
    else:
        errMsg = u"\nThe controller of " + str(ipAddr) + " MD5 verification failed."  
    return False, errMsg
    
#传入和md5校验相关的配置文件所在的目录（保证在debug模式的前提下）     
def _Md5Verify(cli, cfgFileDirPath, isLocal=True):
    """
    # *****************************************************************************************#
    # 函数名称: _Md5Verify(cli, cfgFileDirPath, isLocal=True)
    #功能说明：传入对应的md5校验的相关的目录地址以及是否是本端，进行md5的校验
    #参数说明：cli：框架参数；cfgFileDirPath:和md5校验相关的配置文件存放的目录, isLocal=True：是否是本端设备的标志
    #返回值：falg:是否通过；cliRet:原始信息；errMsg:错误消息
    # *****************************************************************************************#
    """
    #常量定义
    cliRet = "" #存放原始信息
    errMsg = "" #存放错误消息
    
    #本端设备执行MD5校验
    ipAddr = getLocalIpAddr(py_java_env) if isLocal else getPeerIpAddr(cli, py_java_env)
    cliRet = "Controller " + str(ipAddr) + ":\n"
    cliRet += cliMgt.execCmd(cli, "cd " + cfgFileDirPath)
    cliRet += cliMgt.execCmd(cli, CMD1)
    
    #回显存在两个结束符问题，正则指定结束符 modified 20140109 Begin
    itemCliRet = cli.execCmdWithConditions(CMD2, {"timeout":300,"sshJudge":":.*#\s*$"})
    #回显存在两个结束符问题，正则指定结束符 modified 20140109 End
    
    cliRet += itemCliRet
    
    #具体的核心校验逻辑
    flag, errMsg = _isMd5Pass(itemCliRet, ipAddr)
    if not flag:
        return False, cliRet, errMsg
    return True, cliRet + "\n\n", errMsg      

def execute(cli):
    #全局变量
    flag = True  #初始化为True
    cliRet = ""
    errMsg = ""
    devTmpPath = ""
    isCheckDouble = MODE_SINGLE
    lang = py_java_env.get("lang")
    
    try:
        PY_LOGGER.info("Inspect[MD5Verify] begin!!!!")
        
        #获取系统是否为单控还是双控
        sysMode, cliRet, errMsg = getSysModeState(cli, py_java_env)
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[MD5Verify] not pass(Get unkown system mode)")
            return False, cliRet, errMsg
        
        isCheckDouble = True if MODE_DOUBLE == sysMode else False
        
        #进入debug模式
        flag1, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
        if not flag1:
            PY_LOGGER.error("Inspect[MD5Verify] not pass(change to debug mode failed)")
            return False, cliRet, errMsg
    
        #本端直接进行校验
        errMsg = ""
        flag1, cliRet1, errMsg = _Md5Verify(cli, MD5_FILE_PATH)
        cliRet = cliRet1
        if not flag1:
            flag = False
            PY_LOGGER.error("Inspect[MD5Verify] not pass(Local verify failed)")
        
        #设备是双控，需要拷贝对端的校验相关的文件到本端指定的临时目录，在临时目录中进行判断
        if isCheckDouble:
            #下载文件前判断系统内存是否足够
            flag1, cliRet1, errMsg1 = isEnoughMem(cli, py_java_env)
            if not flag1:
                cliRet += cliRet1
                errMsg += errMsg1
                PY_LOGGER.error("Inspect[MD5Verify] not pass(not have enough memory)")
                return False, cliRet, errMsg
            
            #创建存放对端md5校验相关文件的临时目录
            devTmpPath = getDevTmpFilePath(py_java_env)
            mkDevTmpPath(cli, py_java_env)

            #拷贝对端md5校验相关文件到这个临时目录
            if scpPeerFile(cli, MD5_FILE_PATH + MD5_FILE_NAME, py_java_env, devTmpPath) and \
                scpPeerFile(cli, MD5_FILE_PATH + MD5_FILE_INITRD, py_java_env, devTmpPath) and \
                scpPeerFile(cli, MD5_FILE_PATH + MD5_FILE_BZIMAGE, py_java_env, devTmpPath):
                #对拷贝后的对端md5校验相关文件，进行md5校验（等价于对端的md5校验）
                flag2, cliRet2, errMsg2 = _Md5Verify(cli, devTmpPath, False)
                cliRet2 = cliRet2.replace(devTmpPath[0:-1], MD5_FILE_PATH[0:-1])
                cliRet += cliRet2
                if not flag2:
                    errMsg += errMsg2
                    PY_LOGGER.error("Inspect[MD5Verify] not pass(Peer verify failed)")  
                    return False, cliRet, errMsg   
            else: #拷贝对端md5校验相关文件失败
                PY_LOGGER.error("Inspect[MD5Verify] not pass(Get peer file failed)")  
                if "zh" == lang:
                    errMsg += u"\n获取对端校验文件失败。"
                else:
                    errMsg += u"\nFiled to get the peer verify file."  
                return False, cliRet, errMsg
            
            if not flag:
                PY_LOGGER.info("Inspect[MD5Verify] pass!")
                
        return flag, cliRet, errMsg
    except:
        PY_LOGGER.error("Inspect[MD5Verify] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    finally:
        #删除一开始拷贝的对端md5校验相关文件
        if isCheckDouble and devTmpPath:
            cliMgt.execCmd(cli, "rm -rf " + devTmpPath + MD5_FILE_NAME)
            cliMgt.execCmd(cli, "rm -rf " + devTmpPath + MD5_FILE_INITRD)
            cliMgt.execCmd(cli, "rm -rf " + devTmpPath + MD5_FILE_BZIMAGE)
        #切换到cli模式    
        changeAnyMode2Cli(cli)              
