# -*- coding: UTF-8 -*-
import os
import re
import traceback
from common.cTV1R1 import *
from common.utils import *

#原始的md5校验文件存放的目录
# S5000R1、S2000、S5000R2
MD5_FILE_PATH = "/cf_data/image/boot/" 
# S2600R1
MD5_FILE_PATH_R1 = "/disk_data/boot" 
#S2600R2/R5/S5000R5
MD5_FILE_PATH_R5 = "/startup_disk/image/boot"


#原始的md5校验的配置文件
# S5000R1、S2000、S5000R2
MD5_FILE_NAME = "versions.conf" 
# S2600R1
MD5_FILE_NAME_R1 = "versions.conf"
#S2600R2/R5/S5000R5
MD5_FILE_NAME_R5 = "md5sum_sync"

#两个和md5校验有关的命令
CMD1 = "md5sum -c "
CMD2 = "echo $?"

#根据CMD1,CMD2两个连续命令执行后的回文进行校验md5是否通过
def _isMd5Pass(cliRet, ipAddr):
    """
    # *****************************************************************************************#
    # 函数名称: _isMd5Pass(cliRet, ipAddr)
    #功能说明：传入对应的md5校验的最终的回文数据，以及以及对应的ip地址，进行md5的校验
    #参数说明：cliRet：md5校验的核心回文；ipAddr:要md5校验的控制器ip
    #返回值：falg:校验是否通过；errMsg:错误消息
    # *****************************************************************************************#
    """
    errMsg = ""
    lang = py_java_env.get("lang")
    #针对CMD2的回显做最终的判断
    cliRetList = cliRet.splitlines()
    for lineInfo in cliRetList[0:2]:
        if "0" == lineInfo.strip():
            return True, errMsg

    PY_LOGGER.error("Inspect[MD5Verify] faild!")
    if "zh" == lang:
        errMsg = u"\n控制器（" + str(ipAddr) + u"）MD5校验失败。"
    else:
        errMsg = u"\nThe controller of " + str(ipAddr) + " MD5 verification failed."  
    return False, errMsg
    
#传入和md5校验相关的配置文件所在的目录（保证在debug模式的前提下）     
def _Md5Verify(cli, cfgFileDirPath, md5FileName, isLocal=True):
    """
    # *****************************************************************************************#
    # 函数名称: _Md5Verify(cli, cfgFileDirPath, isLocal=True)
    #功能说明：传入对应的md5校验的相关的目录地址以及是否是本端，进行md5的校验
    #参数说明：cli：框架参数；cfgFileDirPath:和md5校验相关的配置文件存放的目录, isLocal=True：是否是本端设备的标志
    #返回值：falg:是否通过；cliRet:原始信息；errMsg:错误消息
    # *****************************************************************************************#
    """
    #常量定义
    cliRet = "" #存放原始信息
    errMsg = "" #存放错误消息
    lang = py_java_env.get("lang")
    
    #本端设备执行MD5校验
    ipAddr = getLocalIpAddr(py_java_env) if isLocal else getPeerIpAddr(cli, py_java_env)
    debugCmd = "cd " + cfgFileDirPath + ";" + CMD1 + md5FileName
    cliRet = "Controller " + str(ipAddr) + ":\n"
    if isLocal:
        cliRet += cliMgt.execCmd(cli, debugCmd)
    else:
        itemFlag, itemCliRet, itemErrMsg = sendDebugCmd2PeerInDebugMode(cli, debugCmd, py_java_env, PY_LOGGER)
        cliRet += itemCliRet
        if not itemFlag:
            flag = False
            errMsg += itemErrMsg
            return False, cliRet + "\n\n", errMsg
        
    #回显存在两个结束符问题，正则指定结束符 modified 20140109 Begin
    itemCliRet = cli.execCmdWithConditions(CMD2, {"timeout":300,"sshJudge":":.*#\s*$"})
    #回显存在两个结束符问题，正则指定结束符 modified 20140109 End
        
    cliRet += itemCliRet
    
    #具体的核心校验逻辑
    flag, errMsg = _isMd5Pass(itemCliRet, ipAddr)
    if not flag:
        return False, cliRet + "\n\n", errMsg
    return True, cliRet + "\n\n", errMsg      

def execute(cli):
    #全局变量
    flag = True  #初始化为True
    cliRet = ""
    errMsg = ""
    isCheckDouble = MODE_SINGLE
    lang = py_java_env.get("lang")
    
    try:
        PY_LOGGER.info("Inspect[MD5Verify] begin!!!!")
        
        #获取系统是否为单控还是双控
        sysMode, cliRet, errMsg = getSysModeState(cli, py_java_env)
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[MD5Verify] not pass(Get unkown system mode)")
            return False, cliRet, errMsg
        
        isCheckDouble = True if MODE_DOUBLE == sysMode else False
        
        #进入debug模式
        flag, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
        if not flag:
            PY_LOGGER.error("Inspect[MD5Verify] not pass(change to debug mode failed)")
            return False, cliRet, errMsg
        
        md5FilePath = ""
        md5FileName = ""
        if isDevFileExsit(py_java_env, MD5_FILE_PATH_R5, MD5_FILE_NAME_R5):
            md5FilePath = MD5_FILE_PATH_R5
            md5FileName = MD5_FILE_NAME_R5
        if not md5FilePath or not md5FileName:
            if "zh" == lang:
                    errMsg += u"\n获取校验文件失败。"
            else:
                errMsg += u"\nFiled to get the verify file."  
            return False, cliRet, errMsg
        
        #本端直接进行校验
        errMsg = ""
        flag1, cliRet1, errMsg1 = _Md5Verify(cli, md5FilePath, md5FileName, True)
        cliRet += cliRet1
        
        if not flag1:
            flag = False
            errMsg += errMsg1
            PY_LOGGER.error("Inspect[MD5Verify] not pass(Local verify failed)")
        
        #设备是双控，需要拷贝对端的校验相关的文件到本端指定的临时目录，在临时目录中进行判断
        if isCheckDouble:
            flag2, cliRet2, errMsg2 = _Md5Verify(cli, md5FilePath, md5FileName, False)
            cliRet += cliRet2
            
            if not flag2:
                flag = False
                errMsg += errMsg2
                PY_LOGGER.error("Inspect[MD5Verify] not pass(Peer verify failed)")
            
        if not flag:
            PY_LOGGER.info("Inspect[MD5Verify] pass!")
                
        return flag, cliRet, errMsg
    except:
        PY_LOGGER.error("Inspect[MD5Verify] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    finally:
        #切换到cli模式    
        changeAnyMode2Cli(cli)              
