# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        #不同的版本，CLI命令可能不一样，挑选出当前版本支持的CLI命令并获得对应回显结果 
        cmd, cliRet = getSupportCliRet(cli, ["showctrlboardinfo", "showctrlboard"])
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[PCBVersion] not pass(cliRet invalid)")
            return flag, cliRet, errMsg
        
        if "PCB Version" not in  cliRet:
            flag = NOT_PASS
            if "zh" == lang:
                errMsg = u"\n查询PCB版本信息失败。"
            else:
                errMsg = u"\nFailed to get the PCB Version."
            return flag, cliRet, errMsg

        if flag:
            PY_LOGGER.info("Inspect[PCBVersion] pass!")
        
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[PCBVersion] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    except:
        PY_LOGGER.error("Inspect[PCBVersion] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    
    
