# -*- coding: UTF-8 -*-
import time
import traceback
from common.cTV1R1 import *
from common.utils import *


def _clearErrorCode(cli):
    
    lang = py_java_env.get("lang")
    
    flag, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
    if not flag:
        PY_LOGGER.error("Inspect[PostErrorCode] not pass(change to debug mode failed)")
        return False, cliRet, errMsg
    
    cliRet = ""
    errMsg = ""
    cmdList = ["lsiutil", "1", "20", "13", "0", "0", "0"]
    for cmd in cmdList:
        itemCliRet = cliMgt.execCmdWithTimout(cli, cmd)
        cliRet += itemCliRet
        if "Invalid answer" in itemCliRet or "bash:" in itemCliRet:
            PY_LOGGER.error("Inspect[PostErrorCode] not pass(clear error code get Invalid answer)")
            if "zh" == lang:
                errMsg = u"\n清除误码失败。"
            else:
                errMsg = u"\nFailed to clear error code."
            return False, cliRet, errMsg

    return True, cliRet, errMsg
        
def _qryErrorCode(cli):

    lang = py_java_env.get("lang")
    
    flag, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
    if not flag:
        PY_LOGGER.error("Inspect[PostErrorCode] not pass(change to debug mode failed)")
        return False, cliRet, errMsg
    
    cliRet = ""
    errMsg = ""
    cmdList = ["lsiutil", "1", "20", "12", "0", "0", "0"]
    for cmd in cmdList:
        itemCliRet = cliMgt.execCmdWithTimout(cli, cmd)
        cliRet += itemCliRet
        if "Invalid answer" in itemCliRet or "bash:" in itemCliRet:
            PY_LOGGER.error("Inspect[PostErrorCode] not pass(query error code get Invalid answer)")
            if "zh" == lang:
                errMsg = u"\n查询误码失败。"
            else:
                errMsg = u"\nFailed to query error code."
            return False, cliRet, errMsg
    
    return True, cliRet, errMsg

def _chkErrorCode(cliRet):
    errMsg = ""
    lang = py_java_env.get("lang")
    
    errCodeRet = [line for line in cliRet.splitlines() if ' Phy ' in line and 'Link Up' in line and 'No Errors' not in line]
    
    if not errCodeRet:
        PY_LOGGER.info("Inspect[PostErrorCode] no error code!")
        return True, ""

    for errCodeInfo in errCodeRet:
        errPortInfo = errCodeInfo.split(":")[0].strip()
        #1.控制框端口不区分镜像与下行端口，2.级联框端口修改为级联端口， modified Begin
        if "Adapter" in errCodeInfo:
            flag = False
            PY_LOGGER.error("Inspect[PostErrorCode] not pass(Controller port exist err code)")
            if "zh" == lang:
                errMsg += u"\n控制框端口（" + str(errPortInfo) + u"）存在误码。"
            else:
                errMsg += u"\nThe controller enclosure port(" + str(errPortInfo) + u") has bit errors."
        elif "Expander" in errCodeInfo:
            flag = False
            PY_LOGGER.error("Inspect[PostErrorCode] not pass(Expander port exist err code)")
            if "zh" == lang:
                errMsg += u"\n级联端口（" + str(errPortInfo) + u"）存在误码。"
            else:
                errMsg += u"\nThe expander port(" + str(errPortInfo) + u") has bit errors." 
        else:
            continue
        #1.控制框端口不区分镜像与下行端口，2.级联框端口修改为级联端口， modified End
    return flag, errMsg
        
def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    localCliRetList = []
    peerCliRetList = []
    localErrMsg = []
    peerErrMsg = []
    try:
        errMsg = ""
        tempFlag = True
        while tempFlag:
            tempFlag = False
            
            #获取系统是否为单控还是双控
            sysMode, cliRet, errMsg = getSysModeState(cli, py_java_env)
            if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
                PY_LOGGER.error("Inspect[FlashCardError] not pass(Get unkown system mode)")
                return False, cliRet, errMsg
            
            isDoubleSys = True if MODE_DOUBLE == sysMode else False
            
            #清除本端误码
            flagItem, cliRetItem, errMsgItem = _clearErrorCode(cli)
            localCliRetList.append(cliRetItem)
            if not flagItem:
                PY_LOGGER.error("Inspect[PostErrorCode] not pass(clear local Error Code failed)!")
                return False, cliRetItem, errMsgItem
            
            if isDoubleSys:
                #心跳到对端
                flagItem, cliRetItem, errMsgItem = heartToPeerCtrl(cli, py_java_env, PY_LOGGER, 30)
                if flagItem:
                    #清除对端误码
                    flagItem, cliRetItem, errMsgItem = _clearErrorCode(cli)
                    switchToLocal(cli, PY_LOGGER)
                    peerCliRetList.append(cliRetItem)
                    if not flagItem:
                        PY_LOGGER.error("Inspect[PostErrorCode] not pass(clear peer Error Code failed)!")
                        return False, cliRetItem, errMsgItem
                else:#R1版本为单用户,无法心跳成功，这里实际是有问题的，与维护沟通后达成一致，如果心跳对端失败忽略，仅检查本端
                    PY_LOGGER.info("Inspect[PostErrorCode] Failed to connect to peer(clear error code)!")
                                           
            time.sleep(60)
            
            #查询本端误码
            flagItem, cliRetItem, errMsgItem = _qryErrorCode(cli) 
            localCliRetList.append(cliRetItem)  
            if not flagItem:
                flag = False
                localErrMsg.append(errMsgItem)
                PY_LOGGER.error("Inspect[PostErrorCode] not pass(qryLocalErrorCode failed)!")
            else:
                flagItem, errMsgItem = _chkErrorCode(cliRetItem)
                if not flagItem:
                    flag = False
                    localErrMsg.append(errMsgItem)
                    PY_LOGGER.error("Inspect[PostErrorCode] not pass(qryLocalErrorCode failed)!")
        
            if isDoubleSys:
                #心跳到对端
                flagItem, cliRetItem, errMsgItem = heartToPeerCtrl(cli, py_java_env, PY_LOGGER, 30)
                if flagItem:
                    #查询对端误码
                    flagItem, cliRetItem, errMsgItem = _qryErrorCode(cli) 
                    switchToLocal(cli, PY_LOGGER)
                    peerCliRetList.append(cliRetItem)
                    if not flagItem:
                        flag = False
                        peerErrMsg.append(errMsgItem)
                        PY_LOGGER.error("Inspect[PostErrorCode] not pass(qryPeerErrorCode failed)!")
                    else:
                        flagItem, errMsgItem = _chkErrorCode(cliRetItem)
                        if not flagItem:
                            flag = False
                            peerErrMsg.append(errMsgItem)
                            PY_LOGGER.error("Inspect[PostErrorCode] not pass(qryPeerErrorCode failed)!")
                else:#R1版本为单用户,无法心跳成功，这里实际是有问题的，与维护沟通后达成一致，如果心跳对端失败忽略，仅检查本端
                    PY_LOGGER.info("Inspect[PostErrorCode] Failed to connect to peer(qry error code)!")
                    
        localIP = getLocalIpAddr(py_java_env)
        peerIP = getPeerIpAddr(cli, py_java_env)
        localSign = ["\nController " + localIP + ":"]
        peerSign = ["\nController " + peerIP + ":"]
        cliRet = "\n".join(localSign + localCliRetList + ((peerSign + peerCliRetList) if peerCliRetList else []))
        errMsg = "\n".join(((localSign + localErrMsg) if localErrMsg else []) + ((peerSign + peerErrMsg) if peerErrMsg else []))
        if flag:
            PY_LOGGER.info("Inspect[PostErrorCode] pass!")
              
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[PostErrorCode] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
          
    except:
        PY_LOGGER.error("Inspect[PostErrorCode] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    finally:
        changeAnyMode2Cli(cli)
