# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def checkPowerStatus(cmd, cliRet, lang, isCtrlId=False):
    """
    # *****************************************************************************************#
    # 类名称: checkPowerStatus(cmd, cliRet, lang, isCtrlId = False)
    # 功能说明: 判断当前电源状态是否正常
    #           电源Status要为Normal
    #           控制器的电源类型type不能为ACNM电源
    # 输入参数: cmd, cliRet, lang, isCtrlId = False
    # 输出参数: flag, errMsg
    # *****************************************************************************************#
    """
    
    flag = True
    errMsg = ""
    
    #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
    preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
    if RET_FAIL == preRet:
        flag = False
        PY_LOGGER.error("Inspect[PowerStatus] not pass(cliRet2 invalid)")
        return flag, errMsg
        
    formatFunction = cHandleTypeList(cliRet)
    listDict = formatFunction.handle()
    
    if len(listDict) < 2:
        flag = False
        PY_LOGGER.error("Inspect[PowerStatus] not pass(powers number not enough)")
        if "zh" == lang:
            errMsg += u"\n" + (u"控制框" if isCtrlId else u"级联框") + u"（Subrack ID：" + cmd.split()[-1] + u"）电源数量不足。"
        else: 
            errMsg += u"\nThe number of power modules in the" + (u"controller" if isCtrlId else u"expander") + u"(Subrack ID：" + cmd.split()[-1] + u") is insufficient."   

                
    for dictInfo in listDict:
        #控制框电源状态是否正常判断
        if "Normal" != str(dictInfo.get("Status")):
            flag = False
            PY_LOGGER.error("Inspect[PowerStatus] not pass(controller status abnormal)")
            if "zh" == lang:
                errMsg += u"\n" + (u"控制框" if isCtrlId else u"级联框") + u"电源（Subrack ID：" + str(dictInfo.get("Subrack ID")) + u"，Power ID：" + str(dictInfo.get("Power ID")) + u"）状态不正常（" + str(dictInfo.get("Status")) + u"）。"
            else: 
                errMsg += u"\nThe Status of " + (u"controller" if isCtrlId else u"expander") + u"'s power(Subrack ID: " + str(dictInfo.get("Subrack ID")) + u", Power ID: " + str(dictInfo.get("Power ID")) + u") is abnormal(" + str(dictInfo.get("Status")) + u")."   
                
        if isCtrlId and "ACNM" == str(dictInfo.get("Type")):
            flag = False
            PY_LOGGER.error("Inspect[PowerStatus] not pass(ACNM type)")
            if "zh" == lang:
                errMsg += u"\n控制框电源（Subrack ID：" + str(dictInfo.get("Subrack ID")) + u"，Power ID：" + str(dictInfo.get("Power ID")) + u"）类型为ACNM类型电源。"
            else: 
                errMsg += u"\nThe power module(Subrack ID: " + str(dictInfo.get("Subrack ID")) + u", Power ID: " + str(dictInfo.get("Power ID")) + u") of the controller is the ACNM type." 
    
    return flag, errMsg
               
def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        ctrlId = ""
        expandIdList = []
        
        cmd = "showsubrack"
        cliRet = cliMgt.execCmd(cli, cmd)
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[PowerStatus] not pass(cliRet1 invalid)")
            return flag, cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet)
        listDict = formatFunction.handle()
        
        #获取正常状态下的控制框及级联框信息
        ctrlInfo = {}
        expList = []
        for dictInfo in listDict:
            if "Controller" == dictInfo.get("Type") and "Online" == dictInfo.get("Status"):
                ctrlInfo = dictInfo
            elif "Expander" == dictInfo.get("Type") and "Online" == dictInfo.get("Status"):
                expList.append(dictInfo)
            else:
                pass
                
        #控制框电源
        if ctrlInfo:
            ctrlId = ctrlInfo.get("Subrack ID")
            cmd = "showpower -s " + str(ctrlId)
            itemCliRet = cliMgt.execCmd(cli, cmd)
            cliRet += itemCliRet 
            itemFlag, itemErrMsg = checkPowerStatus(cmd, itemCliRet, lang, True)
            if not itemFlag:
                flag = False
                errMsg += itemErrMsg
        
        #级联框电源
        for expInfo in expList:
            expandId = expInfo.get("Subrack ID")
            cmd = "showpower -s " + str(expandId)
            itemCliRet = cliMgt.execCmd(cli, cmd)
            cliRet += itemCliRet 
            itemFlag, itemErrMsg = checkPowerStatus(cmd, itemCliRet, lang)
            if not itemFlag:
                flag = False
                errMsg += itemErrMsg
        
        if flag:
            PY_LOGGER.info("Inspect[PowerStatus] pass!")
                      
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[PowerStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[PowerStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    
