# -*- coding: UTF-8 -*-
import traceback
import re
from common.cTV1R1 import *
from common.utils import *

def checkPowerStatus(listDict, subrackId, lang, isCtrlId=False):
    """
    # *****************************************************************************************#
    # 类名称: checkPowerStatus(listDict, cliRet, lang, isCtrlId = False)
    # 功能说明: 判断当前电源状态是否正常
    #           电源Status要为Normal
    #           控制器的电源类型type不能为ACNM电源
    # 输入参数: cmd, cliRet, lang, isCtrlId = False
    # 输出参数: listDicts, errMsg
    # *****************************************************************************************#
    """
    
    flag = True
    errMsg = ""
    validPowrPattern = "\(\s*" + subrackId + "\s*,\s*\d+\s*\)"
    
    powerList = []
    for dictinfo in listDict:
        powerLocation = str(dictinfo.get("Power Location")).replace(",", ", ")
        PY_LOGGER.error("Inspect[PowerStatus] powerLocation:" + str(powerLocation)) 
        if re.match(validPowrPattern, str(powerLocation)):
            powerList.append(dictinfo)
      
    if len(powerList) < 2:
        flag = False
        PY_LOGGER.error("Inspect[PowerStatus] not pass(powers number not enough)")
        if "zh" == lang:
            errMsg += u"\n" + (u"控制框" if isCtrlId else u"级联框") + u"（Subrack ID：" + subrackId + u"）电源数量不足。"
        else: 
            errMsg += u"\nThe number of power modules in the " + (u"controller" if isCtrlId else u"expander") + u"(Subrack ID：" + subrackId + u") is insufficient."   

                
    for powerInfo in powerList:
        #控制框电源状态是否正常判断
        if "Normal" != str(powerInfo.get("Status")):
            flag = False
            PY_LOGGER.error("Inspect[PowerStatus] not pass(controller status abnormal)")
            if "zh" == lang:
                errMsg += u"\n" + (u"控制框" if isCtrlId else u"级联框") + u"电源（Power Location：" + str(powerInfo.get("Power Location")) + u"）状态不正常（" + str(powerInfo.get("Status")) + u"）。"
            else: 
                errMsg += u"\nThe Status of " + (u"controller" if isCtrlId else u"expander") + u"'s power(Power Location: " + str(powerInfo.get("Power Location")) + u") is abnormal(" + str(powerInfo.get("Status")) + u")."   
                
    return flag, errMsg
               
def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        ctrlId = ""
        expandIdList = []
        
        cmd = "showsubrack"
        cliRet = cliMgt.execCmd(cli, cmd)
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[PowerStatus] not pass(cliRet1 invalid)")
            return flag, cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet)
        listDict = formatFunction.handle()
        
        #获取正常状态下的控制框及级联框信息
        ctrlInfo = {}
        expList = []
        for dictInfo in listDict:
            if "Controller" == dictInfo.get("Type") and "Online" == dictInfo.get("Status"):
                ctrlInfo = dictInfo
            elif "Expander" == dictInfo.get("Type") and "Online" == dictInfo.get("Status"):
                expList.append(dictInfo)
            else:
                pass
          
        cmd = "showpowerinfo"
        itemCliRet = cliMgt.execCmd(cli, cmd)
        cliRet += itemCliRet 
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, itemCliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[PowerStatus] not pass(cliRet1 invalid)")
            return flag, cliRet, errMsg
		#Power Location的值是用两个空格隔开的，解析会出错，将中间的逗号空格替换成一个逗号，打印时再反向替换回来
        formatFunction = cHandleTypeList(itemCliRet.replace(", ", ","))
        listDict = formatFunction.handle()
                   
        #控制框电源
        if ctrlInfo:
            ctrlId = ctrlInfo.get("Subrack ID")
            itemFlag, itemErrMsg = checkPowerStatus(listDict, ctrlId, lang, True)
            if not itemFlag:
                flag = False
                errMsg += itemErrMsg
        
        #级联框电源
        for expInfo in expList:
            expandId = expInfo.get("Subrack ID")
            itemFlag, itemErrMsg = checkPowerStatus(listDict, expandId, lang)
            if not itemFlag:
                flag = False
                errMsg += itemErrMsg
        
        if flag:
            PY_LOGGER.info("Inspect[PowerStatus] pass!")
                      
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[PowerStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[PowerStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    
