# -*- coding: UTF-8 -*-
import time
import traceback
from common.cTV1R1 import *
from common.utils import *
WAIT_TIME = 60

def _preHandle(cli, isDoubleSys):
    """
    # *****************************************************************************************#
    # 函数名称: _preHandle(cli)
    # 功能说明: 查询误码前需要先发送命令清除误码，为了加速速度，preinspect.py脚本里作了先行处理
    # 输入参数: cli
    # 返 回 值: 失败：False, cliRet, errMsg
    #           成功：True，localCliret, peerCliRet
    # *****************************************************************************************#
    """
    lang = py_java_env.get("lang")

    errMsg = ""
    
    startTime = py_java_env.get("startTime")
    isClearErrorCode = py_java_env.get("clearCode")
    
    PY_LOGGER.info("Inspect[ErrorCode] get start time is:" + str(startTime))
    if isClearErrorCode:
        curSec = getCurTime()
        PY_LOGGER.info("Inspect[ErrorCode] get current time is:" + str(curSec))
        #从巡检开始到现在睡眠时间不足
        if curSec - startTime < WAIT_TIME:
            time.sleep(WAIT_TIME - (curSec - startTime))
        return True, "", ""
    #清除误码时兼容命令fc clear err，2014/09/12 modified Begin
    iRet = execMmlCmd(cli, "help", py_java_env, PY_LOGGER, False)
    if not iRet[0]:
        return iRet[RET_FLAG], iRet[RET_LOCAL_CLI], iRet[RET_PEER_CLI]
    elif iRet[0] and "[fc]" not in iRet[RET_LOCAL_CLI]:
        #errMsg为空时意味着不存在fc模块
        return False, NO_INFO_MSG, ""
    
    clearErrorCmds = ["fc c e", "fc clear err"]
    
    for cmd in clearErrorCmds:
        #发送fc c e命令清除双端误码信息
        iRet = execMmlCmd(cli, cmd, py_java_env, PY_LOGGER, isDoubleSys)
        if iRet[0] and "-1-port not exist" in iRet[1]:
            break
        elif not iRet[0]:
            return False, iRet[RET_CLI], iRet[RET_ERR_MSG]
    else:
        if "zh" == lang:
            errMsg = u"\n清除误码失败。"
        else:
            errMsg = u"\nFailed to clear error."
        return False, NO_INFO_MSG, errMsg
    #清除误码时兼容命令fc clear err，2014/09/12 modified End
    time.sleep(WAIT_TIME)
    return iRet[RET_FLAG], iRet[RET_LOCAL_CLI], iRet[RET_PEER_CLI]

def _getErrPortList(cliRet):
    """
    # *****************************************************************************************#
    # 函数名称: _getErrPortList(cliRet)
    # 功能说明: 根据回显获取有误码信息的端口号列表
    # 输入参数: cliRet
    # 返 回 值: 误码端口号列表
    # *****************************************************************************************#
    """
    errPortList = []
    
    formatFunction = cTypeListWithSep(cliRet)
    listDict = formatFunction.handle()
    
    for dictInfo in listDict:
        port = dictInfo.get("Port")
        if not port:
            continue
        
        del dictInfo["Port"]
        
        for value in dictInfo.values():
            if not value or not value.isdigit():
                continue
            
            if int(value) > 0:
                errPortList.append(port) 
                break
    return errPortList

def _checkCliRet(cliRet, ipAddr):
    """
    # *****************************************************************************************#
    # 函数名称: _checkCliRet(cliRet, ipAddr)
    # 功能说明: 根据回显获取判断端口是否有误码信息
    # 输入参数: cliRet, ipAddr
    # 返 回 值: flag, errMsg
    # *****************************************************************************************#
    """
    flag = True
    errMsg = ""
    lang = py_java_env.get("lang")
    
    if not cliRet:
        return flag, errMsg
    
    #获取误码端口信息
    errPortList = _getErrPortList(cliRet)
    if not errPortList:
        return True, errMsg
    
    for errPort in errPortList:
        if int(errPort) < 4 or 9 < int(errPort) < 14:
            flag = False
            PY_LOGGER.error("Inspect[ErrorCode] not pass(front port exist err code)")
            if "zh" == lang:
                errMsg += u"\n前端端口（port id：" + str(errPort) + u"）存在误码。"
            else:
                errMsg += u"\nThe Front Port(port id: " + str(errPort) + u") has bit errors."
        else:
            continue
        
    if not flag:
        PY_LOGGER.error("Inspect[ErrorCode] not pass(" + str(ipAddr) + ")")
        if "zh" == lang:
            errMsg = u"\n控制器 " + str(ipAddr) + u"：" + errMsg + u"\n"
        else:
            errMsg = u"\nController " + str(ipAddr) + u":" + errMsg + u"\n"
    
    return flag, errMsg
                
def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        #获取系统是否为单控还是双控
        sysMode, itemCliRet, itemErrMsg = getSysModeState(cli, py_java_env)
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[ErrorCode] not pass(Get unkown system mode)")
            return False, itemCliRet, itemErrMsg
        
        isDoubleSys = True if MODE_DOUBLE == sysMode else False
                
        #查询前清除误码操作
        #根据系统当前状态来清除误码，2014/08/08 modified Begin
        iRet = _preHandle(cli, isDoubleSys)
        if not iRet[RET_FLAG]:
            if not iRet[RET_ERR_MSG]:
                return True, iRet[RET_CLI], ""
            PY_LOGGER.error("Inspect[ErrorCode] not pass(prehanle failed)")
            return iRet[RET_FLAG], iRet[RET_CLI], iRet[RET_ERR_MSG]
        #根据系统当前状态来清除误码，2014/08/08 modified End
        
        #发送误码查询命令
        iRet = execMmlCmd(cli, "fc ect", py_java_env, PY_LOGGER, isDouble=isDoubleSys)
        if not iRet[RET_FLAG]:
            PY_LOGGER.error("Inspect[ErrorCode] not pass(send fc ect failed)")
            return iRet[RET_FLAG], iRet[RET_CLI], iRet[RET_ERR_MSG]
        
        localCliRet, peerCliRet = iRet[RET_LOCAL_CLI], iRet[RET_PEER_CLI]
        cliRet = localCliRet + peerCliRet
        
        
        #检查本端是否有误码
        localFlag, localErrMsg = _checkCliRet(localCliRet, getLocalIpAddr(py_java_env))
        if not localFlag:
            flag = False
            errMsg += localErrMsg
    
        #双控时才检查对端
        if isDoubleSys:
            #检查对端是否有误码
            peerFlag, peerErrMsg = _checkCliRet(peerCliRet, getPeerIpAddr(cli, py_java_env))
            if not peerFlag:
                flag = False
                errMsg += peerErrMsg
          
        if flag:
            PY_LOGGER.info("Inspect[ErrorCode] pass!")
              
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[ErrorCode] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
          
    except:
        PY_LOGGER.error("Inspect[ErrorCode] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    
