# -*- coding: UTF-8 -*-
import time
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    cli1 = 'chgstatswitch -o -p'
    cli2 = 'statperf -p'
    cli3 = 'chgstatswitch -c -p'
    
    try:
        errMsg = ""
        
        cliRet1 = cliMgt.execCmd(cli, cli1)
        
        cliRet += cliRet1
        
        time.sleep(60)
        
        cliRet2 = cliMgt.execCmd(cli, cli2)
        cliRet += cliRet2
        
        preRet, errMsg = preCheckCliRet(cli2, cliRet2, lang, True)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[PrePortDelay] not pass(cliRet invalid)")
            return False, cliRet, errMsg
        
        """
        部分版本回显是下面的结构，需要特殊处理
        statperf -p
          CtrlID  PortID  RIO  WIO RIOT(MB/s) WIOT(MB/s) CBW(MB/s) MBW(MB/s)  CIOPS(IO/s)  MIOPS(IO/s) MDelay(ms) ADelay(ms)
               B      10    0    00.000000     0.000000     0.000000     0.000000           0            0             0          0
        Error statperf: The system is in single controller status.
        OceanStor: admin
        """
        listDict = []
        lines = cliRet.splitlines()
        
        findkeyline = False
        for line in lines:
            if "statperf -p" in line or "The system is in single controller status" in line or re.match("^[^a-zA-Z0-9]*$", line):
                continue
            if re.match("^.*>.*$", line):
                break
            
            if findkeyline:
                vals = line.split()
                dictTmp = {"CtrlID":vals[0], "PortID":vals[1], 'MDelay(ms)':vals[-2], "ADelay(ms)":vals[-1]}
                listDict.append(dictTmp)
            elif "ADelay(ms)" in line:
                findkeyline = True
        
        for dictInfo in listDict:
            aDelay = dictInfo.get("ADelay(ms)")
            mDelay = dictInfo.get("MDelay(ms)")
            #已经确认必然是数字
            if aDelay.isdigit() and int(aDelay) > 100 and mDelay.isdigit() and int(mDelay) > 2500:
                flag = NOT_PASS
                PY_LOGGER.error("Inspect[PrePortDelay] not pass(ADelay larger)")
                if "zh" == lang:
                    errMsg += u"\n端口（CtrlID：" + dictInfo.get("CtrlID") + u", PortID：" + dictInfo.get("PortID") + u"）存在延迟（ADelay(ms)：" + str(aDelay) + u"，MDelay(ms)：" + str(mDelay) + u"）。"
                else:
                    errMsg += u"\nThe port(CtrlID:" + dictInfo.get("CtrlID") + u", PortID:" + dictInfo.get("PortID") + u")exists delay(ADelay(ms):" + str(aDelay) + u",MDelay(ms):" + str(mDelay) + u")."
                
        cliRet3 = cliMgt.execCmd(cli, cli3)
        cliRet += cliRet3
        
        if flag:
            PY_LOGGER.info("Inspect[PrePortDelay] pass!")
                            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[PrePortDelay] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[PrePortDelay] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    finally:
        cliMgt.execCmd(cli, cli3)
