# -*- coding: UTF-8 -*-
import time
import traceback
from common.cTV1R1 import *
from common.utils import *


def checkPrePortDelay(cli, cliList, lang):
    flag = True
    cliRet = ""
    errMsg = ""
    
    for cliCmd in cliList:
        cliRetItem = cliMgt.execCmd(cli, cliCmd)
        cliRet += cliRetItem
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsgItem = preCheckCliRet(cliCmd, cliRetItem, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[PrePortDelay] not pass(cliRet invalid)")
            flag = False
            errMsg += errMsgItem
            continue
        
        formatFunction = cHandleTypeDict(cliRetItem)
        listDict = formatFunction.handle()
        
        for portInfo in listDict:
            aDelay = portInfo.get("Average Delay(ms)")
            mDelay = portInfo.get("Max Delay(ms)")
            if aDelay.isdigit() and int(aDelay) > 100 and mDelay.isdigit() and int(mDelay) > 2500:
                portId = cliCmd.split()[-1]
                ctrlId = cliCmd.split()[3].upper()
                flag = NOT_PASS
                PY_LOGGER.error("Inspect[PrePortDelay] not pass(ADelay larger)")
                if "zh" == lang:
                    errMsg += u"\n端口（控制器ID：" + ctrlId + u",Port ID：" + portId + u"）存在延迟（ADelay(ms)：" + str(aDelay) + u"，MDelay(ms)：" + str(mDelay) + u"）。"
                else:
                    errMsg += u"\nThe port(Controller ID:" + ctrlId + u",Port ID:" + portId + u")exists delay(ADelay(ms):" + str(aDelay) + u",MDelay(ms):" + str(mDelay) + u")."

    return flag, cliRet, errMsg   
 
def parserCmd(interfaceDictList): 
    flag = True
    errMsg = ""
    lang = py_java_env.get("lang")
    
    #支持的接口卡类型,值中第一个数值表示接口数,第二个表示类型--1:FC 2:iSCSI
    supportPortParams = {
        "4 x 4G FC Port Module"                 :[(4, 1)],
        "2 x 4G FC Port Module"                 :[(2, 1)],
        "2 x GE RJ45 Port Module"               :[(2, 2)],
        "2 x 8G FC Optical Interface"           :[(2, 1)],
        "2 FC + 2 GE Host Interface Port Card"  :[(2, 1), (2, 2)],
        "4 GE Host Interface Port Card"         :[(4, 2)],
        "4 x 8G FC Optical Interface"           :[(4, 1)],
        "10GE Optical Interface"                :[(2, 2)],
        }
    cmdList = []
    baseCmd = "statperf -p -c %s -t %s -i %s"
    notSuportType = []
    for interfaceDict in interfaceDictList:
        ctrlID = str(interfaceDict.get("Controller ID")).lower()
        type = str(interfaceDict.get("Type"))
        interfaceID = str(interfaceDict.get("Interface ID"))
        
        supportPortParamList = supportPortParams.get(type)
        if not supportPortParamList:
            notSuportType.append(type)
            continue
        
        for supportPortParam in supportPortParamList:
            portCount, portType = supportPortParam
            for i in range(portCount):
                #-i后的参数由Interface ID和PortID共同组成(取值范围:0,1,2,3,10,11,12,13)
                tempPortId = str(int(str(interfaceID) + str(i)))
                cmdList.append(baseCmd % (ctrlID, portType, tempPortId))
                
    if notSuportType:
        flag = False
        tempSet = set(notSuportType)
        if "zh" == lang:
            errMsg += u"\n工具不支持接口卡类型（" + unicode(u"，".join(tempSet)) + u"）。"
        else:
            errMsg += u"\nTool does not support interface type(" + unicode(u", ".join(tempSet)) + u")."
                        
    return flag, cmdList, errMsg
        
def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    cli1 = 'chgstatswitch -s 1'
    cli2 = 'chgstatswitch -s 0'
    
    try:
        errMsg = ""
        #打开性能统计开关
        cliRet1 = cliMgt.execCmd(cli, cli1)
        cliRet += cliRet1
        
        #检查接口卡类型
        cliRetItem = cliMgt.execCmd(cli, "showinterface")
        cliRet += cliRetItem
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet('showinterface', cliRetItem, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[PrePortDelay] not pass(cliRet invalid)")
            return False, cliRet, errMsg
        elif RET_SUC == preRet:
            PY_LOGGER.info("Inspect[PrePortDelay] pass(no interface information)!")
            return True, cliRet, errMsg
        
        lines = cliRetItem.splitlines()
        #回文是存在Electronic Label，不关注这部分信息，用双空格分隔筛选出符合列表结构的有效信息
        validCliRet = ""
        for line in lines:
            if len(line.strip().split("  ")) > 3:
                validCliRet += "\n" + line
        
        formatFunction = cHandleTypeList(validCliRet)
        interfaceList = formatFunction.handle()
        
        time.sleep(120)
        #解析需要執行的CLI命令
        flagItem, cliList, errMsgItem = parserCmd(interfaceList)
        if not flagItem:
            flag = False
            errMsg += errMsgItem
        #執行檢查
        flagItem, cliRetItem, errMsgItem = checkPrePortDelay(cli, cliList, lang)
        cliRet += cliRetItem
        if not flagItem:
            flag = False
            errMsg += errMsgItem

        cliRet2 = cliMgt.execCmd(cli, cli2)
        cliRet += cliRet2
        
        if flag:
            PY_LOGGER.info("Inspect[PrePortDelay] pass!")
                            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[PrePortDelay] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[PrePortDelay] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    finally:
        cliMgt.execCmd(cli, cli2)
