# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        cliRet = cliMgt.execCmd(cli,"showrg")
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet('showrg', cliRet, lang, necessaryData = False)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[RAIDGroupStatus] not pass(cliRet invalid)")
            return (False, cliRet, errMsg)
        elif RET_SUC == preRet:
            PY_LOGGER.info("Inspect[RAIDGroupStatus] pass(no rg information)!")
            return (True, cliRet, errMsg)
                 
        formatFunction = cHandleTypeList(cliRet, ['ID', 'Status'])
        rgList = formatFunction.handle()
        
        for rgInfo in rgList:
            rgID = str(rgInfo.get('ID'))
            rgStatus = str(rgInfo.get('Status'))
            
            if rgStatus not in ['Normal']:
                flag = False
                PY_LOGGER.error("Inspect[RAIDGroupStatus] not pass(status abnormal)")
                if "zh" == lang:
                    errMsg += u"\nRAID组（ID：" + str(rgID) + u"）状态不正常（" + rgStatus + u"）。"
                else:
                    errMsg += u"\nThe Status of RAID group(ID:  " + str(rgID) + u") is abnormal(" + rgStatus + u")."

        if flag:
            PY_LOGGER.info("Inspect[RAIDGroupStatus] pass!")
            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[RAIDGroupStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[RAIDGroupStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
        
