# -*- coding: UTF-8 -*-
import time
import traceback
from common.utils import *

def execute(cli):
    #全局变量定义
    flag = PASS
    cliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    
    try:
        #在cli命令行下执行“showhymirrorinfo”，
        cmd = "showhymirrorinfo"
        cliRet1 = cliMgt.execCmd(cli, cmd)
        cliRet += cliRet1

        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet1, lang)
        if RET_FAIL == preRet:
            flag = NOT_PASS
            PY_LOGGER.error("Inspect[RemoteReplication] not pass(cliRet1 invalid)")
            return flag, cliRet, errMsg
        elif RET_SUC == preRet:
            flag = PASS
            PY_LOGGER.error("Inspect[RemoteReplication] pass!")
            return flag, cliRet, errMsg
        
        #根据回显获取字典列表：记录远程复制状态信息（包括”HyperMirror ID“、”Status“、“HyperMirror Name”）
        formatFunction = cHandleTypeList(cliRet1)
        listDict = formatFunction.handle()
        
        #对多个远程复制成员进行遍历操作
        for dictInfo in listDict:
            status = str(dictInfo.get("Status"))
            hyperMirrorName = str(dictInfo.get("HyperMirror Name"))
            hyHyperMirrorID = str(dictInfo.get("HyperMirror ID"))
            #"Status"状态不为"Normal"则巡检不通过
            if status != "Normal" :
                flag = NOT_PASS
                PY_LOGGER.error("Inspect[RemoteReplication] not pass(status abnormal)")
                if "zh" == lang:
                    errMsg += u"\n远程复制（HyperMirror ID:" + hyHyperMirrorID + u"）状态不正常（" + status + u"）。"
                else:    
                    errMsg += u"\nThe Status of Remote replication（HyperMirror ID:" + hyHyperMirrorID + u") is abnormal(" + status + u")."
            #当从上面获取的“Status”值为“Normal”时，执行 showhymirrorlun -i “HyperMirror ID” 命令获取“Array SN”及”LUN ID“信息
            else:
                cmd2 = "showhymirrorlun -i " + str(hyHyperMirrorID)
                cliRet2 = cliMgt.execCmd(cli, cmd2)
                cliRet += "\n" + cliRet2
                
                #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
                preRet2, errMsg2 = preCheckCliRet(cmd, cliRet2, lang)
                if RET_FAIL == preRet2:
                    flag = NOT_PASS
                    PY_LOGGER.error("Inspect[RemoteReplication] not pass(cliRet2 invalid)")
                    if "zh" == lang:
                        errMsg += u"\n查询远程复制（HyperMirror ID:" + hyHyperMirrorID + u"）结果异常。"
                    else:
                        errMsg += u"\nThe remote replication(HyperMirror ID:" + hyHyperMirrorID + u") query result is abnormal."
                    continue
                
                #根据回显获取字典列表：记录远程复制状态信息（包括”HyperMirror ID“、”Status“、“HyperMirror Name”）
                formatFunction2 = cHandleTypeList(cliRet2)
                listDict2 = formatFunction2.handle()
                
                for itemDictInfo in  listDict2: 
                    relation = str(itemDictInfo.get("Relation"))
                    #远程复制兼容Slave显示情况，2014/09/16 modified Begin
                    if "Secondary" == relation or "Slave" == relation:
                    #远程复制兼容Slave显示情况，2014/09/16 modified End
                        #key的不同版本兼容处理
                        arraySN = str(itemDictInfo.get("Array SN")) if itemDictInfo.get("Array SN") else str(itemDictInfo.get("Master Array SN"))
                        lunID = str(itemDictInfo.get("LUN ID")) if itemDictInfo.get("LUN ID") else str(itemDictInfo.get("Master LUN ID"))
                        
                        #执行showhymirrorlun -i + “HyperMirror ID” + -sn  + “Array SN” + -mi  + ”LUN ID“信息；
                        cmd3 = "showhymirrorlun -i " + hyHyperMirrorID + " -sn " + arraySN + " -mi " + lunID
                        cliRet3 = cliMgt.execCmd(cli, cmd3)
                        cliRet += "\n" + cliRet3

                        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
                        preRet3, errMsg3 = preCheckCliRet(cmd, cliRet3, lang)
                        if RET_FAIL == preRet3:
                            flag = NOT_PASS
                            errMsg += errMsg3
                            PY_LOGGER.error("Inspect[RemoteReplication] not pass(cliRet3 invalid)")
                            continue
                        
                        formatFunction = cHandleTypeDict(cliRet3)
                        listDict = formatFunction.handle()
                        for dictInfo in listDict:
                            if "syncing" == str(dictInfo.get("Pair Status")).lower():
                                if NOT_PASS != flag:
                                    flag = WARNING
                                PY_LOGGER.error("Inspect[RemoteReplication] warning(pair status copying)")
                                if "zh" == lang:
                                    errMsg += u"\n远程复制（HyperMirror ID:" + hyHyperMirrorID + u"，Array SN：" + arraySN + u"，LUN ID：" + lunID + u"）状态不正常（" + str(dictInfo.get("Pair Status")) + u"）。"
                                else:    
                                    errMsg += u"\nThe Pair Status of Remote replication（HyperMirror ID:" + hyHyperMirrorID + u", Array SN:" + arraySN + u", LUN ID:" + lunID + u"）is abnormal(" + str(dictInfo.get("Pair Status")) + u")."
                            
        if PASS == flag:
            PY_LOGGER.info("Inspect[RemoteReplication] pass!")
            
        return flag, cliRet, errMsg
    
    except ParseException, e:
        PY_LOGGER.error("Inspect[RemoteReplication] catch parse except of trace back:" + str(traceback.format_exc()))
        return NOT_PASS, cliRet, getParseExceptionMsg(lang)
    except:
        PY_LOGGER.error("Inspect[RemoteReplication] catch except of trace back:" + str(traceback.format_exc()))
        return NOT_PASS, cliRet, getExceptionMsg(lang)
        
        
