# -*- coding: UTF-8 -*-
import traceback
import os
from common.cTV1R1 import *
from common.utils import *

def checkSESReverse(fileDir, ipAddr, subrackCount):
    #检查本端复位次数
    f = open(fileDir, 'r')
    
    sesReverseTime = 0
    ret = ""
    for line in f:
        if "Firmware version" in line:
            sesReverseTime += 1 
            ret += "\n" + line
           
    f.close()
    
    if sesReverseTime > subrackCount * 2:
        cliRet = "\nController " + str(ipAddr) + ":\n" + ret
        return False, cliRet
    else:       
        return True, ""
    

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        localIp = ""
        peerIp = ""
        curDevTimeSec = -1
        fileName = "/OSM/log/cur_debug/SES_log"
        fileNameTxt = "/OSM/log/cur_debug/SES_log.txt"

        #获取系统是否为单控还是双控
        sysMode, itemCliRet, itemErrMsg = getSysModeState(cli, py_java_env)
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[SESAbnormalReverse] not pass(Get unkown system mode)")
            return False, itemCliRet, itemErrMsg
        
        #确定框个数
        cmd = "showsubrack"
        cliRet2 = cliMgt.execCmd(cli, cmd)
        cliRet += cliRet2
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet2, lang)
        if RET_FAIL == preRet:
            flag = NOT_PASS
            PY_LOGGER.error("Inspect[SESAbnormalReverse] not pass(cliRet invalid)")
            return flag, cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet)
        listDict = formatFunction.handle()
        
        subrackCount = len(listDict) 
        
        flag, cliRet3, errMsg = changeAnyMode2Debug(cli, py_java_env)
        cliRet += cliRet3
        if not flag:
            PY_LOGGER.error("Inspect[SESAbnormalReverse] not pass(change to debug mode failed)")
            return False, cliRet, errMsg
        
        #debug模式下获取阵列当前时间
        curDevTimeSec = formatTimeStamp2Sec(getCurDevTime(cli))
        PY_LOGGER.info("Inspect[SESAbnormalReverse] The system current time is:" + str(curDevTimeSec))
        if -1 == curDevTimeSec:
            return False, "Failed to get system time.", getSysTimeFailedMsg(lang)
        
        #创建本地临时存放文件
        localTmpPath = getLocaTmplFilePath(py_java_env)
        mkLocalTmpPath(localTmpPath)
        
        localFlag, peerFlag = True, True
        #拷贝阵列文件到本地
        cliRet = ""
        localIp = getLocalIpAddr(py_java_env)
        mvSucc, fileDir = mvLocalDevFile2Local(cli, py_java_env, localIp , fileName)
        #本端文件获取成功开始分析
        if mvSucc:
            PY_LOGGER.info("Inspect[SESAbnormalReverse] Starting to parse local file:)" + str(fileDir))
            localFlag, ret = checkSESReverse(fileDir, localIp, subrackCount)
            if not localFlag:
                cliRet += ret
                PY_LOGGER.error("Inspect[SESAbnormalReverse] not pass(local exist ses abnormal reverse)")
        else:
            mvSucc, fileDir = mvLocalDevFile2Local(cli, py_java_env, localIp , fileNameTxt)
            if mvSucc:
                PY_LOGGER.info("Inspect[SESAbnormalReverse] Starting to parse local file:)" + str(fileDir))
                localFlag, ret = checkSESReverse(fileDir, localIp, subrackCount)
                if not localFlag:
                    cliRet += ret
                    PY_LOGGER.error("Inspect[SESAbnormalReverse] not pass(local exist ses abnormal reverse)")
            else:
                flag = False
                PY_LOGGER.error("Inspect[SESAbnormalReverse] not pass(local file get failed)")
                errMsg += getFileFaildMsg(lang, True, fileName)
            
        #双控时获取对端文件到本地
        if MODE_DOUBLE == sysMode:
            peerIp = getPeerIpAddr(cli, py_java_env)
            mvSucc, fileDir = mvPeerDevFile2Local(cli, py_java_env, peerIp, fileName)
            #对端文件获取成功开始分析
            if mvSucc:
                PY_LOGGER.info("Inspect[SESAbnormalReverse] Starting to parse peer file:)" + str(fileDir))
                peerFlag, ret = checkSESReverse(fileDir, peerIp, subrackCount)
                if not peerFlag:
                    cliRet += ret
                    PY_LOGGER.error("Inspect[SESAbnormalReverse] not pass(peer exist ses abnormal reverse)")
            else:
                mvSucc, fileDir = mvPeerDevFile2Local(cli, py_java_env, peerIp, fileNameTxt)
                #对端文件获取成功开始分析
                if mvSucc:
                    PY_LOGGER.info("Inspect[SESAbnormalReverse] Starting to parse peer file:)" + str(fileDir))
                    peerFlag, ret = checkSESReverse(fileDir, peerIp, subrackCount)
                    if not peerFlag:
                        cliRet += ret
                        PY_LOGGER.error("Inspect[SESAbnormalReverse] not pass(peer exist ses abnormal reverse)")
                else:
                    flag = False
                    PY_LOGGER.error("Inspect[SESAbnormalReverse] not pass(peer file get failed)")
                    errMsg += getFileFaildMsg(lang, False, fileName)   
            
            
        if not (localFlag and peerFlag):
            PY_LOGGER.error("Inspect[SESAbnormalReverse] not pass(exist ses abnormal reverse)")
            flag = flag if flag == NOT_PASS else WARNING
            if "zh" == lang:
                errMsg += u"\nSES可能存在异常复位。"
            else:
                errMsg += u"\nThe SES may reset abnormally."
        #在flag为True时才将回显重置为No information，2014/09/12 modified Begin
        if flag == PASS:
            cliRet = NO_INFO_MSG
            PY_LOGGER.info("Inspect[SESAbnormalReverse] pass")
        #在flag为True时才将回显重置为No information，2014/09/12 modified End
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[SESAbnormalReverse] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    except:
        PY_LOGGER.error("Inspect[SESAbnormalReverse] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    finally:
        changeAnyMode2Cli(cli)
