# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        #不同的版本，CLI命令可能不一样，挑选出当前版本支持的CLI命令并获得对应回显结果 
        cmd, cliRet = getSupportCliRet(cli, ["showallversion", "showallver"])
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[SESVersion] not pass(cliRet invalid)")
            return flag, cliRet, errMsg
        
        #获取回显开始的起始位置
        startIndex = getLocation(cliRet, "SES Version", P_Contain)
        if - 1 == startIndex:
            flag = False
            if "zh" == lang:
                errMsg = u"\n查询SES版本信息失败。"
            else:
                errMsg = u"\nFailed to get the SES Version."
            return flag, cliRet, errMsg

        endIndex = getLocation(cliRet, "--------", P_Contain, startIndex)
         
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet, areaIndex=[startIndex, endIndex])
        listDict = formatFunction.handle()
        
        validSesVerList = [] 
        for dictInfo in listDict:
            #V1R1是Version
            if isValidVal(dictInfo.get("Version")):
                validSesVerList.append(dictInfo.get("Version"))
            #V1R2是SES Version
            elif isValidVal(dictInfo.get("SES Version")):
                validSesVerList.append(dictInfo.get("SES Version"))
            else:
                flag = False
                PY_LOGGER.error("Inspect[SESVersion] not pass(value invalid)") 
                if "zh" == lang:
                    errMsg += u"\n框（Subrack ID：" + str(dictInfo.get("Subrack ID")) + u"，Board ID：" + str(dictInfo.get("Board ID")) + u"）SES版本信息无效。"
                else:
                    errMsg += u"\nInvalid SES version of subrack(Subrack ID:" + str(dictInfo.get("Subrack ID")) + u", Board ID: " + str(dictInfo.get("Board ID")) + u")."
        
        if validSesVerList:  
            if 1 != len(set(validSesVerList)):
                flag = False
                PY_LOGGER.error("Inspect[SESVersion] not pass(inconsistent)") 
                if "zh" == lang:
                    errMsg += u"\n系统SES版本不一致。"
                else:
                    errMsg += u"\nThe SES version is inconsistent in system."
        
        if flag:   
            PY_LOGGER.info("Inspect[SESVersion] pass!")
            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[SESVersion] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[SESVersion] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
