# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *


def execute(cli):
    flag = True
    cliRet = NO_INFO_MSG
    lang = py_java_env.get("lang")
    try:
        errMsg = ""
        PRODUCT_VER = "V100R002"
        
        #不同的版本，CLI命令可能不一样，挑选出当前版本支持的CLI命令并获得对应回显结果 
        cmd, cliRet = getSupportCliRet(cli, ["showallver", "showallversion"])
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[SoftVersion] not pass(cliRet invalid)")
            return flag, cliRet, errMsg
 
        #获取回显开始的起始位置
        startIndex = getLocation(cliRet, "Software Version:", P_Contain)
        if - 1 == startIndex:
            flag = False
            if "zh" == lang:
                errMsg = u"\n查询系统软件版本信息失败。"
            else:
                errMsg = u"\nFailed to query the system software version."
            return flag, cliRet, errMsg
        
        #获取回显开始的起始位置
        endIndex = getLocation(cliRet, "----------------", P_Contain, startIndex)
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet, ["Controller", "Soft Version", "Software Version"], areaIndex=[startIndex, endIndex])
        listDict = formatFunction.handle()
        
        validSoftVerList = [] 
        for dictInfo in listDict:
            if isValidVal(dictInfo.get("Soft Version")):
                validSoftVerList.append(dictInfo.get("Soft Version"))
            elif isValidVal(dictInfo.get("Software Version")):
                validSoftVerList.append(dictInfo.get("Software Version"))
            else:
                flag = False
                PY_LOGGER.error("Inspect[SoftVersion] not pass(value invalid)") 
                if "zh" == lang:
                    errMsg += u"\n控制器（Controller：" + str(dictInfo.get("Controller")) + u"）软件版本信息无效。"
                else:
                    errMsg += u"\nInvalid software version of controller(Controller: " + str(dictInfo.get("Controller")) + u")."

        #判断版本是否一致            
        if validSoftVerList:  
            if 1 != len(set(validSoftVerList)):
                flag = False
                PY_LOGGER.error("Inspect[SoftVersion] not pass(inconsistent)") 
                if "zh" == lang:
                    errMsg += u"\nA、B控系统软件版本不一致。"
                else:
                    errMsg += u"\nThe Soft Version of controller A and that of controller B are different."
                return flag, cliRet, errMsg
            
            #获取Product Version开始的位置
            index = getLocation(cliRet, "Product Version:", P_Contain)
            if - 1 == index:
                flag = False
                if "zh" == lang:
                    errMsg = u"\n查询产品版本信息失败。"
                else:
                    errMsg = u"\nFailed to get product version."
                return flag, cliRet, errMsg
            
            cliRetList = cliRet.splitlines()
            for i in xrange(index + 1, index + 3):
                if re.match("^\w*$", cliRetList[i].strip()):
                    productVersion = cliRetList[i].strip()[0:8]
                    break
                
            if productVersion == PRODUCT_VER:
                flag = WARNING if flag else False
                if "zh" == lang:
                    errMsg += u"\n当前版本是V100R002版本，请先按照修复建议操作。"
                else:
                    errMsg += u"\nCurrent version is V100R002, please refer to Recovery Suggestion."
                return flag, cliRet, errMsg
        
        if flag:
            PY_LOGGER.info("Inspect[SoftVersion] pass!")
        
        return flag, cliRet, errMsg
    
    except ParseException, e:
        PY_LOGGER.error("Inspect[SoftVersion] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[SoftVersion] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    
