# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

MIN_S2600R2_SOFT_VER = "1.04.05.131.T02"

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        
        #不同的版本，CLI命令可能不一样，挑选出当前版本支持的CLI命令并获得对应回显结果 
        cmd, cliRet = getSupportCliRet(cli, ["showallver", "showallversion"])
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[SoftVersion] not pass(cliRet invalid)")
            return flag, cliRet, errMsg
 
        #获取回显开始的起始位置
        startIndex = getLocation(cliRet, "Software Version:", P_Contain)
        if -1 == startIndex:
            flag = False
            if "zh" == lang:
                errMsg = u"\n查询系统软件版本信息失败。"
            else:
                errMsg = u"\nFailed to query the system software version."
            return flag, cliRet, errMsg
        
        #获取回显开始的起始位置
        endIndex = getLocation(cliRet, "==========", P_Contain, startIndex)
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet, ["Controller", "Soft Version", "Software Version"], areaIndex=[startIndex, endIndex])
        listDict = formatFunction.handle()

        validSoftVerList = [] 
        for dictInfo in listDict:
            if isValidVal(dictInfo.get("Soft Version")):
                validSoftVerList.append(dictInfo.get("Soft Version"))
            elif isValidVal(dictInfo.get("Software Version")):
                validSoftVerList.append(dictInfo.get("Software Version"))
            else:
                flag = False
                PY_LOGGER.error("Inspect[SoftVersion] not pass(value invalid)") 
                if "zh" == lang:
                    errMsg += u"\n控制器（Controller：" + str(dictInfo.get("Controller")) + u"）软件版本信息无效。"
                else:
                    errMsg += u"\nInvalid software version of controller(Controller: " + str(dictInfo.get("Controller")) + u")."
        
        #判断版本是否过低
        for dictInfo in listDict:
            tempSoftVer = dictInfo.get("Soft Version")
            if not tempSoftVer:
                tempSoftVer = dictInfo.get("Software Version")
            if not isValidVal(tempSoftVer):
                continue
           
            minSoftVer = MIN_S2600R2_SOFT_VER
            if tempSoftVer < minSoftVer:
                flag = False
                PY_LOGGER.error("Inspect[SoftVersion] not pass(lower version)") 
                
                if "zh" == lang:
                    errMsg += u"\n控制器（Controller：" + str(dictInfo.get("Controller")) + u"）版本低于" + minSoftVer + \
                              u"（" + str(tempSoftVer) + u"）。"
                else:
                    errMsg += u"\nThe controller(Controller: " + str(dictInfo.get("Controller")) + \
                                ") version is earlier than " + minSoftVer + "(" + str(tempSoftVer) + u")."
                          
        #判断版本是否一致            
        if validSoftVerList:  
            if 1 != len(set(validSoftVerList)):
                flag = False
                PY_LOGGER.error("Inspect[SoftVersion] not pass(inconsistent)") 
                if "zh" == lang:
                    errMsg += u"\nA、B控系统软件版本不一致。"
                else:
                    errMsg += u"\nThe Software Version of controller A and that of controller B are different."

        if flag:
            PY_LOGGER.info("Inspect[SoftVersion] pass!")
            
        return flag, cliRet, errMsg
    
    except ParseException, e:
        PY_LOGGER.error("Inspect[SoftVersion] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[SoftVersion] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
