# -*- coding: UTF-8 -*-
import traceback
from common.cTV1R1 import *
from common.utils import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        exsitExpand = False
        
        cmd = "showsubrack"
        cliRet = cliMgt.execCmd(cli,cmd)
        
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preRet, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preRet:
            flag = False
            PY_LOGGER.error("Inspect[SubrackStatus] not pass(cliRet invalid)")
            return flag, cliRet, errMsg
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet)
        listDict = formatFunction.handle()
        
        for dickInfo in listDict:
            if "Online" != dickInfo.get("Status"):
                flag = False
                isCtrlId = ("Controller" == dickInfo.get("Type"))
                PY_LOGGER.error("Inspect[SubrackStatus] not pass(controller abnormal)")
                if "zh" == lang:
                    errMsg += u"\n" + (u"控制框" if isCtrlId else u"级联框") + u"（Subrack ID：" + str(dickInfo.get("Subrack ID")) + u"）状态不正常（" + str(dickInfo.get("Status")) + u"）。"
                else:
                    errMsg += u"\nThe Status of " + (u"controller" if isCtrlId else u"expander") + u"(Subrack ID: " + str(dickInfo.get("Subrack ID")) + u") is abnormal(" + str(dickInfo.get("Status")) + u")."
        
        if flag:
            PY_LOGGER.info("Inspect[SubrackStatus] pass")
            
        return flag, cliRet, errMsg

    except ParseException, e:
        PY_LOGGER.error("Inspect[SubrackStatus] catch parse except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getParseExceptionMsg(lang)
    
    except:
        PY_LOGGER.error("Inspect[SubrackStatus] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
