# -*- coding: UTF-8 -*-
import traceback
import re
import common
from common import constant
from common import utils
from common import modeMgt
from common import cliMgt
from common import cTV1R1
import os
java_env = py_java_env
logger = PY_LOGGER


def execute(cli):
    """
    # *****************************************************************************************#
    # 函数名称: execute(cli)
    # 功能说明: 系统流控检查，执行sys showfl，tgt showparam命令，获取回显信息,查看系统流控状态
    # 输入参数: cliRet 命令回文
    # 返 回 值: cilRetAll命令回显
    # *****************************************************************************************#
    """
    
    flag = True
    checkFlag = True
    errMsg = ""
    lang = java_env.get("lang")
    sysSpcVersion = ""
    cliRet = ""
    cliRetAll = "" 
    #单双控列表
    modeList =["single","double"]
    try:             
        #判断产品版本，V100R005C02SPC010版本之前则不涉及
        deviceType = str(java_env.get("devInfo").getDeviceType())
        sysSpcVersion, cliRet = utils.getDevVer(cli)
        logger.info("deviceType: " + str(deviceType) + ", Version: " + str(sysSpcVersion))
        cliRetAll += cliRet
        if sysSpcVersion < '1.04.01.208.T10':
            return (constant.NO_SUPPORT,cliRetAll,errMsg)
        
        #判断系统是否为双控
        (sysMode, itemCliRet, itemErrMsg) = utils.getSysModeState(cli, java_env) 
        cliRetAll += itemCliRet
        errMsg += itemErrMsg     
        if sysMode not in modeList:
            logger.error("Inspect[Concurrent_Resources] not pass(Get unkown system mode)")
            return (False, cliRetAll, errMsg)
        #如果系统双控正常则需要登录两个控制器
        isDouble = True if 'double' == sysMode else False
        
        #获取控制器的信息，识别当前控制器是A还是B
        (checkRet, itemCliRet, currentID, itemErrMsg) = utils.getLocalCtrlID(cli, java_env)
        logger.info("[getLocalCtrlID]The control id is " + str(currentID))
        cliRetAll += itemCliRet
        errMsg += itemErrMsg
        if not checkRet:
            return (False, cliRetAll, errMsg)
        peerID = "B"
        if currentID == "B":
            peerID = "A"
        
        #命令列表
        cmdList = ["sys showfl", "tgt showparam"]
        #切到mml，执行命令sys showfl,tgt showparam获取回显信息  
        (flag, localCliRet, peerCliRet) = utils.execMmlCmdLocalBefore(cli, cmdList, java_env, logger, isDouble)
        if not flag:
            logger.error("[execMmlCmdLocalBefore]Execute the cmdList failed!")
            cliRetAll += localCliRet
            errMsg += peerCliRet         
            return (False, cliRetAll, errMsg)
        #分析本端控制器回显信息，查看是否包含关键字
        (localFlag, localErrMsg) = checkCliRet(currentID, localCliRet, lang)
        if not localFlag:
            checkFlag = False
            errMsg += localErrMsg                  
        #分析对端控制器回显信息，查看是否包含关键字
        (peerFlag, peerErrMsg) = checkCliRet(peerID, peerCliRet, lang)
        if not peerFlag:
            checkFlag = False
            errMsg += peerErrMsg
       
        #返回本端和对端回显信息
        cliRetAll += localCliRet + peerCliRet
        return (checkFlag, cliRetAll, errMsg) 
    except:
        logger.error("[check_item_ControlStream]catch except of trace back:" + str(traceback.format_exc()))
        return (False, cliRetAll, errMsg)
                                                   

def checkCliRet(controlID, controlCliRet,lang):
    '''
    分析各个控制器的回信信息，查找是否含有关键字
    '''
    errMsg = ""
    openFlag = False
    flowFlag = False
    checkFlag = True
    for line in controlCliRet.splitlines():
        if "FlowCtrl OnOff [1]" in line:
            openFlag = True
            continue
        if "current  flow type:" in line and \
            line.split(':')[-1].strip() != "STOP":
            flowFlag = True
            break
            
    if openFlag and flowFlag:
        checkFlag = False          
        logger.error("FlowCtrl switch is open.And current  flow type is DYNAMIC!")
        if "zh" == lang:
            errMsg = u"\n控制器" + str(controlID) + u"流控开关打开。"
        else:
            errMsg = u"\nEnable the flow control switch of controller " +  str(controlID)
    return checkFlag, errMsg
        
    


    
   

