# -*- coding: UTF-8 -*-
import os
import re
import traceback
from common.cTV1R1 import *
from common.utils import *
from common.cliMgt import *
from common.modeMgt import *
from common import constant

def execute(cli):
    """
    步骤1 以admin用户登录每个控制器。
    步骤2 执行debug命令进入DEBUG模式
    步骤3 执行mml命令进入MML模式。
    步骤4 执行tgt showcmd命令。
    步骤5 执行exit命令，进入DEBUG模式。
    步骤6 分别执行cat /OSM/log/cur_debug/messages |grep "Free Cmd:"
    cat /OSM/log/cur_debug/messages_bak |grep "Free Cmd:"，获取端口的Free Cmd的值。

    # TGT资源检查#
    1 存在关键字“Free Cmd：”后面的数值为0则检查结果为不通过，否则为通过。
    2 命令执行失败，则检查结果为不通过。

    # *****************************************************************************************#
    """
    allCliRet = ""
    errMsg = ""
    flag = True
    lang = py_java_env.get("lang")
    
    try:
        #判断型号版本是否符合
        deviceType = str(py_java_env.get("devInfo").getDeviceType())
        sysVer,cmdRet = getDevVer(cli)
        allCliRet += cmdRet
        PY_LOGGER.info("deviceType: " + str(deviceType) + ", Version: " + str(sysVer))
        #S6800E 1.03.03.530.T06 V100R005C02SPC010
        #S2600  1.04.01.208.T10 V100R001C02SPC012
        if not (deviceType.upper() == "S6800E" and sysVer >= "1.03.03.525.T02") and\
            not (deviceType.upper() == "S2600" and sysVer >= "1.04.01.208.T10"):
            return (constant.NO_SUPPORT,allCliRet,errMsg)
    
        #判断当前系统单双控 
        sysMode, cmdRet, errInfo = getSysModeState(cli, py_java_env)
        errMsg += errInfo
        allCliRet += cmdRet
        if sysMode == constant.MODE_UNKOWN:
            return (False, allCliRet, errMsg)
        #如果系统双控正常则需要登录两个控制器
        isDoubleSys = True if MODE_DOUBLE == sysMode else False
        
        #获取当前登录的控制器ID
        peerCtrlID = "B"
        checkRet, cmdRet, localCtrlID, errInfo = getLocalCtrlID(cli,py_java_env)
        errMsg += errInfo
        allCliRet += cmdRet
        if not checkRet:
            return (checkRet, allCliRet, errMsg)
        
        if localCtrlID == "B":
            peerCtrlID = "A"

        #获取本端和对端的tgt showcmd回文结果
        isSuccess, localCliRet, peerCliRet = execMmlCmd(cli, "tgt showcmd", py_java_env, PY_LOGGER, isDoubleSys)
        allCliRet += localCliRet
        allCliRet += peerCliRet
        if not isSuccess:
            errMsg += peerCliRet
            return isSuccess, allCliRet, errMsg

        isSuccess, cliRet, errInfo = changeAnyMode2Debug(cli,py_java_env)
        errMsg += errInfo
        allCliRet += cliRet
        messagesRet = ""
        if not isSuccess:
            return isSuccess, allCliRet, errMsg
        messagesRet += execCmd(cli,'cat /OSM/log/cur_debug/messages_bak |grep "Free Cmd:"')
        messagesRet += execCmd(cli,'cat /OSM/log/cur_debug/messages |grep "Free Cmd:"')
        allCliRet += messagesRet
        portIdList = getFreeCmdPort(messagesRet)
        if len(portIdList) > 0:
            flag = False
            idList = []
            for id in set(portIdList):
                idList.append(id)
            if lang == "zh":
                errMsg +=u"\n控制器:"+ str(localCtrlID) + u"中FreeCmd数值为0的端口为:" + ",".join(idList) + u"。"
            else:
                errMsg +="\nOn controller:"+ str(localCtrlID) + u", the value of Free Cmd for port" + ",".join(idList) + " is 0."
        peerFlag = True   
        if isDoubleSys:
            #登录对端控制器
            peerFlag, cliRet, peerPortIdList, errInfo = getPeerDebugInfo(cli,['cat /OSM/log/cur_debug/messages_bak |grep "Free Cmd:"','cat /OSM/log/cur_debug/messages |grep "Free Cmd:"'],py_java_env)
            allCliRet += cliRet
            errMsg += errInfo
            if not peerFlag:
                flag = False
            if len(peerPortIdList) > 0:
                flag = False
                idList = []
                for id in set(peerPortIdList):
                    idList.append(id)
                if lang == "zh":
                    errMsg +=u"\n控制器:"+ str(peerCtrlID) + u"中FreeCmd数值为0的端口为:" + ",".join(idList) + u"。"
                else:
                    errMsg +="\nOn controller:"+ str(peerCtrlID) + u", the value of Free Cmd for port" + ",".join(idList) + " is 0."

        if flag:
            PY_LOGGER.info("Inspect[FCXchg] pass!")
        return flag, allCliRet, errMsg

    except:
        PY_LOGGER.error("Inspect[TGT Resource] catch except of trace back:" + str(traceback.format_exc()))
        return False, allCliRet, errMsg
    finally:
        changeAnyMode2Cli(cli)

def getPeerDebugInfo(cli, cmdList, py_java_env):
    """
    @summary: 登录对端，解析cat /OSM/log/cur_debug/messages |grep "Free Cmd:"回文，获取port/host信息 和 Free Cmd值,并判断是否为零
    @param cliRet: cat /OSM/log/cur_debug/messages |grep "Free Cmd:"回文
    @return: portIdList Port端口ID列表
    """ 
    peerFlag = True
    allCliRet = "" 
    errMsg = ""
    for cmd in cmdList:
        isSuccess, cliRet, errInfo = sendDebugCmd2Peer(cli, cmd, py_java_env, PY_LOGGER)
        if not isSuccess:
            peerFlag = False
        allCliRet += cliRet
        errMsg += errInfo
    portIdList = getFreeCmdPort(allCliRet)
    return peerFlag, allCliRet, portIdList, errMsg

def getFreeCmdPort(cliRet):
    """
    @summary: 解析cat /OSM/log/cur_debug/messages |grep "Free Cmd:"回文，获取port/host信息 和 Free Cmd值,并判断是否为零
    @param cliRet: cat /OSM/log/cur_debug/messages |grep "Free Cmd:"回文
    @return: portIdList Port端口ID列表
    """  
    portIdList = []
    lines = cliRet.splitlines()
    for line in lines:
        portId = ""
        number = "100"
        list = line.split()
        if "Host" in line:
            portId = list[5].split("(")[1].replace(")","")
            number = list[7].split(":")[1].split(".")[0]
        if "Port" in line:
            portId = list[1].split("(")[1].replace(")","")
            number = list[3].split(":")[1].split(".")[0]
        PY_LOGGER.info("portId:" + portId +
                       "\nnumber:" + number)
        if portId != "" and number == "0":
            portIdList.append(portId)
    return set(portIdList)