# -*- coding: UTF-8 -*-
import traceback
from common.utils import *
from common.checkAlarm import *

def execute(cli):
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    try:
        errMsg = ""
        flag, cliRet, errMsg = checkAlarmInfo(cli, py_java_env, WARNING_ALM, PY_LOGGER)
        
        if flag:
            PY_LOGGER.info("Inspect[WarningAlarm] pass!")
        else:
            PY_LOGGER.info("Inspect[WarningAlarm] not pass")
            if not errMsg:
                if "zh" == lang:
                    errMsg = u"\n系统存在警告级别告警。"
                else:
                    errMsg = u"\nOne or more warning alarms exist in the system."
        return flag, cliRet, errMsg
          
    except:
        PY_LOGGER.error("Inspect[WarningAlarm] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
        
