# -*- coding: UTF-8 -*-
import os
import re
import traceback
from common.cTV1R1 import *
from common.utils import *

def _getLocalCtrlName(cliRet):
    """
    # *****************************************************************************************#
    # 函数名称: _getLocalCtrlName(cliRet)
    # 功能说明: 根据回显结果获取当前登录控制器名称
    # 输入参数: cliRet
    # 返 回 值: ctrName
    # *****************************************************************************************#
    """
    formatFunction = cHandleTypeList(cliRet)
    listDict = formatFunction.handle()
    PY_LOGGER.info("Inspect[iSCSILinkSpeed] listDict = " + str(listDict))
    
    for dictInfo in listDict:
        ipAddr = str(dictInfo.get("IP Address"))
        PY_LOGGER.info("Inspect[iSCSILinkSpeed] ipAddr = " + str(ipAddr))
        if not ipAddr:
            continue
        
        PY_LOGGER.info("Inspect[iSCSILinkSpeed] localIp = " + str(getLocalIpAddr(py_java_env)))
        if ipAddr == getLocalIpAddr(py_java_env):
            return str(dictInfo.get("Controller"))
    
    return ""
 
def _getIscsiIpList(cliRet, localCtrlName):
    """
    # *****************************************************************************************#
    # 函数名称: _getIscsiIpList(cliRet, localCtrlName)
    # 功能说明: 根据回显结果获取当前及对端iSCSI IP地址列表
    # 输入参数: cliRet, localCtrlName
    # 返 回 值: localIpList, peerIpList
    # *****************************************************************************************#
    """
    localIpList = []
    peerIpList = []
    
    cliRetList = cliRet.splitlines()
    if len(cliRetList) <= 2:
        return localIpList, peerIpList
    
    #第二个参数传入[]表示获取所有key值对应的value
    formatFunction = cHandleTypeList(cliRet)
    listDict = formatFunction.handle()
    
    #业务iScsi端口没有配置时，直接巡检通过
    if 0 == len(listDict):
        return localIpList, peerIpList
    
    for dictInfo in listDict:
        ctrlId = str(dictInfo.get("Controller"))
        ipAddr = str(dictInfo.get("IP Address"))
        
        if not ctrlId or not ipAddr:
            continue
            
        if localCtrlName == ctrlId:
            localIpList.append(ipAddr)
        else:
            peerIpList.append(ipAddr)
    
    return localIpList, peerIpList

def _getEthName(cliRet, ipAddr):
    """
    # *****************************************************************************************#
    # 函数名称: _getEthName(cliRet, ipAddr)
    # 功能说明: 根据回显结果获取ipAddr对应的端口名称
    # 输入参数: cliRet, ipAddr
    # 返 回 值: ethName
    # *****************************************************************************************#
    """
    ethName = ""
    cliRetList = cliRet.splitlines()
    
    for i in xrange(len(cliRetList)):
        if -1 != cliRetList[i].find(":" + str(ipAddr) + " ") and -1 != cliRetList[i].find("inet addr"):
            ethName = cliRetList[i - 1].split()[0].strip()
    return ethName

def _checkCliRet(cliRet, addrIp):
    """
    # *****************************************************************************************#
    # 函数名称: _checkCliRet(cliRet, addrIp)
    # 功能说明: 根据回显判断连接速率是否正常
    # 输入参数: cliRet, ipAddr
    # 返 回 值: flag, errMsg
    # *****************************************************************************************#
    """
    flag = True
    errMsg = ""
    lang = py_java_env.get("lang")

    formatFunction = cFastTypeDict(cliRet, ":")
    listDict = formatFunction.handle()
    
    for dictInfo in listDict:
        if "yes" != dictInfo.get("Link detected"):
            continue
        elif "1000Mb/s" != dictInfo.get("Speed"):
            flag = False
            PY_LOGGER.info("Inspect[iSCSILinkSpeed] not pass(" + str(addrIp) + " speed abnormal)")
            if "zh" == lang:
                errMsg = u"\n业务网口（" + str(addrIp) + u"）iSCSI连接速率不为1000Mb/s（" + str(dictInfo.get("Speed")) + u"）。"
            else:
                errMsg = u"\nThe iSCSI connection rate of the service network port(" + str(addrIp) + u") is not 1000Mb/s(" + str(dictInfo.get("Speed")) + u")."
    return flag, errMsg
    
def execute(cli):
    flag = True
    cliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    
    try:
        
        localIpList = []
        peerIpList = []
        
        #获取系统是否为单控还是双控
        sysMode, itemCliRet, itemErrMsg = getSysModeState(cli, py_java_env)
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("Inspect[iSCSILinkSpeed] not pass(Get unkown system mode)")
            return False, itemCliRet, itemErrMsg
        
        isDoubleSys = True if MODE_DOUBLE == sysMode else False
        
        #阵列上不存在iSCSI扣卡需要通过，2014/08/08 modified Begin
        cmd = "showiscsiip"
        iscsiCliRet = cliMgt.execCmd(cli, cmd)
        #不存在iSCSI的情况，需要特殊处理
        if len(iscsiCliRet.splitlines()) <= 4 and ("The module ID is error" in iscsiCliRet or "Message can't reachable" in iscsiCliRet):
            PY_LOGGER.info("Inspect[iSCSILinkSpeed] pass!(no iSCSI card)")
            return True, iscsiCliRet, errMsg
        
        preRet, errMsg = preCheckCliRet(cmd, iscsiCliRet, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[iSCSILinkSpeed] not pass(cliRet2 invalid)")
            return False, iscsiCliRet, errMsg
        elif RET_SUC == preRet:
            PY_LOGGER.info("Inspect[iSCSILinkSpeed] pass!(get no iSCSI IP information)")
            return True, iscsiCliRet, errMsg
        #阵列上不存在iSCSI扣卡需要通过，2014/08/08 modified End
        
        #获取本端，对端的iscsi IP地址列表信息
        cmd = "showctrlip"
        ctrCliRet = cliMgt.execCmd(cli, cmd)
        preRet, errMsg = preCheckCliRet(cmd, ctrCliRet, lang)
        if RET_FAIL == preRet:
            PY_LOGGER.error("Inspect[iSCSILinkSpeed] not pass(cliRet invalid)")
            return False, ctrCliRet, errMsg
        localCtrlName = _getLocalCtrlName(ctrCliRet)
        if not localCtrlName:
            if "zh" == lang:
                errMsg = u"\n获取本端IP控制器名称无效。"
            else:
                errMsg = u"\nThe obtained name corresponding to the local controller's IP address is invalid."    
            return False, ctrCliRet, errMsg
        
        PY_LOGGER.info("Inspect[iSCSILinkSpeed] Local name is:" + str(localCtrlName))
        localIpList, peerIpList = _getIscsiIpList(iscsiCliRet, localCtrlName)
        
        cliRet = ctrCliRet + iscsiCliRet 
        if not localIpList and not peerIpList:
            return True, cliRet, errMsg
        
        flag, itemCliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
        cliRet += itemCliRet
        if not flag:
            PY_LOGGER.error("Inspect[iSCSILinkSpeed] not pass(change to debug mode failed)")
            return False, cliRet, errMsg
  
        #本端iSCSI速率判断
        #配置了多个iSCSI IP，巡检工具检查不到部分IP设备名称，2014/08/08 modified Begin
        ifCfgCliRet = cliMgt.execCmd(cli, "ifconfig")
        cliRet += "\n\nController " + str(getLocalIpAddr(py_java_env)) + ":\n" + ifCfgCliRet
        for localIp in localIpList:
            ethName = _getEthName(ifCfgCliRet, localIp)
            #不检查bond端口链路速率 Begin
            if str(ethName).startswith("bond"):
                continue
            #不检查bond端口链路速率 End
            if ethName:
                itemCliRet = cliMgt.execCmd(cli, "ethtool " + ethName)
                cliRet += itemCliRet
                itemFlag, itemErrMsg = _checkCliRet(itemCliRet, localIp)
                if not itemFlag:
                    flag = False
                    errMsg += itemErrMsg
            else:    
                flag = False
                PY_LOGGER.error("Inspect[iSCSILinkSpeed] not pass(Get local eth name failed)")
                if "zh" == lang:
                    errMsg += u"\n获取iSCSI IP（" + str(localIp) + u"）名称信息无效。"
                else:
                    errMsg += u"\nFailed to obtain the name of iSCSI IP(" + str(localIp) + u") address."
        #配置了多个iSCSI IP，巡检工具检查不到部分IP设备名称，2014/08/08 modified End
        
        #单控及对端iScsi IP为空时不处理对端
        if not isDoubleSys or not peerIpList:
            return flag, cliRet, errMsg
        
        #对端iScsi速率判断
        #配置了多个iSCSI IP，巡检工具检查不到部分IP设备名称，2014/08/08 modified Begin
        itemFlag, ifCfgCliRet, itemErrMsg = sendDebugCmd2Peer(cli, "ifconfig", py_java_env, PY_LOGGER)
        cliRet += "\n\nController " + str(getPeerIpAddr(cli, py_java_env)) + ":\n" + ifCfgCliRet
        if not itemFlag:
            flag = False
            PY_LOGGER.error("Inspect[iSCSILinkSpeed] not pass(Send ifconfig failed)")
            errMsg += itemErrMsg
            return flag, cliRet, errMsg
        
        for peerIp in peerIpList:
            ethName = _getEthName(ifCfgCliRet, peerIp)
            #不检查bond端口链路速率 Begin
            if str(ethName).startswith("bond"):
                continue
            #不检查bond端口链路速率 End
            if ethName:
                itemFlag, itemCliRet, itemErrMsg = sendDebugCmd2Peer(cli, "ethtool " + ethName, py_java_env, PY_LOGGER)
                cliRet += itemCliRet
                itemFlag, itemErrMsg = _checkCliRet(itemCliRet, peerIp)
                if not itemFlag:
                    flag = False
                    PY_LOGGER.error("Inspect[iSCSILinkSpeed] not pass(Send ethtool failed)")
                    errMsg += itemErrMsg
            else:    
                flag = False
                PY_LOGGER.error("Inspect[iSCSILinkSpeed] not pass(Get peer eth name failed)")
                if "zh" == lang:
                    errMsg += u"\n获取iSCSI IP（" + str(peerIp) + u"）名称信息无效。"
                else:
                    errMsg += u"\nFailed to obtain the name of iSCSI IP(" + str(peerIp) + u") address."
        #配置了多个iSCSI IP，巡检工具检查不到部分IP设备名称，2014/08/08 modified End
        
        if flag:
            PY_LOGGER.info("Inspect[iSCSILinkSpeed] pass!")
        return flag, cliRet, errMsg

    except:
        PY_LOGGER.error("Inspect[iSCSILinkSpeed] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    finally:
        changeAnyMode2Cli(cli)
