# -*- coding: UTF-8 -*-
import re
from cbb.frame.util.common import wrapAllExceptionLogged
class BackwardsReader: 
    """Read a file line by line, backwards""" 
    BLKSIZE = 4096

    @wrapAllExceptionLogged(logger=None)
    def __init__(self, file): 
        self.file = file
        self.buf = ""
        self.isEnd = False
        self.file.seek(-1, 2)
        index = 1
        while re.match('\s', self.file.read(1)):
            index += 1
            self.file.seek(-index, 2)
    
    def reset(self):
        self.__init__(self.file)
            
    def readline(self): 
        while True: 
            newline_pos = self.buf.rfind("\n") 
            pos = self.file.tell() 
            if newline_pos != -1: 
                line = self.buf[newline_pos + 1:] 
                self.buf = self.buf[:newline_pos] 
                if pos != 0 or newline_pos != 0: 
                    line += "\n" 
                return line 
            else: 
                if pos == 0: 
                    self.isEnd = True
                    return "" 
                else: 
                    toread = min(self.BLKSIZE, pos) 
                    self.file.seek(-toread, 1) 
                    self.buf = self.file.read(toread) + self.buf
                    self.file.seek(-toread, 1) 
                    if pos - toread == 0: 
                        self.file.seek(0)
                        self.buf = "\n" + self.buf 
