# -*- coding: UTF-8 -*-
import re
import os
from cbb.frame.util.tar_util import decompress_tar_all_file
import time
from logMgt import *
from utils import *
import traceback
from BackwardsReader import BackwardsReader

LOG_TIME_STAMP_TAG = "kernel"

#阵列当前日志信息目录
DEVICE_MSG_PATH = "/OSM/log/cur_debug/messages"

#阵列当前日志信息目录
DEVICE_MSG_BAK_PATH = "/OSM/log/cur_debug/"
DEVICE_MSG_BAK_FILENAME = "messages_bak"

#阵列历史日志信息目录
DEVICE_HIS_MSG_PATH = "/OSM/log_conf_local/log/his_debug/"
DEVICE_HIS_MSG_PATH_S2600R2 = "/OSM/coffer_log/log/his_debug/"

#双端符合条件的message文件个数
MSG_NUM = 0

CUR_MSG_SUFFIX = "_cur_messages"
HIS_MSG_SUFFIX = "_his_messages"
BAK_MSG_SUFFIX = "_bak_messages"

def _isLocalExsitLogs(localTmpPath):
    """
    # *****************************************************************************************#
    # 函数名称: _isLocalExsitLogs(localTmpPath)
    # 功能说明: 判断本地是否存在messages文件,防止多个巡检项反复获取
    # 输入参数: localTmpPath
    # 输出参数: True or False
    # *****************************************************************************************#
    """
    if os.path.exists(localTmpPath):
        fileList = os.listdir(localTmpPath)
        for fileName in fileList:
            if fileName.endswith(CUR_MSG_SUFFIX):
                return True
    return False

def _deleteLocalFailedMsg(localTmpPath):
    """
    # *****************************************************************************************#
    # 函数名称: _deleteLocalFailedMsg(localTmpPath)
    # 功能说明: 日志收集失败时，删除已收集的日志信息，防止影响后续的巡检项
    # 输入参数: localTmpPath
    # 输出参数: True or False
    # *****************************************************************************************#
    """
    except_counter = 0
    if os.path.exists(localTmpPath):
        fileList = os.listdir(localTmpPath)
        for fileName in fileList:
            if fileName.endswith("_messages"):
                try:
                    os.remove(localTmpPath + fileName)
                except:
                    except_counter += 1
    return
     
def _getHisLatestLogDir(cliRet, curTimeStamp, interval=180):
    """
    # *****************************************************************************************#
    # 函数名称: _getHisLatestLogDir(cliRet, curTimeStamp, interval = 180)
    # 功能说明: 根据回显结果获取最新的一次历史日志目录信息
    # 输入参数: cliRet
    # 输出参数: 最新一次历史日志信息，返回全路径，无返回为空
    # *****************************************************************************************#
    """
    
    if not cliRet:
        return ""
    
    hisTarNameList = []
    cliRetList = cliRet.splitlines()
    
    for lineInfo in cliRetList:
        if re.search("his_tar_[0-9]{12,}\.tgz", lineInfo, re.IGNORECASE):
            hisTarNameList.append(lineInfo[lineInfo.find("his_tar_"):].strip())
    
    if hisTarNameList:
        hisTarNameList.sort()
        latestHisName = str(hisTarNameList[-1])
        latestHisName = latestHisName[0:latestHisName.rfind(".tgz") + 4]
        hisTimeStamp = latestHisName[latestHisName.find("his_tar_") + len("his_tar_"):latestHisName.rfind(".tgz")]
       
        #日志文件是否在需要的区间范围内，日志时间戳为最后一条日志的打印时间
        if (formatTimeStamp2Sec(curTimeStamp) - formatTimeStamp2Sec(hisTimeStamp)) < interval * 24 * 60 * 60:
            if DEVICE_HIS_MSG_PATH in cliRet:
                return DEVICE_HIS_MSG_PATH + latestHisName
            else:
                return DEVICE_HIS_MSG_PATH_S2600R2 + latestHisName
    return ""
   
def _decompressLocalFile(filePath):
    """
    # *****************************************************************************************#
    # 函数名称: _decompressLocalFile(filePath)
    # 功能说明: 解压本地压缩文件
    # 输入参数: filePath
    # 输出参数: 无
    # *****************************************************************************************#
    """
    if os.path.exists(filePath) and filePath.endswith(".tgz"):
        decompress_tar_all_file(filePath, os.path.dirname(filePath), "r")
    return 

def _decompressDevFile(cli, py_java_env, obsDevicePath, ipAddr):
    """
    # *****************************************************************************************#
    # 函数名称: _decompressDevFile(cli, py_java_env, obsDevicePath, ipAddr)
    # 功能说明: 解压阵列最近一次压缩文件到阵列临时目录下
    # 输入参数: cli, py_java_env, obsDevicePath, ipAddr
    # 输出参数: 无
    # *****************************************************************************************#
    """
    if not obsDevicePath:
        return
    
    devTmpFilePath = os.path.dirname(obsDevicePath) if "/" == os.path.dirname(obsDevicePath)[-1] else os.path.dirname(obsDevicePath) + "/"
    
    sftp = py_java_env.get("sftp")
    initSftp(sftp)
    if not sftp.isFileExist(devTmpFilePath, os.path.basename(obsDevicePath)):
        return 
    
    #创建临时文件先删除之前的tmp目录
    cliMgt.execCmd(cli, "rm -rf " + devTmpFilePath + "tmp")
    cliMgt.execCmd(cli, "mkdir " + devTmpFilePath + "tmp")
    
    #解压缩最新的压缩文件到tmp目录中
    cliMgt.execCmd(cli, "tar xzvf " + obsDevicePath + " -C " + devTmpFilePath + "tmp")
    
    #拷贝文件到/tmp目录后并修改文件名字
    fileName = os.path.basename(obsDevicePath)
    timeStamp = fileName[fileName.find("his_tar_") + len("his_tar_"):fileName.rfind(".tgz")]
    
    hisMsgDir = devTmpFilePath + ipAddr + "_" + timeStamp + HIS_MSG_SUFFIX
    cliRet = cliMgt.execCmd(cli, "mv " + devTmpFilePath + "tmp/messages " + hisMsgDir)
    #历史文件里不存在message文件情况，2014/08/08 modified Begin
    if "No such file or directory" not in cliRet:
        global MSG_NUM
        MSG_NUM += 1
    #历史文件里不存在message文件情况，2014/08/08 modified End
    
    #删除存放解压文件的临时目录
    cliMgt.execCmd(cli, "rm -rf " + devTmpFilePath + "tmp")
    cliMgt.execCmd(cli, "rm -rf " + obsDevicePath)
    
    return 
    
def _getLogModifyTimeStamp(lineInfo, curYear):
    """
    # *****************************************************************************************#
    # 函数名称: _getLogModifyTimeStamp(lineInfo, curYear)
    # 功能说明: 根据ls -l回显信息获取文件的最后一次修改的时间戳信息
    # 输入参数: lineInfo, curYear（当前年份）
    # 输出参数: 文件最后一次修改的时间戳信息（格式为“20140628145802”字符串）
    # *****************************************************************************************#
    """
    logTimeStamp = ""
    lineSplit = lineInfo.split()
    
    #执行ls -l命令后，年份与当前年份不同时，显示格式为：Nov 17  2005 文件名
    if -1 == lineSplit[-2].find(":") and  4 == len(lineSplit[-2]):
        year = lineSplit[-2]
        digitMonth = MONTH_NAME_ABBRE.get(lineSplit[-4].strip())
        days = lineSplit[-3]
        logTimeStamp = (year + digitMonth + days).ljust(14, "0")
    #执行ls -l命令后，年份与当前年份相时，显示格式为：Jul 25 13:52 文件名    
    elif -1 != lineSplit[-2].find(":"):
        digitMonth = MONTH_NAME_ABBRE.get(lineSplit[-4].strip())
        days = lineSplit[-3]
        times = lineSplit[-2].replace(":", "")
        logTimeStamp = (curYear + digitMonth + days + times).ljust(14, "0")
    return logTimeStamp


def _mvDevLocalLogFile(cli, py_java_env, ipAddr, curTimeStamp, PY_LOGGER, interval=180):
    """
    # *****************************************************************************************#
    # 函数名称: _mvDevLocalLogFile
    #           (cli, py_java_env, ipAddr, curTimeStamp, PY_LOGGER, interval=180)
    # 功能说明: 移动本端当前日志及最近一次的历史日志到"/OSM/时间戳ToolTmp"临时目录下
    # 输入参数: cli, py_java_env, ipAddr, curTimeStamp, PY_LOGGER, interval=180
    # 输出参数: 无
    # *****************************************************************************************#
    """
    global MSG_NUM
    
    devTmpFilePath = getDevTmpFilePath(py_java_env)
    
    #移动当前文件到devTmpFilePath目录下并修改名字
    localCurDir = devTmpFilePath + ipAddr + "_" + curTimeStamp + CUR_MSG_SUFFIX
    cliRet = cliMgt.execCmd(cli, "cp " + DEVICE_MSG_PATH + " " + localCurDir)
    PY_LOGGER.info("[_mvDevLocalLogFile]Execute cmd(cur): " + "cp " + DEVICE_MSG_PATH + " " + localCurDir)
    
    MSG_NUM += 1
    if re.search("overwrite", cliRet, re.IGNORECASE):
        cliRet = cliMgt.execCmd(cli, "y")
    
    #巡检时message_bak文件存在时需要取出分析，2014/08/08 modified Begin
    if isDevFileExsit(py_java_env, DEVICE_MSG_BAK_PATH, DEVICE_MSG_BAK_FILENAME):
        cliRet = cliMgt.execCmd(cli, "ll " + DEVICE_MSG_BAK_PATH + DEVICE_MSG_BAK_FILENAME)
        lines = cliRet.splitlines()
        for line in lines:
            if len(line.split()) > 5:
                year = curTimeStamp[0:4]
                timeStamp = _getLogModifyTimeStamp(line, year)
                hisMsgDir = devTmpFilePath + ipAddr + "_" + timeStamp + BAK_MSG_SUFFIX
                cliRet = cliMgt.execCmd(cli, "cp " + DEVICE_MSG_BAK_PATH + DEVICE_MSG_BAK_FILENAME + " " + hisMsgDir)
                PY_LOGGER.info("[_mvDevLocalLogFile]Execute cmd(his): " + "cp " + DEVICE_MSG_BAK_PATH + DEVICE_MSG_BAK_FILENAME + " " + hisMsgDir)
                MSG_NUM += 1
                return
    #巡检时message_bak文件存在时需要取出分析，2014/08/08 modified End
    else:    
        #获取本端最近一次日志的全路径
        cliRet = cliMgt.execCmd(cli, "ls -l " + DEVICE_HIS_MSG_PATH)
        if "No such file or directory" in cliRet:
            cliRet = cliMgt.execCmd(cli, "ls -l " + DEVICE_HIS_MSG_PATH_S2600R2)
            if "No such file or directory" in cliRet:
                return
            
        latestLogDir = _getHisLatestLogDir(cliRet, curTimeStamp, interval)
        PY_LOGGER.info("[_mvDevLocalLogFile]Get local latest log dir is:" + latestLogDir)
        
        if latestLogDir:
            #拷贝最新一次历史文件到临时目录
            cliRet = cliMgt.execCmd(cli, "cp " + latestLogDir + " " + devTmpFilePath)
            PY_LOGGER.info("[_mvDevLocalLogFile]Execute cmd(his): " + "cp " + latestLogDir + " " + devTmpFilePath)
            if re.search("overwrite", cliRet, re.IGNORECASE):
                cliRet = cliMgt.execCmd(cli, "y")
            
            #解压得到最新一次的历史日志
            _decompressDevFile(cli, py_java_env, devTmpFilePath + os.path.basename(latestLogDir), ipAddr)
    return

def _mvDevPeerLogFile(cli, py_java_env, ipAddr, curTimeStamp, PY_LOGGER, interval=180):
    """
    # *****************************************************************************************#
    # 函数名称: _mvDevPeerLogFile
    #           (cli, py_java_env, ipAddr, curTimeStamp, PY_LOGGER, interval=180)
    # 功能说明: 移动对端当前日志及最近一次的历史日志到"/OSM/时间戳ToolTmp"临时目录下
    # 输入参数: cli, py_java_env, ipAddr, curTimeStamp, PY_LOGGER, interval=180
    # 输出参数: 无
    # *****************************************************************************************#
    """
    global MSG_NUM
    
    devTmpFilePath = getDevTmpFilePath(py_java_env)
    
    #移动对端当前日志信息到本端"/OSM/时间戳ToolTmp"临时目录下
    scpPeerFile(cli, DEVICE_MSG_PATH, py_java_env, devTmpFilePath)
    MSG_NUM += 1
    
    #移动当前文件到devTmpFilePath目录下并修改名字
    peerCurDir = devTmpFilePath + ipAddr + "_" + curTimeStamp + CUR_MSG_SUFFIX
    cliMgt.execCmd(cli, "mv " + devTmpFilePath + "messages " + peerCurDir)
    PY_LOGGER.info("[_mvDevPeerLogFile]Execute cmd: " + "mv " + devTmpFilePath + "messages " + peerCurDir)
    
    latestLogDir = ""
    flag, cliRet, errMsg = sendDebugCmd2Peer(cli, "ls -l " + DEVICE_MSG_BAK_PATH + DEVICE_MSG_BAK_FILENAME, py_java_env, PY_LOGGER)
    if not cliRet or  "No such file or directory" in cliRet:
        #获取本对端最近一次日志的全路径
        flag, cliRet, errMsg = sendDebugCmd2Peer(cli, "ls -l " + DEVICE_HIS_MSG_PATH, py_java_env, PY_LOGGER)
        #兼容S2600V1R2
        if not cliRet or  "No such file or directory" in cliRet:
            flag, cliRet, errMsg = sendDebugCmd2Peer(cli, "ls -l " + DEVICE_HIS_MSG_PATH_S2600R2, py_java_env, PY_LOGGER)
            if not cliRet or  "No such file or directory" in cliRet:
                return
        latestLogDir = _getHisLatestLogDir(cliRet, curTimeStamp, interval)
        PY_LOGGER.info("[_mvDevPeerLogFile]Get peer latest log dir is:" + latestLogDir)
        if latestLogDir:
        
            #拷贝最新一次历史文件到临时目录
            scpPeerFile(cli, latestLogDir, py_java_env, devTmpFilePath)
            
            #解压得到最新一次的历史日志
            _decompressDevFile(cli, py_java_env, devTmpFilePath + os.path.basename(latestLogDir), ipAddr)       
    #巡检时message_bak文件存在时需要取出分析，2014/08/08 modified Begin
    else:
        lines = cliRet.splitlines()
        for line in lines:
            if len(line.split()) > 5:
                year = curTimeStamp[0:4]
                timeStamp = _getLogModifyTimeStamp(line, year)
                
                #拷贝最新一次历史文件到临时目录
                scpPeerFile(cli, DEVICE_MSG_BAK_PATH + DEVICE_MSG_BAK_FILENAME, py_java_env, devTmpFilePath)
            
                hisMsgDir = devTmpFilePath + ipAddr + "_" + timeStamp + BAK_MSG_SUFFIX
                
                cliMgt.execCmd(cli, "mv " + devTmpFilePath + DEVICE_MSG_BAK_FILENAME + " " + hisMsgDir)
                MSG_NUM += 1
    #巡检时message_bak文件存在时需要取出分析，2014/08/08 modified End
    return

def _mvDevLogFile2Local(cli, py_java_env, PY_LOGGER, curTimeStamp, interval=180, isGetDoubleFile=True):
    """
    # *****************************************************************************************#
    # 函数名称: _mvDevLogFile2Local(cli, py_java_env, PY_LOGGER, interval= 180, isGetDoubleFile = True)
    # 功能说明: 移动当前日志及最近一次的历史日志到"/OSM/时间戳ToolTmp"临时目录下
    # 输入参数: cli, py_java_env, PY_LOGGER, interval= 180, isGetDoubleFile = True
    #           interval：日志产生的时间范围
    #           isGetDoubleFile：关键字的检查是否检查双边日志（默认检查双边）
    # 输出参数: 无
    # *****************************************************************************************#
    """
    try:
        #阵列上"/OSM/时间戳ToolTmp"临时目录
        devTmpFilePath = getDevTmpFilePath(py_java_env)
        
        PY_LOGGER.info("[checkMsgInfo] Get device file to local: " + devTmpFilePath)
        
        #拷贝前先强制删除"/OSM/时间戳ToolTmp"临时目录
        cliMgt.execCmd(cli, "rm -rf " + devTmpFilePath)
        cliMgt.execCmd(cli, "mkdir " + devTmpFilePath)
        
        #拷贝本端当前日志及最近一次的历史日志到"/OSM/时间戳ToolTmp"临时目录下
        _mvDevLocalLogFile(cli, py_java_env, getLocalIpAddr(py_java_env), curTimeStamp, PY_LOGGER, interval)
        
        if isGetDoubleFile:
            #拷贝对端当前日志及最近一次的历史日志到"/OSM/时间戳ToolTmp"临时目录下
            _mvDevPeerLogFile(cli, py_java_env, getPeerIpAddr(cli, py_java_env), curTimeStamp, PY_LOGGER, interval)
        
        #打包"/OSM/时间戳ToolTmp"临时目录文件
        tmpTagName = "tmp.tgz"
        
        cliMgt.execCmd(cli, "cd " + devTmpFilePath)
        cliMgt.execCmd(cli, "tar zcvf " + tmpTagName + " " + "*messages")
        
        #获取文件到本地
        sftp = py_java_env.get("sftp")
        
        PY_LOGGER.info("[_mvDevLogFile2Local] The device tmp dir is:" + devTmpFilePath + tmpTagName)
        except_counter = 0
        if isDevFileExsit(py_java_env, devTmpFilePath, tmpTagName):
            if not os.path.exists(LOCAL_TEMP_DIR):
                os.mkdir(LOCAL_TEMP_DIR)
            initSftp(sftp)   
            sftp.getFile(devTmpFilePath + tmpTagName, getLocaTmplFilePath(py_java_env), None)
            
            #解压本地压缩包
            _decompressLocalFile(getLocaTmplFilePath(py_java_env) + tmpTagName)
            
            #删除本地压缩包
            try:
                os.remove(getLocaTmplFilePath(py_java_env) + tmpTagName)
            except:
                except_counter += 1
        else:
            PY_LOGGER.error("[_mvDevLogFile2Local] File not exist in device.")
                
        #阵列返回开始进入路径
        cliMgt.execCmd(cli, "cd /root")
    except:
        PY_LOGGER.error("[_mvDevLogFile2Local] Catch except of trace back:" + str(traceback.format_exc())) 
        raise
    finally:
        PY_LOGGER.info("[_mvDevLogFile2Local] Execute cmd: rm -rf " + devTmpFilePath) 
        cliMgt.execCmd(cli, "rm -rf " + devTmpFilePath) 
    

def _isLogCollectSucc(localTmpPath):
    """
    # *****************************************************************************************#
    # 函数名称: _isLogCollectSucc(localTmpPath)
    # 功能说明: 判断本地获取的日志文件个数是否满足条件
    # 输入参数: devTmpFilePath
    # 输出参数: True or False
    # *****************************************************************************************#
    """
    msgNum = 0
    if os.path.exists(localTmpPath):
       fileList = os.listdir(localTmpPath)
       for fileName in fileList:
           if fileName.endswith("_messages") and (not fileName.startswith("Flash")):
               msgNum += 1
    return True if MSG_NUM == msgNum else False

def _parseLogMsg(localFileDir, curTimeStamp, reKeyWord, PY_LOGGER, interval=180, isLogWithYear=False):
    
    """
    # *****************************************************************************************#
    # 函数名称: _parseLogMsg(localFileDir, curTimeStamp, reKeyWord, PY_LOGGER, interval=180)
    # 功能说明: 解析日志文件，判断是否含有关键字信息reKeyWord
    # 输入参数: localFileDir, reKeyWord, interval= 180
    # 输出参数: flag为False时，表示日志分析失败
    #           flag为True时，表示日志分析成功，msg确定是否含有关键字信息
    # *****************************************************************************************#
    """
    flag = True
    msg = ""
    keyLine = ""
    
    try:
        
        msgRecord = []
        maxJif = 0
        
        #参数检查
        if not localFileDir:
            PY_LOGGER.error("[_parseLogMsg] localFileDir is blank: " + str(localFileDir))
            return False, msg
        
        #文件不存在直接返回
        if not os.path.exists(localFileDir):
            PY_LOGGER.error("[_parseLogMsg] the file [" + str(localFileDir) + "] is not exists.")
            return False, msg
        
        baseName = os.path.basename(localFileDir)
        logTimeStamp = baseName.split("_")[1]
        
        f = open(localFileDir, "rb")
        br = BackwardsReader(f)
        
        #防止各个版本间日志信息格式不一样，选择是否带年份前再次判断
        if not isLogWithYear:
            isLogWithYear = isLogWithYears(br.readline())
            br.reset()
        
        PY_LOGGER.info("[_parseLogMsg] isLogWithYear:" + str(isLogWithYear))

        #对于日志存在年份的情况，不需要考虑jiffe的差异    
        if isLogWithYear:
            while not br.isEnd:
                lineInfo = br.readline()
                keyLine = lineInfo
                if re.search(reKeyWord, lineInfo, re.IGNORECASE):
                    lineTimeStamp = getLineTimeStamp(lineInfo)
                    if not lineTimeStamp or countTimeSpanOfSecs(curTimeStamp, lineTimeStamp, 0, 0) < interval * 24 * 60 * 60:
                        msgRecord.insert(0, lineInfo)
                    else:
                        break 
        else:
            while not br.isEnd:
                lineInfo = br.readline()
                keyLine = lineInfo
                #找到日志中最后带有jif的一行
                if 0 == maxJif and re.match(".*" + LOG_JIF_TAG + "\W+[0-9]+\W.*", lineInfo, re.IGNORECASE):
                    PY_LOGGER.info("[_parseLogMsg]maxJif lineInfo: " + unicode(lineInfo))
                    maxJif = getLineJiffe(lineInfo, LOG_JIF_TAG)
                    if maxJif < 0:
                        flag = False
                        PY_LOGGER.error("[_parseLogMsg] Get wrong maxJif information: " + str(maxJif))
                        break
                   
                    PY_LOGGER.info("[_parseLogMsg] Before adjust time stamp is:" + str(logTimeStamp) + ", lineInfo is:" + lineInfo)
                    logTimeStamp = adjustLogTimeStamp(lineInfo, LOG_JIF_TAG, logTimeStamp, PY_LOGGER)
                    PY_LOGGER.info("[_parseLogMsg] After adjust time stamp is:" + str(logTimeStamp) + ", maxJif is:" + str(maxJif))
                
                #找到带有关键字的一行，并判断是否在时间区间范围内
                if 0 != maxJif and re.search(reKeyWord, lineInfo, re.IGNORECASE):
                    curJif = getLineJiffe(lineInfo, LOG_JIF_TAG)

                    if curJif >= 0 and countTimeSpanOfSecs(curTimeStamp, logTimeStamp, maxJif, curJif) > interval * 24 * 60 * 60:
                        break
                    else:
                        msgRecord.insert(0, lineInfo)
        
        #按照时间先后顺序显示
        for record in msgRecord:
            msg += record
        
        f.close()
        return flag, msg
        
    except:
        PY_LOGGER.error("[_parseLogMsg]keyLine: " + unicode(keyLine))
        PY_LOGGER.error("[_parseLogMsg] catch except of trace back:" + str(traceback.format_exc()))
        return False, msg

def checkMsg(localTmpPath, PY_LOGGER, curTimeStamp, reKeyWord, ipAddr, lang, interval=180, isLogWithYear=False):
    """
    # *****************************************************************************************#
    # 函数名称: checkMsg(localTmpPath, curTimeStamp, reKeyWord, ipAddr, lang, interval=180)
    # 功能说明: 解析日志文件，判断是否含有关键字信息reKeyWord
    # 输入参数: curTimeStamp, reKeyWord, ipAddr, lang, interval=180
    # 输出参数: flag, cliRet, errMsg, existKeyWord
    # *****************************************************************************************#
    """
    flag = True
    existKeyWord = False
    cliRet = ""
    errMsg = ""
    
    curMsg = ""
    hisMsg = ""
    
    for filName in os.listdir(localTmpPath):
        absDir = localTmpPath + filName
        if ipAddr in filName and filName.endswith(CUR_MSG_SUFFIX):
            PY_LOGGER.info("[checkMsg] Start to parse local file(" + str(absDir) + ", " + str(curTimeStamp) + ").")
            parseSuc, curMsg = _parseLogMsg(absDir, curTimeStamp, reKeyWord, PY_LOGGER, interval, isLogWithYear)
            if not parseSuc:
                flag = False
                PY_LOGGER.error("[checkMsg] Failed cur file: " + str(curMsg))
                if "zh" == lang:
                    errMsg += u"\n控制器（" + ipAddr + u"）当前日志分析失败。"
                else:
                    errMsg += u"\nFailed to analyze the current messages of controller(" + ipAddr + ")."
        elif ipAddr in filName and filName.endswith(HIS_MSG_SUFFIX):
            PY_LOGGER.info("[checkMsg] Start to parse peer file(" + str(absDir) + ", " + str(curTimeStamp) + ").")
            parseSuc, hisMsg = _parseLogMsg(absDir, curTimeStamp, reKeyWord, PY_LOGGER, interval, isLogWithYear)
            if not parseSuc:
                flag = False
                PY_LOGGER.error("[checkMsg] Failed his file: " + str(curMsg))
                if "zh" == lang:
                    errMsg += u"\n控制器（" + ipAddr + u"）最近历史日志分析失败。"
                else:
                    errMsg += u"\nFailed to analyze the latest history messages of controller(" + ipAddr + ")."   
        elif ipAddr in filName and filName.endswith(BAK_MSG_SUFFIX):
            PY_LOGGER.info("[checkMsg] Start to parse bak file(" + str(absDir) + ", " + str(curTimeStamp) + ").")
            parseSuc, hisMsg = _parseLogMsg(absDir, curTimeStamp, reKeyWord, PY_LOGGER, interval, isLogWithYear)
            if not parseSuc:
                flag = False
                PY_LOGGER.error("[checkMsg] Failed bak file: " + str(curMsg))
                if "zh" == lang:
                    errMsg += u"\n控制器（" + ipAddr + u"）messages_bak日志分析失败。"
                else:
                    errMsg += u"\nFailed to analyze the messages_bak file of controller(" + ipAddr + ")."   
    cliRet = hisMsg + curMsg
    
    PY_LOGGER.info("[checkMsg] Get contain key word lines information:" + str(cliRet))
    if cliRet:
        flag = False
        existKeyWord = True
    return flag, cliRet, errMsg, existKeyWord
        

def init(logStampTag, curLogDir, hisLogDir):
    global LOG_TIME_STAMP_TAG, MSG_NUM
    global DEVICE_MSG_PATH, DEVICE_MSG_BAK_PATH, DEVICE_MSG_BAK_FILENAME
    global DEVICE_HIS_MSG_PATH, DEVICE_HIS_MSG_PATH_S2600R2
    
    LOG_TIME_STAMP_TAG = logStampTag

    #阵列当前日志信息目录
    DEVICE_MSG_PATH = curLogDir + "messages"
    
    #阵列当前日志信息目录
    DEVICE_MSG_BAK_PATH = curLogDir
    DEVICE_MSG_BAK_FILENAME = "messages_bak"
    
    #阵列历史日志信息目录
    DEVICE_HIS_MSG_PATH = hisLogDir
    
    MSG_NUM = 0
    
    return
    
def checkMsgInfo(cli, py_java_env, reKeyWord, PY_LOGGER, interval=180, isLogWithYear=False):
    """
    # *****************************************************************************************#
    # 函数名称: checkMsgInfo(cli, py_java_env, reKeyWord, PY_LOGGER, interval= 180)
    # 功能说明: 默认处理双边，检查日志文件（默认双边）在间隔时间内（默认半年）是有有包含reKeyWord的信息
    # 输入参数: cli, py_java_env, reKeyWord, PY_LOGGER, interval=180
    #           reKeyWord：某行包含的关键字列表，可采用正则方式匹配
    #           interval：捕捉关键字的最大时间间隔（默认半年）
    # 输出参数: flag（检查是否通过）, cliRet, errMsg, existKeyWord（日志中存在关键字）
    # *****************************************************************************************#
    """
    flag = True 
    cliRet = ""
    errMsg = "" 
    global MSG_NUM
    existKeyWord = False
    
    lang = py_java_env.get("lang")
    
    try:
        MSG_NUM = 0
        #获取此次巡检本地存在临时日志目录，时间戳以记录的本次工具启动时间为准
        localTmpPath = getLocaTmplFilePath(py_java_env)
        PY_LOGGER.info("[checkMsgInfo] Get local path is:" + str(localTmpPath))
        
        #获取系统是否为单控还是双控
        sysMode, cliRet, errMsg = getSysModeState(cli, py_java_env)
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("[checkMsgInfo] not pass(Get unkown system mode)")
            return False, cliRet, errMsg, existKeyWord
        
        isCheckDouble = True if MODE_DOUBLE == sysMode else False
          
        #模式切换
        isSuccess, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
        if not isSuccess:
            PY_LOGGER.error("[checkMsgInfo] not pass(change to debug failed)")
            return False, cliRet, errMsg, existKeyWord
         
        #获取阵列当前时间，返回格式为20140628145802格式
        #时间戳调整有问题，2014/08/08 modified Begin
        curTimeStamp = formatSec2TimeStamp(formatTimeStamp2Sec(getCurDevTime(cli)) + 300)
        #时间戳调整有问题，2014/08/08 modified End
        
        PY_LOGGER.info("[checkMsgInfo] The current time of system is: " + str(curTimeStamp))
        
        #本地日志文件是否存在，若是不存在获取阵列日志信息到本地
        if _isLocalExsitLogs(localTmpPath):
            PY_LOGGER.info("[checkMsgInfo] File exist in local, no need get it from device.")
        else:
            #下载文件前判断系统内存是否足够
            flag, cliRet, errMsg = isEnoughMem(cli, py_java_env)
            if not flag:
                PY_LOGGER.error("[checkMsgInfo] not pass(not have enough memory)")
                return False, cliRet, errMsg, existKeyWord
            
            mkLocalTmpPath(localTmpPath)
            
            #下载日志默认下载180天
            _mvDevLogFile2Local(cli, py_java_env, PY_LOGGER, curTimeStamp, interval, isCheckDouble)
            if not _isLogCollectSucc(localTmpPath):
                flag = False
                PY_LOGGER.error("[checkMsgInfo] not pass(file num is wrong, must be:" + str(MSG_NUM) + ").")
                if "zh" == lang:
                    errMsg = u"\n获取日志文件失败。"
                else:
                    errMsg = u"\nFailed to get the message."
                
                PY_LOGGER.info("[checkMsgInfo] Get file failed, delete file:" + localTmpPath)   
                #文件获取失败时，为了防止影响下次的分析，删除收集不全的日志信息
                _deleteLocalFailedMsg(localTmpPath)
                return False, cliRet, errMsg, existKeyWord

        #本端日志分析
        cliRet = ""
        PY_LOGGER.info("[checkMsgInfo] Start to parse local messages!")
        localIp = getLocalIpAddr(py_java_env)
        itemFlag, itemCliRet, itemErrMsg, itemExistKeyWord = checkMsg(localTmpPath, PY_LOGGER, curTimeStamp, reKeyWord, localIp, lang, interval, isLogWithYear)
        #返回False时，存在解析异常及存在关键字的情况，需要分开处理
        if not itemFlag:
            flag = False
            errMsg += itemErrMsg
            if itemExistKeyWord:
                existKeyWord = True
                cliRet += "\nController " + str(localIp) + ":\n" + itemCliRet  
                PY_LOGGER.error("[checkMsgInfo] Local messages contains key word information")   
            else:
                PY_LOGGER.error("[checkMsgInfo] Failed to parse local messages!")   
        
        #对端日志分析
        if isCheckDouble:
            PY_LOGGER.info("[checkMsgInfo] Start to parse peer messages!")
            peerIp = getPeerIpAddr(cli, py_java_env)
            itemFlag, itemCliRet, itemErrMsg, itemExistKeyWord = checkMsg(localTmpPath, PY_LOGGER, curTimeStamp, reKeyWord, peerIp, lang, interval, isLogWithYear)
            #返回False时，存在解析异常及存在关键字的情况，需要分开处理
            if not itemFlag:
                flag = False
                errMsg += itemErrMsg
                if itemExistKeyWord:
                    existKeyWord = True
                    cliRet += "\nController " + str(peerIp) + ":\n" + itemCliRet  
                    PY_LOGGER.error("[checkMsgInfo] Peer messages contains key word information")   
                else:
                    PY_LOGGER.error("[checkMsgInfo] Failed to parse peer messages!")  
                
        return flag, cliRet, errMsg, existKeyWord
        
    except:
        PY_LOGGER.error("[checkMsgInfo] catch except of trace back:" + str(traceback.format_exc())) 
        return False, cliRet, getExceptionMsg(lang), existKeyWord
    finally:
        changeAnyMode2Cli(cli)
        
