# -*- coding: UTF-8 -*-
import os

#没有异常时统一在CLI回显处的提示
NO_INFO_MSG = "No information."

CLI_NORMAL_INFO = "command operates successfully|license|not exist|not support|Command executed ok"

MONTH_NAME_ABBRE = {"Jan":"01", "Feb":"02", "Mar":"03", "Apr":"04",
                  "May":"05", "Jun":"06", "Jul":"07", "Aug":"08",
                  "Sep":"09", "Oct":"10", "Nov":"11", "Dec":"12"}

#有效告警时间范围(天)
VALID_ALM_DAYS = 180

#巡检几种结果定义
PASS = True
NOT_PASS = False
NO_CHECK = "NOCHECK"
NO_SUPPORT = "NOSUPPORT"
WARNING = "WARNING"

#回显几种结果
RET_OK = "notSure"
RET_SUC = PASS
RET_FAIL = NOT_PASS

#模式定义
MODE_CLI = 0
MODE_DEBUG = 1
MODE_MML = 2
MODE_ERR = 3

#返回值下标定义
RET_FLAG = 0
RET_CLI = 1
RET_ERR_MSG = 2

RET_LOCAL_CLI = 1
RET_PEER_CLI = 2


ISM_VER = "ISM"
OSM_VER = "OSM"
UNKOWN_VER = "UNKOWN"

TIME_STAMP_LEN = 14

LOG_JIF_TAG = "kernel"

S26_LOG_TAG = "kernel"
S50_LOG_TAG = "kernel"

#基于设备版本号
class DevPro:
    
    UnKnown = ""
    
    S2000V100R001 = "S2000V100R001"
    
    S2600V100R001 = "S2600V100R001"
    S2600V100R002 = "S2600V100R002"
    S2600V100R005 = "S2600V100R005"
    
    S5000V100R001 = "S5000V100R001"
    S5000V100R002 = "S5000V100R002"
    S5000V100R005 = "S5000V100R005"

    S6800V100R002 = "S6800V100R002"
    S6800V100R005 = "S6800V100R005"
    
#基于设备类型和版本号，将设备分为几种类型
#相同的类型，对于export命令的处理方式相同
class DevModel:
    
    UnKnown = ""
    
    #S2000型号
    S2000OSM = "S2000_OSM"    #OSM版本,导出告警和日志是不同的命令,无参数-t
    S2000ISM = "S2000_ISM"    #ISM版本,导出告警和日志是一条命令,要加参数-t
    
    #S2600型号
    S2600OLD = "S2600_OLD"  #S2600 R2 的1.04.02.108.T01之前的版本, 对于告警和日志,使用txt后缀
    S2600NEW = "S2600_NEW"  #S2600 R2 的1.04.02.108.T01及后续版本, 对于告警和日志,使用TAR后缀  
    
    #S5000型号
    S5000OSM = "S5000_OSM"    #OSM版本,导出告警和日志是不同的命令,无参数-t
    S5000ISM = "S5000_ISM"    #ISM版本,导出告警和日志是一条命令,要加参数-t


#ISM和OSM版本范围
ISM_VER_LIST = [DevModel.S2000ISM,DevModel.S5000ISM,DevModel.S2600OLD,DevModel.S2600NEW]
OSM_VER_LIST = [DevModel.S2000OSM,DevModel.S5000OSM]

MODE_SINGLE = "single"
MODE_DOUBLE = "double"
MODE_UNKOWN = "unkown"

#S2000的版本都是102开头的
S2000_VERSION = "102"
#S2600的版本都是104开头的
S2600_VERSION = "104"
#S5000的版本都是103开头的
S5000_VERSION = "103"

#S5000V1R1的版本都是10301开头的
S5000R1_VERSION = "10301"

#1020125101之前的版本是OSM版本；1020125101及之后的版本，是ISM版本
S2000R1_ISM_VERSION = "1020125101"

#1030115001之前的版本是OSM版本；1030115001及之后的版本，是ISM版本
S5000R1_ISM_VERSION = "1030115001"  #1030115001之前的版本是OSM版本；1030115001及之后的版本，是ISM版本

#S2600 R2 的1.04.02.108.T01及后续版本, 对于告警和日志,使用TAR后缀
S2600R2_NEW_VERSION = "1040210801"

#空闲内存最小要求
MAX_FREE_MEM = 50
 
#阵列本端临时存放对端信息的路径
LOCAL_DEVICE_TEMP_PATH = "/tmp/"

#本地保存收集信息的目录
LOCAL_TEMP_DIR = os.getcwd() + os.path.sep + "tmp" + os.path.sep

