#coding:utf-8
import re

def _list2NumDic(elesList):
    """
    # *****************************************************************************************#
    # 【函数名称】 _list2NumDic
    # 【功能说明:】对列表元素进行统计形成字典（key：元素的值，value：元素的个数）,注意：只是构造的字典都是次数为5次及以上的
    # 【输入参数】 elesList:元素列表
    # 【输出参数】 numDict：元素值为key，元素对应个数为value的字典
    # 【例子】 elesList =["a","b","c","a"] ==_list2NumDic(elesList)==> {"a":2,"b":1,"c":1}
    # *****************************************************************************************#
    """
    numDict ={}
    myset = set(elesList)  #myset是另外一个列表，里面的内容是mylist里面的无重复 项 
    for item in myset:
        #对应元素的次数
        eleCount = elesList.count(item)
        numDict[item] = elesList.count(item)
    return  numDict

#No3:转换成行数等于或大于num值的字典
def _numDic2MoreSomeNumDic(numDic,num):
    """
    # *****************************************************************************************#
    # 【函数名称】 _numDic2MoreSomeNumDic
    # 【功能说明:】将No2中形成的带有计数的字典转换成等于或大于num次数的字典
    # 【输入参数】 numDic:No2中形成的带有计数的字典，num：同块硬盘重复出现闪断记录的行数
    # 【输出参数】 resultDic：转换成的记录行数大于num的字典
    # 【例子】 oldDic = {"a":3,"b":2,"c":2,"a":1} ==_numDic2MoreSomeNumDic(oldDic,2)==>{"a":3,"b":2,"c":2}
    # *****************************************************************************************#
    """
    resultDic ={}
    for key in numDic:#key举例：’Controller xxx:‘
        #获取第二层字典
        tmpDic = numDic.get(key) #举例：{'disk[0, 13]': 1, 'disk[0, 4]': 1}
        #重新构造第二层字典
        secondDic = {}
        for diskNum in tmpDic:
            flickCount = tmpDic.get(diskNum)#对应硬盘的闪断次数
            if flickCount >= num :#大于或等于规定的行数就保留在字典中
                secondDic[diskNum] = flickCount
        resultDic[key] = secondDic #最终构造第二层字典完毕
    return resultDic

#No1:将文件中的日志信息，形成字典（key：控制器信息，value：多个闪断硬盘的日志信息）
def _logContent2Dic(content):
    """
    # *****************************************************************************************#
    # 【函数名称】 _logContent2Dic
    # 【功能说明:】将日志回显内容中的数据转换成内容字典
    # 【输入参数】 content：日志回显内容字符串
    # 【输出参数】 dict：转换后的内容字典
    # 【例子】 content = “多行的日志记录数据字符串内容” ==_logContent2Dic(content)==>{"Controller xxx":[A控制器日志内容的list],"Controller xxx":[B控制器日志内容的list]}
    # *****************************************************************************************#
    """
    dict = {}
    lines = content.splitlines()
    tmpKey = ""
    tmpList = []
    for line in lines:
        if  line.strip().startswith("Controller"):
            if tmpKey:
                dict[tmpKey]=tmpList
            tmpKey =line.strip()
            tmpList = []
        else:
            tmpList.append(line.strip())
    else:
        if tmpKey:
            dict[tmpKey]=tmpList 
    return dict          

#No2:将日志内容字典转成带有计数的字典
def _logContentDic2NumDic(logContentDic):
    """
    # *****************************************************************************************#
    # 【函数名称】 _logContentDic2NumDic
    # 【功能说明:】将No1中形成的日志内容字典转换成带有计数的字典
    # 【输入参数】 logContentDic：No1中返回的日志内容字典
    # 【输出参数】 finalDic：最终转换成的带有计数的字典
    # 【例子】 logContentDic = {"Controller xxx":[A控制器日志内容的list],"Controller xxx":[B控制器日志内容的list]} 
        ==_logContentDic2NumDic(logContentDic)==>
        {"Controller xxx":{'disk[0,1]':2,'disk[0,3]':2},"Controller xxx":'disk[0,1]':2,'disk[0,3]':2}
    # *****************************************************************************************#
    """
    finalDic = {} #最终要返回的字典
    #提取出对应的硬盘信息，形成新的字典（key：控制器信息，value：多个进行截取后的闪断硬盘信息）
    keyWord ="not in loop"
    regx_r5 = "disk\[[0-9]+, [0-9]+\]"
    regex_r1r2 =  "Disk [0-9]+ in frame [0-9]+"
    newDic = {}
    newList = []
    for key in logContentDic:  #key举例：’Controller xxx:‘
        flickInfoList = logContentDic.get(key)
        #重新整理成包含有“Not In Loop”关键字的硬盘列表
        for flickInfo in flickInfoList:
            #获取找出对应包含"Not in Loop"关键字的行
            if  keyWord in flickInfo.lower():
                flickInfoList1 = re.findall(regx_r5,flickInfo)
                flickInfoList2 = re.findall(regex_r1r2,flickInfo,re.IGNORECASE)
                #匹配老产品R5版本
                if flickInfoList1:#正则匹配到空行情况的过滤
                    diskInfo = flickInfoList1[0]#例如：“disk[0, 13]”
                    newList.append(diskInfo)
                #匹配老产品R1、R2版本
                if flickInfoList2:
                    resultStr = flickInfoList2[0]
                    valueItems = resultStr.split(' ')
                    diskNo = valueItems[1] #硬盘号
                    frameNo = valueItems[4] #硬盘框 
                    diskInfo = 'disk['+frameNo+", "+diskNo+"]"
                    newList.append(diskInfo)
        newDic[key] = newList
        newList = []#清空
        
    #构造最终要返回的字典
    for key in newDic:
        numDic = _list2NumDic(newDic[key])
        finalDic[key] = numDic
    return finalDic

#No4:构造“检查结果”需要的字符串
def _constructResultStr(finalNumDic,lang):
    """
    # *****************************************************************************************#
    # 【函数名称】 _constructResultStr
    # 【功能说明:】将No1中形成的日志字典转换成带有计数的字典
    # 【输入参数】 finalNumDic：No3中形成的最终的带有计数的字典，lang：语言
    # 【输出参数】 resultStr：“检查结果”中要显示的字符串内容（硬盘闪断信息）
    # 【例子】 finalNumDic = {"a":3,"b":2,"c":2} ==_constructResultStr(finalNumDic)==> 工具界面“检查结果”中的，在“系统存在闪断硬盘。”下面的内容字符串
    # *****************************************************************************************#
    """
    #最终的检查结果字符串构造
    resultStr = ""
    num = 0
    for key in finalNumDic:
        #控制器上有闪断的信息才进行构造。备注：可能同块硬盘在不是在双边都闪断，或许在单边闪断
        if finalNumDic.get(key):
            resultStr += key+"\n"
            for itemKey in finalNumDic.get(key):
                if "zh" == lang:
                    resultStr += itemKey+u" 闪断次数："+str(finalNumDic.get(key).get(itemKey))+"\n"
                else:
                    resultStr += itemKey+u" the count of the intermittent interruption: "+str(finalNumDic.get(key).get(itemKey))+"\n"
           
            #不同控制器之间的间隔处理（中间加一个空行）
            if num==0:
                resultStr += "\n"
                num = 1
    return resultStr

#兼容老产品R1、R2使用，将'disk[0, 12]'格式转换成'Disk 12 in frame 0'
def constructDiskInfoByDiskNo(diskNo):
    result =""
    regex_r5 = "disk\[[0-9]+, [0-9]+\]"
    if re.match(regex_r5,str(diskNo),re.IGNORECASE):
        #传入的是 disk[0, 12]
        frameNo = diskNo.split(',')[0].split('disk[')[1].strip()
        diskNo = diskNo.split(',')[1].split(']')[0].strip()
        result = 'Disk '+diskNo+" in frame "+frameNo 
    #返回的是 Disk 12 in frame 0
    return result

#No5:构造“原始信息”对应的回显字符串（新的需求是：出现闪断的硬盘信息才在回显中显示出来，即：出现5次或多于5次的闪断硬盘的信息）需要的List
def _getOriginInfoByTwoContainer(oldContentList,numDic):
    """
    # *****************************************************************************************#
    # 【函数名称】 _getOriginInfoByTwoContainer
    # 【功能说明:】构造最新的，工具界面需要的“原始信息”对应的List
    # 【输入参数】 oldContentList：单个控制器的原始的日志记录的List，numDic：单个控制器最终统计后的出现闪断的硬盘信息字典
    # 【输出参数】 newContentList：新的单个控制器上需要的“原始信息”List
    # *****************************************************************************************#
    """
    if not numDic:
        return []
    #最终要返回的List
    newContentList = []
    for oldItem in oldContentList:
        satisfyDiskNumList = [i for i in numDic if ((i in oldItem) or (constructDiskInfoByDiskNo(i) in oldItem)) ]
        satisfyDiskNum = None
        if satisfyDiskNumList:
            satisfyDiskNum = satisfyDiskNumList[0]
        if str(satisfyDiskNum) in oldItem or (constructDiskInfoByDiskNo(satisfyDiskNum) \
                                              and constructDiskInfoByDiskNo(satisfyDiskNum) in oldItem):
            newContentList.append(oldItem)
    return newContentList

#构造结果字符串（最终调用）【检查结果字符串，原始信息字符串】
def checkDiskFlickResult(cliRet,lang,num):
    """
    # *****************************************************************************************#
    # 【函数名称】 checkDiskFlickResult
    # 【功能说明:】”硬盘闪断“巡检项最终调用的工具方法
    # 【输入参数】 cliRet：出现日志关键字的回显信息，lang：语言，num:代表同块硬盘出现多少次日志记录才认为是闪断
    # 【输出参数】 checkResultStr：检查结果字符串内容,detailInfoClietStr：详细信息最终的回显字符串
    # *****************************************************************************************#
    """
    #文本数据转换成相应的文本字典
    contentDic = _logContent2Dic(cliRet)
    
    #文本字典转换成含有计数的字典
    numDic = _logContentDic2NumDic(contentDic)

    #过滤计数不满足条件的，形成新的含有计数的字典
    finalNumDic = _numDic2MoreSomeNumDic(numDic,num)#保留5次和大于5次的硬盘数据

    #构造“原始信息”中结果字典
    detailInfoClietStr = ""
    newDetailContenDic = {}#处理后的针对要在工具界面中显示为“详细信息”的回显要使用的字典
    for contrlInfo in contentDic:
        newTmpContentList = _getOriginInfoByTwoContainer(contentDic.get(contrlInfo),finalNumDic.get(contrlInfo))
        newDetailContenDic[contrlInfo] = newTmpContentList
    #构造“原始信息”中新的满足需要的回显字符串
    for key in newDetailContenDic:
        if newDetailContenDic[key]:
            detailInfoClietStr += (key+"\n")
            for item in newDetailContenDic[key]:
                detailInfoClietStr += (item+"\n")
        detailInfoClietStr+="\n"
    
    #构造“检查结果”中对应的字符串
    checkResultStr = _constructResultStr(finalNumDic,lang)
    
    #返回最终的执行结果
    return checkResultStr.strip(),detailInfoClietStr.strip()