# -*- coding: UTF-8 -*-
import re
import time
import traceback
from utils import *

def isLogWithYears(lineInfo):
    """
    # *****************************************************************************************#
    # 函数名称: isLogWithYears(lineInfo)
    # 功能说明: 判断日志是否带有年份
    # 输入参数: lineInfolineInfo
    # 输出参数: True：带有年份；False：不带年份
    # *****************************************************************************************#
    """
    startIndex = lineInfo.find("[")
    endIndex = lineInfo.find("]")
    
    if - 1 != startIndex and - 1 != endIndex:
        timeStamp = lineInfo[startIndex + 1:endIndex].strip()
        return True if re.match("^\d{4}-\d{1,2}-\d{1,2}[\s\d:]*$", timeStamp) else False
    return False

def getLineJiffe(lineInfo, verTag):
    """
    # *****************************************************************************************#
    # 函数名称: _getLineJiffe(lineInfo)
    # 功能说明: 获取指定某行的jiffe值
    # 输入参数: lineInfo
    # 输出参数: Jiffe（int类型）
    # *****************************************************************************************#
    """
    jiffe = -1
    if re.match(".*" + verTag + "\W+[0-9]+\W.*", lineInfo, re.IGNORECASE):
        jiffe = int(lineInfo[lineInfo.find("[") + 1:lineInfo.find("]")])
    return jiffe

def getLineTimeStamp(lineInfo):
    """
    # *****************************************************************************************#
    # 函数名称: getLineTimeStamp(lineInfo)
    # 功能说明: 获取日志某一行的时间戳信息
    # 输入参数: lineInfo（格式为：[2014-09-01 15:25:06]XXXXX）
    # 输出参数: 14位时间戳信息
    # *****************************************************************************************#
    """
    lineTime = lineInfo[lineInfo.find("[") + 1:lineInfo.find("]")]
    lastMsgStamp = lineTime.replace("-", "").replace(":", "").replace(" ", "").strip().ljust(TIME_STAMP_LEN)[0:TIME_STAMP_LEN]
    if re.match("[0-9]{14}", lastMsgStamp):
        return lastMsgStamp
    else:
        return ""
    
def countTimeSpanOfSecs(curTimeStamp, logTimeStamp, maxJif, curJif):
    """
    # *****************************************************************************************#
    # 函数名称: _countTimeSpanOfSecs(curTimeStamp, logTimeStamp, maxJif, curJif)
    # 功能说明: 计算日志中，某行的jif距离当前时间的时间（秒）
    # 输入参数: curTimeStamp, logTimeStamp, maxJif, curJif
    # 输出参数: seconds
    # *****************************************************************************************#
    """
    return formatTimeStamp2Sec(curTimeStamp) - formatTimeStamp2Sec(logTimeStamp) + (maxJif - curJif) / 1000

def adjustLogTimeStamp(maxJifLine, verTag, logTimeStamp, PY_LOGGER):
    """
    # *****************************************************************************************#
    # 函数名称: _adjustLogTimeStamp(maxJifLine, logTimeStamp, PY_LOGGER)
    # 功能说明: 日志目录生成时，是以压缩时间为时间戳命名的，这个时间戳可能和日志最后一条记录的
    #           时间存在误差，需要调整才能通过Jiffe反推出时间间隔
    # 输入参数: maxJifLine, logTimeStamp, PY_LOGGER
    # 输出参数: adjustTimeStamp（调整失败或出现异常时返回原始时间戳信息）
    # *****************************************************************************************#
    """
    try:
        logTimeStamp = str(logTimeStamp)
        
        #获取“Jun 21 14:18:12”时间格式
        lineTime = maxJifLine[0:maxJifLine.find(re.findall(verTag, maxJifLine)[0])].strip()
        
        curYear = logTimeStamp[0:4]
        curMonth = lineTime.split()[0]
        
        #框架为2.5python版本。%d方法无法使用，需要手动把月份缩写转发为数字
        digitMonth = MONTH_NAME_ABBRE.get(curMonth)
        if not digitMonth:
            if logTimeStamp[6:8] < lineTime.split()[1]:
                digitMonth = str(int(logTimeStamp[4:6]) - 1)
            else:
                digitMonth = logTimeStamp[4:6]
        
        #日志中“Jun 21 14:18:12”时间格式先格式化为“20140621 14:18:12”格式便于时间转换
        lineTime = curYear + digitMonth + lineTime[lineTime.find(" "):].strip()
        adjustTimeStamp = str(datetime.datetime.strptime(lineTime, "%Y%m%d %H:%M:%S"))
        
        #转化为时间戳格式
        adjustTimeStamp = adjustTimeStamp.replace(" ", "").replace("-", "").replace(":", "")
       
        #位数不相等说明转换失败，返回没有调整的时间
        if len(logTimeStamp) != len(adjustTimeStamp):
            PY_LOGGER.error("[adjustLogTimeStamp]Adjust time stamp is: " + str(adjustTimeStamp))
            return logTimeStamp
        
        #调整后的时间应该小于日志生成的时间，若是大于说明存在年份的误差，需要调整年份信息
        #时间戳调整有问题，2014/08/08 modified Begin
        if adjustTimeStamp > logTimeStamp and (formatTimeStamp2Sec(adjustTimeStamp) - formatTimeStamp2Sec(logTimeStamp)) > 300 * 24 * 60 * 60:
            PY_LOGGER.info("[adjustLogTimeStamp]Adjust- year information: " + str(adjustTimeStamp))
            return str(int(curYear) - 1) + adjustTimeStamp[4:]
        elif adjustTimeStamp < logTimeStamp and (formatTimeStamp2Sec(logTimeStamp) - formatTimeStamp2Sec(adjustTimeStamp)) > 300 * 24 * 60 * 60:
            PY_LOGGER.info("[adjustLogTimeStamp]Adjust+ year information: " + str(adjustTimeStamp))
            return str(int(curYear) + 1) + adjustTimeStamp[4:]
        #时间戳调整有问题，2014/08/08 modified End
        
        return adjustTimeStamp

    except:
        PY_LOGGER.error("[adjustLogTimeStamp]Adjust catch exception: " + traceback.format_exc())
        return logTimeStamp

def getLogModifyTimeStamp(lineInfo, curYear):
    """
    # *****************************************************************************************#
    # 函数名称: getLogModifyTimeStamp(lineInfo, curYear)
    # 功能说明: 根据ls -l回显信息获取文件的最后一次修改的时间戳信息
    # 输入参数: lineInfo, curYear（当前年份）
    # 输出参数: 文件最后一次修改的时间戳信息（格式为“20140628145802”字符串）
    # *****************************************************************************************#
    """
    logTimeStamp = ""
    lineSplit = lineInfo.split()
    
    #执行ls -l命令后，年份与当前年份不同时，显示格式为：Nov 17  2005 文件名
    if - 1 == lineSplit[-2].find(":") and  4 == len(lineSplit[-2]):
        year = lineSplit[-2]
        digitMonth = MONTH_NAME_ABBRE.get(lineSplit[-4].strip())
        days = lineSplit[-3]
        logTimeStamp = (year + digitMonth + days).ljust(14, "0")
    #执行ls -l命令后，年份与当前年份相时，显示格式为：Jul 25 13:52 文件名    
    elif - 1 != lineSplit[-2].find(":"):
        digitMonth = MONTH_NAME_ABBRE.get(lineSplit[-4].strip())
        days = lineSplit[-3]
        times = lineSplit[-2].replace(":", "")
        logTimeStamp = (curYear + digitMonth + days + times).ljust(TIME_STAMP_LEN, "0")
    return logTimeStamp

