# -*- coding: UTF-8 -*-
import re
from constant import *
import cliMgt

def getCurrentMode(cli):
    """
    # *****************************************************************************************#
    # 函数名称: getCurrentMode(cli)
    # 功能说明: 获取当前运行的模式
    # 输入参数: cli
    # 返 回 值: 当前运行的模式
    # *****************************************************************************************#
    """
    
    cliRet = cliMgt.execCmdNoLog(cli, "testMode")
    
    if re.search("The command name is invalid|Command :.*not exist", cliRet, re.IGNORECASE):
        return MODE_CLI
    elif re.search("command not found", cliRet, re.IGNORECASE):
        return MODE_DEBUG
    elif re.search("spu ui>|MML>", cliRet, re.IGNORECASE):
        return MODE_MML
    return MODE_ERR

def _changeDebug2Mml(cli):
    """
    # *****************************************************************************************#
    # 函数名称: _changeDebug2Mml(cli)
    # 功能说明: 内部函数，外部勿调用，从debug模式进入mml模式（需要确定使用之前为debug模式）
    # 输入参数: cli
    # 返 回 值: True or False
    # *****************************************************************************************#
    """
    cliRet = cliMgt.execCmd(cli, "mml")
    if re.search("spu ui>|MML>", cliRet, re.IGNORECASE):
        return True
    return False


def changeAnyMode2Debug(cli, py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: changeAnyMode2Debug(cli, py_java_env)
    # 功能说明: 进入debug模式
    # 输入参数: cli, py_java_env
    # 返 回 值: isSuccess, cliRet（切换成功时无返回值）, errMsg 
    # *****************************************************************************************#
    """
    cliRet = ""
    errMsg = ""
    isSuccess = False
    lang = py_java_env.get("lang")
    try:
        currentMode = getCurrentMode(cli)
        #当前已处于debug模式下
        if MODE_DEBUG == currentMode:
            return True, "", "" 
        #当前处于MML模式下
        elif MODE_MML == currentMode:
            cliRet = cliMgt.execCmd(cli, "exit")
            if re.search("#", cliRet, re.IGNORECASE):    
                isSuccess = True
                return True, "", "" 
        #当前处于CLI模式下    
        elif MODE_CLI == currentMode:
            return changeCliMode2Debug(cli, py_java_env)
        
        cliRet = ""   
        if not isSuccess:    
            if "zh" == lang:
                errMsg = u"\n切换到debug模式失败。"
            else:
                errMsg = u"\nFailed to switch the debug mode."
            cliRet = "Failed to switch the debug mode."
        return isSuccess, cliRet, errMsg
    except:
        if "zh" == lang:
            errMsg = u"\n切换到debug模式失败。"
        else:
            errMsg = u"\nFailed to switch the debug mode."
        cliRet = "Failed to switch the debug mode."
        return False, cliRet, errMsg


def changeCliMode2Debug(cli, py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: changeCliMode2Debug(cli, py_java_env)
    # 功能说明: 从CLI模式进入debug模式,请确保在CLI模式下调用此方法
    # 输入参数: cli, py_java_env
    # 返 回 值: isSuccess, cliRet（切换成功时无返回值）, errMsg 
    # *****************************************************************************************#
    """
    cliRet = ""
    errMsg = ""
    isSuccess = False
    lang = py_java_env.get("lang")
    try:
        pwd = str(py_java_env.get("devPwd").get("developer"))
        if not pwd:
            if "zh" == lang:
                errMsg = u"\n请配置调试密码。"
            else:
                errMsg = u"\nPlease configure a debug password."
            return False, "Please configure a debug password.", errMsg 
                    
        cliRet = cliMgt.execCmd(cli, "debug")
        if re.search("Enter Password", cliRet, re.IGNORECASE):
            cliRet = cliMgt.execCmdNoLog(cli, pwd)
            if re.search("Password Error", cliRet, re.IGNORECASE):
                if "zh" == lang:
                    errMsg = u"\n调试密码无效。"
                else:
                    errMsg = u"\nThe debug password is invalid."
                return False, "The debug password is invalid.", errMsg 
            
            elif re.search("#", cliRet, re.IGNORECASE):    
                isSuccess = True
                return True, "", "" 
        
        cliRet = ""   
        if not isSuccess:    
            if "zh" == lang:
                errMsg = u"\n切换到debug模式失败。"
            else:
                errMsg = u"\nFailed to switch the debug mode."
            cliRet = "Failed to switch the debug mode."
        return isSuccess, cliRet, errMsg 
    except:
        if "zh" == lang:
            errMsg = u"\n切换到debug模式失败。"
        else:
            errMsg = u"\nFailed to switch the debug mode."
        cliRet = "Failed to switch the debug mode."
        return False, cliRet, errMsg
    
def changeAnyMode2Mml(cli, py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: changeAnyMode2Mml(cli, py_java_env)
    # 功能说明: 进入MML模式
    # 输入参数: cli, py_java_env
    # 返 回 值: isSuccess, cliRet（切换成功时无返回值）, errMsg 
    # *****************************************************************************************#
    """
    isSuccess = True
    cliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    try:
        currentMode = getCurrentMode(cli)
        #当前处于MML模式
        if MODE_MML == currentMode:
            return True, cliRet, errMsg
        #当前处于Debug模式
        elif MODE_DEBUG == currentMode:
            if _changeDebug2Mml(cli):
                return True, cliRet, errMsg
        #当前处于CLI模式
        elif MODE_CLI == currentMode:
            isSuccess, cliRet, errMsg = changeCliMode2Debug(cli, py_java_env)
            if not isSuccess:
                return False, cliRet, errMsg
            
            if _changeDebug2Mml(cli):
                return True, cliRet, errMsg
            
        if "zh" == lang:
            errMsg = u"\n切换到mml模式失败。"
        else:
            errMsg = u"\nFailed to switch the mml mode."
        return False, "Failed to switch the mml mode", errMsg
    except:
        if "zh" == lang:
            errMsg = u"\n切换到mml模式失败。"
        else:
            errMsg = u"\nFailed to switch the mml mode."
        return False, "Failed to switch the mml mode", errMsg

def changeAnyMode2Cli(cli):
    """
    # *****************************************************************************************#
    # 函数名称: changeAnyMode2Cli(cli)
    # 功能说明: 从任何其它模式切换到CLI模式下
    # 输入参数: cli
    # 返 回 值: True or False
    # *****************************************************************************************#
    """
    try:
        currentMode = getCurrentMode(cli)
        
        if MODE_CLI == currentMode:
            return True
        
        if MODE_DEBUG == currentMode:
            cliMgt.execCmd(cli, "exit")
        elif MODE_MML == currentMode:
            cliMgt.execCmd(cli, "exit")
            cliMgt.execCmd(cli, "exit")
         
        if MODE_CLI == getCurrentMode(cli):
            return True
        return False
    except:
        try:
            cli.reConnect()
        except:
            return False
        return True

def change2AimMode(cli, py_java_env, aimMode):
    """
    # *****************************************************************************************#
    # 函数名称: change2AimMode(cli, aimMode)
    # 功能说明: 从任何其它模式切换指定模式下
    # 输入参数: cli, aimMode
    # 返 回 值: True or False
    # *****************************************************************************************#
    """
    flag = False
    try:
        currentMode = getCurrentMode(cli)
        if aimMode == currentMode:
            return True
        
        if MODE_CLI == aimMode:
            flag = changeAnyMode2Cli(cli)
        elif MODE_DEBUG == aimMode:
            iRet = changeAnyMode2Debug(cli, py_java_env)
            flag = iRet[0]
        elif MODE_MML == aimMode:
            iRet = changeAnyMode2Mml(cli, py_java_env)
            flag = iRet[0]
        return flag
    except:
        return False
