﻿# -*- coding: UTF-8 -*-
import re
import os
import tarfile
from cbb.frame.util.tar_util import UnZipLimit, get_safe_entry_name
import time
import shutil
import traceback
from logMgt import *
from utils import *
from BackwardsReader import BackwardsReader

PATH_CUR = "/OSM/log/cur_debug/"
PATH_HIS = "/OSM/log_conf_local/log/his_debug/"
PATH_CPR = "/OSM/log_conf_local/log/compresslog/message/"

TGZ_TAG = ".tgz"

SCSI_ERROR = "scsi_error_handler"
CMD_UNKOWN = "command = UNKNOWN"
CMD_SPE = "command = VENDOR SPECIFIC"
IOC_ACT = "IOC Active. No free Msg Frames"
NOT_RET = ") if not return\!"
ERROR_NULL = "ERROR - NULL ScsiCmd ptr\!"
KEY_WORD_LIST = [SCSI_ERROR, CMD_UNKOWN, CMD_SPE, IOC_ACT, NOT_RET, ERROR_NULL]

def _getDevLogTmpPath(py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: _getDevLogTmpPath(py_java_env)
    # 功能说明: 为了防止影响其它日志收集，收据log信息置于阵列新建tmp目录下
    # 输入参数: py_java_env
    # 输出参数: 阵列本端路径+"tmp/"
    # *****************************************************************************************#
    """
    return  getDevTmpFilePath(py_java_env) + "tmp/"

def _getLocalTmpLogPath(py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: _getLocalTmpLogPath(py_java_env)
    # 功能说明: 为了防止影响其它日志收集，收据log信息置于阵列新建tmp目录下
    # 输入参数: py_java_env
    # 输出参数: 阵列本端路径+"tmp/"
    # *****************************************************************************************#
    """
    return  getLocaTmplFilePath(py_java_env) + "logs/"

def _getLogMsgDirList(cli, py_java_env, PY_LOGGER, curTimeStamp, spanDays, isLocal=True): 
    """
    # *****************************************************************************************#
    # 功能说明: 根据ls -l回显信息获取文件的最后一次修改的时间戳信息
    # 输入参数: cli, py_java_env,PY_LOGGER
    #          curTimeStamp：设备当前时间；spanDays：日志时间范围内；isLocal：是否为本地日志信息
    # 输出参数: logInfoList（每个元素为一个序列，第一为阵列上面的名称，第二个为获取后本地的文件名）
    # *****************************************************************************************#
    """
    logInfoList = []
    
    ipAddr = ""
    if isLocal:
        ipAddr = getLocalIpAddr(py_java_env)
    else:
        ipAddr = getPeerIpAddr(cli, py_java_env)
    
    #获取当前日志/OSM/log/cur_debug/目录并解析
    if isLocal:
        cliRet = cliMgt.execCmd(cli, "ls -l " + PATH_CUR)
    else:
        flag, cliRet, errMsg = sendDebugCmd2Peer(cli, "ls -l " + PATH_CUR, py_java_env, PY_LOGGER)
    
    cliRetList = cliRet.splitlines()
    for lineInfo in cliRetList:
        lineInfo = lineInfo.strip()
        if lineInfo.endswith("messages"):
            fileDevDir = PATH_CUR + "messages"
            logTimeStamp = getLogModifyTimeStamp(lineInfo, curTimeStamp[0:4])
            
            if isInTimeSpan(formatTimeStamp2Sec(logTimeStamp), formatTimeStamp2Sec(curTimeStamp), spanDays):
                lclFileName = ipAddr + "_" + logTimeStamp + "_cur_messages"
                logInfoList.append([fileDevDir, lclFileName])
        elif lineInfo.endswith("messages_bak"):
            fileDevDir = PATH_CUR + "messages_bak"
            logTimeStamp = getLogModifyTimeStamp(lineInfo, curTimeStamp[0:4])
            if isInTimeSpan(formatTimeStamp2Sec(logTimeStamp), formatTimeStamp2Sec(curTimeStamp), spanDays):
                lclFileName = ipAddr + "_" + logTimeStamp + "_bak_messages"
                logInfoList.append([fileDevDir, lclFileName])
    
    #获取上下电日志/OSM/log_conf_local/log/his_debug/目录并解析（单个格式his_tar_on_20140613100432.tg）
    if isLocal:
        cliRet = cliMgt.execCmd(cli, "ls -l " + PATH_HIS)
    else:
        flag, cliRet, errMsg = sendDebugCmd2Peer(cli, "ls -l " + PATH_HIS, py_java_env, PY_LOGGER)
    cliRetList = cliRet.splitlines()     
    for lineInfo in cliRetList:
        lineInfo = lineInfo.strip() 
        if - 1 != lineInfo.find("his") and lineInfo.endswith(".tgz"):  
            fileDevDir = PATH_HIS + lineInfo.split()[-1]
            logTimeStamp = lineInfo[lineInfo.rfind("_") + 1:lineInfo.rfind(".tgz")].ljust(TIME_STAMP_LEN, "0")
            if isInTimeSpan(formatTimeStamp2Sec(logTimeStamp), formatTimeStamp2Sec(curTimeStamp), spanDays):
                lclFileName = ipAddr + "_" + logTimeStamp + "_his_messages"
                logInfoList.append([fileDevDir, lclFileName])

    #获压缩日志文件/OSM/log_conf_local/log/compresslog/message/目录并解析（单个格式messages_1405829831.tgz）
    if isLocal:
        cliRet = cliMgt.execCmd(cli, "ls -l " + PATH_CPR)
    else:
        flag, cliRet, errMsg = sendDebugCmd2Peer(cli, "ls -l " + PATH_CPR, py_java_env, PY_LOGGER)
    cliRetList = cliRet.splitlines()     
    for lineInfo in cliRetList:
        lineInfo = lineInfo.strip() 
        if - 1 != lineInfo.startswith("message") and lineInfo.endswith(".tgz"):  
            fileDevDir = PATH_CPR + lineInfo.split()[-1]
            logTimeStamp = getLogModifyTimeStamp(lineInfo, curTimeStamp[0:4])
            if isInTimeSpan(formatTimeStamp2Sec(logTimeStamp), formatTimeStamp2Sec(curTimeStamp), spanDays):
                lclFileName = ipAddr + "_" + logTimeStamp + "_compress_messages"
                logInfoList.append([fileDevDir, lclFileName])
    return logInfoList

def _decompressLocalFile(py_java_env, PY_LOGGER):
    """
    # *****************************************************************************************#
    # 函数名称: _decompressLocalFile(py_java_env,PY_LOGGER)
    # 功能说明: 解压本地压缩文件
    # 输入参数: 无
    # 输出参数: 无
    # *****************************************************************************************#
    """
    def decompress_one_tar_obj(tar, tar_obj, limit):
        tagMemberName = get_safe_entry_name(tar.name)
        if not tagMemberName:
            return False
        if - 1 != tagMemberName.find("messages_bak"):
            limit.increase_file_size(tar.size)
            tar_obj.extract(tagMemberName, logTmpPath)
            if - 1 == fileName.find("_his_"):
                os.rename(logTmpPath + tagMemberName, localTmpPath +
                          fileName[0:-4])
            else:
                os.rename(logTmpPath + tagMemberName, localTmpPath +
                          (fileName[0:-4]).replace("_his_", "_his_bak_"))
            return True
        elif tagMemberName.startswith("message"):
            limit.increase_file_size(tar.size)
            tar_obj.extract(tagMemberName, logTmpPath)
            os.rename(logTmpPath + tagMemberName, localTmpPath + fileName[0:-4])
            return True
        return False

    def decompress_one_tgz_file(file_dir):
        limit = UnZipLimit()
        with tarfile.open(file_dir) as tar_obj:
            for tar in tar_obj:
                if not decompress_one_tar_obj(tar, tar_obj, limit):
                    continue
                if limit.is_file_stat_over_limit():
                    PY_LOGGER.error("decompress file size over limit: {}, num size : {}".
                                    format(limit.get_max_file_size(), limit.get_max_file_num()))
                    break

    localTmpPath = getLocaTmplFilePath(py_java_env)
    localFileNameList = os.listdir(localTmpPath)
    
    logTmpPath = localTmpPath + "logs\\"
    if not os.path.exists(logTmpPath):
        os.mkdir(logTmpPath)
    
    for fileName in localFileNameList:
        fileDir = localTmpPath + fileName
        if not fileDir.endswith(TGZ_TAG):
            continue
        decompress_one_tgz_file(fileDir)

    localFileNameList = os.listdir(localTmpPath)
    except_counter = 0
    for fileName in localFileNameList:
        fileDir = localTmpPath + fileName
        if fileDir.endswith(TGZ_TAG):
            try:
                os.remove(fileDir)
            except:
                except_counter += 1
    shutil.rmtree(logTmpPath, ignore_errors=True)
    return

def _downloadLogs2Local(cli, curTimeStamp, isDownloadDouble, py_java_env, PY_LOGGER, spanDays=90):
    """
    # *****************************************************************************************#
    # 功能说明: 下载阵列上日志文件到本地，日志时间范围默认为90天
    # 输入参数: cli, py_java_env, PY_LOGGER, curTimeStamp, isDownloadDouble, spanDays=90
    # 输出参数: downLoadFileInfos列表单个元素结构：文件是否成功，文件阵列路径，文件本地保存路径（最终压缩为tgz包）
    # *****************************************************************************************#
    """
    #为了防止sftp连接断开，拷贝文件前先进行重连的操作
    flag = True
    sftp = py_java_env.get("sftp")
    initSftp(sftp)
    
    #每个元素结果为[flag, devFileDir, localFileDir]
    downLoadFileInfos = [] 

    #获取此次巡检本地存在临时日志目录，时间戳以记录的本次工具启动时间为准
    localTmpPath = getLocaTmplFilePath(py_java_env)
    PY_LOGGER.info("[_downloadLogs2Local] Get local tmp path is:" + str(localTmpPath))
    
    mkLocalTmpPath(localTmpPath)

    #文件先拷贝到阵列临时目录下
    devTmpFilePath = _getDevLogTmpPath(py_java_env)

    #创建临时文件先删除之前的tmp目录
    cliMgt.execCmd(cli, "rm -rf " + devTmpFilePath)
    
    #阵列上创建临时目录
    cliMgt.execCmd(cli, "mkdir " + getDevTmpFilePath(py_java_env))
    cliMgt.execCmd(cli, "mkdir " + devTmpFilePath)
        
    logInfoList = _getLogMsgDirList(cli, py_java_env, PY_LOGGER, curTimeStamp, spanDays)
    for logInfo in logInfoList:
        PY_LOGGER.info("[_downloadLogs2Local] Local log info:" + str(logInfo))
        flag, path = _downloadLocalLog(cli, py_java_env, logInfo[0], logInfo[1], PY_LOGGER)
        if not flag:
            downLoadFileInfos.append([False, logInfo[0], logInfo[1] + TGZ_TAG])
            PY_LOGGER.error("[_downloadLogs2Local] Local get:[" + str(logInfo) + "] failed!!!") 
        elif path:
            downLoadFileInfos.append([True, logInfo[0], logInfo[1] + TGZ_TAG])
        else:
            PY_LOGGER.info("[_downloadLogs2Local] Local [" + str(logInfo) + "] has no messages in it!!!") 
    
    #是否下载对端文件       
    if isDownloadDouble:
        logInfoList = _getLogMsgDirList(cli, py_java_env, PY_LOGGER, curTimeStamp, spanDays, False)
        for logInfo in logInfoList:
            PY_LOGGER.info("[_downloadLogs2Local] Peer log info:" + str(logInfo))
            flag, path = _downloadDevPeerLog(cli, py_java_env, logInfo[0], logInfo[1], PY_LOGGER)
            if not flag:
                downLoadFileInfos.append([False, logInfo[0], logInfo[1] + TGZ_TAG])
                PY_LOGGER.error("[_downloadLogs2Local] Peer get:[" + str(logInfo) + "] failed!!!") 
            elif path:
                downLoadFileInfos.append([True, logInfo[0], logInfo[1] + TGZ_TAG])
            else:
                PY_LOGGER.info("[_downloadLogs2Local] Peer [" + str(logInfo) + "] has no messages in it!!!") 
    
    return downLoadFileInfos
    
def _downloadLocalLog(cli, py_java_env, devFileDir, newFileName, PY_LOGGER):
    """
    # *****************************************************************************************#
    # 功能说明: 下载本端阵列日志文件devFileDir到本地并改名为newFileName
    # 输入参数: cli, py_java_env, PY_LOGGER
    #          devFileDir：文件在阵列上面的绝对路径 
    #          newFileName：重新命名的文件名
    # 返 回 值: 参数一：True or False
    #           参数二：获取后保存到本地的绝对路径信息（文件统一命名：ip地址_logTimeStamp_suffix_messages）
    # *****************************************************************************************#
    """
    try:
        #本地文件已存在，无需获取
        localFilePath = getLocaTmplFilePath(py_java_env)
        if os.path.exists(localFilePath + newFileName):
            return True, localFilePath + newFileName
        
        sftp = py_java_env.get("sftp")
        
        #文件先拷贝到阵列临时目录下
        devTmpFilePath = _getDevLogTmpPath(py_java_env)
            
        #文件名字
        orginFileName = os.path.basename(devFileDir)
        
        #日志为压缩包情况
        if orginFileName.endswith(".tgz"):
            #解压缩最新的压缩文件到tmp目录中
            sftp.getFile(devFileDir, localFilePath + newFileName + ".tgz", None)
        
        #其它情况为message或message_bak情况
        else:
            logPath = os.path.dirname(devFileDir) if "/" == os.path.dirname(devFileDir)[-1] else os.path.dirname(devFileDir) + "/"
            cliMgt.execCmd(cli, "cd " + logPath)
            cliMgt.execCmd(cli, "tar zcvf " + devTmpFilePath + newFileName + ".tgz" + " " + orginFileName)
            sftp.getFile(devTmpFilePath + newFileName + ".tgz", localFilePath + newFileName + ".tgz", None)
            cliMgt.execCmd(cli, "rm -rf " + logPath + ".tgz")
            cliMgt.execCmd(cli, "cd /root/")
            
        return os.path.exists(localFilePath + newFileName + ".tgz"), localFilePath + newFileName + ".tgz"
    
    except:
        PY_LOGGER.error("[_downloadLocalLog] Catch except of trace back:" + str(traceback.format_exc())) 
        if os.path.exists(localFilePath + newFileName + ".tgz"):
            try:
                os.remove(localFilePath + newFileName + ".tgz")
            except:
                return False, ""
        return False, ""

def _downloadDevPeerLog(cli, py_java_env, devFileDir, newFileName, PY_LOGGER):
    """
    # *****************************************************************************************#
    # 功能说明: 下载对端阵列日志文件devFileDir到本地并改名为newFileName
    # 输入参数: cli, py_java_env, PY_LOGGER
    #          devFileDir：文件在阵列上面的绝对路径 
    #          newFileName：重新命名的文件名
    # 返 回 值: 参数一：True or False
    #           参数二：获取后保存到本地的绝对路径信息（文件统一命名：ip地址_logTimeStamp_suffix_messages）
    # *****************************************************************************************#
    """
    devTmpFilePath = ""
    try:
        sftp = py_java_env.get("sftp")
        localFilePath = getLocaTmplFilePath(py_java_env)
        
        #本地文件已存在，无需获取
        if os.path.exists(localFilePath + newFileName):
            return True, localFilePath + newFileName
            
        #拷贝对端文件到本端/tmp/临时目录下
        devTmpFilePath = _getDevLogTmpPath(py_java_env)
        if not scpPeerFile(cli, devFileDir, py_java_env, devTmpFilePath):
            return False, ""
        
        return _downloadLocalLog(cli, py_java_env, devTmpFilePath + os.path.basename(devFileDir), newFileName, PY_LOGGER)
    except:
        PY_LOGGER.error("[_downloadLocalLog] Catch except of trace back:" + str(traceback.format_exc())) 
        return False, ""
    finally:
        #删除本地临时文件
        if devTmpFilePath:
            cliMgt.execCmd(cli, "rm -rf " + devTmpFilePath + "/*")

def _isRecordPass(PY_LOGGER, logDictInfo):
    """
    # *****************************************************************************************#
    # 功能说明: 判断日志中存在的记录是否有1068E资源泄漏的风险
    # 输入参数: PY_LOGGER, logDictInfo
    # 返 回 值: True：无风险；Falsh：有风险
    # *****************************************************************************************#
    """
    numScsi = 0
    numCmd = 0
    numIoc = 0
    numNot = 0
    numPtr = 0
    
    numScsi = len(set(logDictInfo.get(SCSI_ERROR))) 
    numCmd = len(set(logDictInfo.get(CMD_UNKOWN))) + len(set(logDictInfo.get(CMD_SPE)))
    numIoc = len(set(logDictInfo.get(IOC_ACT)))
    numNot = len(set(logDictInfo.get(NOT_RET)))
    numPtr = len(set(logDictInfo.get(ERROR_NULL)))
    PY_LOGGER.info("[_isRecordPass]Record(numScsi=" + str(numScsi) + ", numCmd=" + str(numCmd) + \
                   ", numIoc=" + str(numIoc) + ", numNot=" + str(numNot) + ", numPtr=" + str(numPtr) + ").") 
    
    if numIoc > 5:
        return False
    
    if numCmd > 50 and numCmd > numScsi / 2 and (numNot - numPtr) > 10:
        return False
    return True

def _generatKeyDictInfo(py_java_env, PY_LOGGER, curTimeStamp, ipAddr, interval=180):    
    """
    # *****************************************************************************************#
    # 函数名称: _generatKeyDictInfo(py_java_env, PY_LOGGER,curTimeStamp, ipAddr, interval=180)
    # 功能说明: 从message文件中获取带有关键字信息的所有累加行信息
    # 输入参数: py_java_env, PY_LOGGER,curTimeStamp, ipAddr, interval=180
    # 输出参数: msg
    # *****************************************************************************************#
    """
    localTmpPath = getLocaTmplFilePath(py_java_env)
    localFileNameList = os.listdir(localTmpPath)
    
    #文件从新到老排序
    localFileNameList = sorted(localFileNameList, reverse=True)
    
    dictInfo = {}
    uiDisplay = []
    for keyWord in KEY_WORD_LIST:
        dictInfo[keyWord] = []
    
    try:
        for fileName in localFileNameList:
            maxJif = 0
            
            #资源泄漏判断有误，只分析ipAddr的日志文件，2014/09/09 modified Begin
            if not (fileName.startswith(ipAddr + "_") and fileName.endswith("messages")):
                continue
            #资源泄漏判断有误，只分析ipAddr的日志文件，2014/09/09 modified End
            
            logTimeStamp = fileName.split("_")[1]
            localFileDir = localTmpPath + fileName
            PY_LOGGER.info("[_generatKeyDictInfo]Starting to pare file:" + str(localFileDir)) 
            
            f = open(localFileDir, "r")
            br = BackwardsReader(f)
            
            #防止各个版本间日志信息格式不一样，选择是否带年份前再次判断
            isLogWithYear = isLogWithYears(br.readline())
            br.reset()
            
            #对于日志存在年份的情况，不需要考虑jiffe的差异
            if isLogWithYear:
                PY_LOGGER.info("[_generatKeyDictInfo] Parse with year log!")
                while not br.isEnd:
                    lineInfo=br.readline()
                    #循环关键字，记录出现的关键字
                    for keyWord in KEY_WORD_LIST:
                        if - 1 != lineInfo.find(keyWord):
                            lineTimeStamp = getLineTimeStamp(lineInfo)
                            if not lineTimeStamp or countTimeSpanOfSecs(curTimeStamp, lineTimeStamp, 0, 0) < interval * 24 * 60 * 60:
                                dictInfo[keyWord].append(lineInfo)
                                if lineInfo not in uiDisplay:
                                    uiDisplay.insert(0, lineInfo)
                            else:
                                break 
            else:
                PY_LOGGER.info("[_generatKeyDictInfo] Parse without year log!")
                while not br.isEnd:
                    lineInfo=br.readline()
                    #找到日志中最后带有jif的一行
                    if 0 == maxJif and re.match(".*" + LOG_JIF_TAG + "\W+[0-9]+\W.*", lineInfo, re.IGNORECASE) :
                        maxJif = getLineJiffe(lineInfo, LOG_JIF_TAG)
                        if maxJif < 0:
                            flag = False
                            PY_LOGGER.error("[_generatKeyDictInfo] Get wrong maxJif information: " + str(maxJif))
                            continue
                       
                        PY_LOGGER.info("[_generatKeyDictInfo] Before adjust time stamp is:" + str(logTimeStamp) + ", lineInfo is:" + lineInfo)
                        logTimeStamp = adjustLogTimeStamp(lineInfo, LOG_JIF_TAG, logTimeStamp, PY_LOGGER)
                        PY_LOGGER.info("[_generatKeyDictInfo] After adjust time stamp is:" + str(logTimeStamp) + ", maxJif is:" + str(maxJif))
                    
                    #循环关键字，记录出现的关键字
                    for keyWord in KEY_WORD_LIST:
                        #找到带有关键字的一行，并判断是否在时间区间范围内
                        if 0 != maxJif and - 1 != lineInfo.find(keyWord):
                            curJif = getLineJiffe(lineInfo, LOG_JIF_TAG)
                            if curJif < 0:
                                continue
                            
                            if countTimeSpanOfSecs(curTimeStamp, logTimeStamp, maxJif, curJif) < interval * 24 * 60 * 60:
                                dictInfo[keyWord].append(lineInfo)
                                if lineInfo not in uiDisplay:
                                    uiDisplay.insert(0, lineInfo)
                            else:
                                break
            f.close()
            
        return True, dictInfo, uiDisplay
    except:
        PY_LOGGER.error("[_generatKeyDictInfo] Catch except of trace back:" + str(traceback.format_exc())) 
        return False, dictInfo, uiDisplay

def init(curPath, histPath, cprPath):
    global PATH_CUR, PATH_HIS, PATH_CPR
    PATH_CUR = curPath
    PATH_HIS = histPath
    PATH_CPR = cprPath
    return
  
#框架执行函数入口    
def checkResLeak(cli, py_java_env, PY_LOGGER):
    #全局变量
    flag = True 
    cliRet = "" 
    errMsg = "" 
    lang = py_java_env.get("lang")
    
    try:
        #获取系统是否为单控还是双控
        sysMode, cliRet, errMsg = getSysModeState(cli, py_java_env)
        if sysMode not in [MODE_SINGLE, MODE_DOUBLE]:
            PY_LOGGER.error("[1068EResLeak] not pass(Get unkown system mode)")
            return False, cliRet, errMsg
        
        isDownloadDouble = True if MODE_DOUBLE == sysMode else False
          
        #模式切换
        isSuccess, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
        if not isSuccess:
            PY_LOGGER.error("[1068EResLeak] not pass(change to debug failed)")
            return False, cliRet, errMsg
        
        #下载文件前判断系统内存是否足够
        flag, cliRet, errMsg = isEnoughMem(cli, py_java_env)
        if not flag:
            PY_LOGGER.error("[1068EResLeak] not pass(not have enough memory)")
            return False, cliRet, errMsg
        
        cliRet = ""
        
        #获取阵列当前时间，返回格式为20140628145802格式
        curTimeStamp = getCurDevTime(cli)
        PY_LOGGER.info("[1068EResLeak] The current time of system is: " + str(curTimeStamp))
        
        PY_LOGGER.info("[1068EResLeak] CurDir is:" + str(PATH_CUR))
        PY_LOGGER.info("[1068EResLeak] HisDir is:" + str(PATH_HIS))
        PY_LOGGER.info("[1068EResLeak] CprDir is:" + str(PATH_CPR))
        _downloadLogs2Local(cli, curTimeStamp, isDownloadDouble, py_java_env, PY_LOGGER, spanDays=90)
        
        PY_LOGGER.info("[1068EResLeak] Starting to decompress log files.")
        _decompressLocalFile(py_java_env, PY_LOGGER)  
        
        errMsg = ""
        ipAddr = getLocalIpAddr(py_java_env)
        itemFlag, localDictInfo, uiDisplay = _generatKeyDictInfo(py_java_env, PY_LOGGER, curTimeStamp, ipAddr, interval=90)
        if not itemFlag:
            flag = itemFlag
            if "zh" == lang:
                errMsg += u"\n解析控制器（" + str(ipAddr) + u"）日志文件失败。"
            else:
                errMsg += u"\nFailed to pare the logs file of controller " + str(ipAddr) + u"."
        else:
            PY_LOGGER.info("[1068EResLeak] Local dictinfo is:" + str(localDictInfo))
            if not _isRecordPass(PY_LOGGER, localDictInfo):
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器（" + str(ipAddr) + u"）存在资源泄露风险。"
                else:
                    errMsg += u"\nThe controller " + str(ipAddr) + u" exist 1068E leak risk."
                cliRet = "Controller " + str(ipAddr) + " :\n"
                for lineInfo in uiDisplay:
                    cliRet += lineInfo + "\n"
              
        if isDownloadDouble:
            ipAddr = getPeerIpAddr(cli, py_java_env)
            itemFlag, peerDictInfo, uiDisplay = _generatKeyDictInfo(py_java_env, PY_LOGGER, curTimeStamp, ipAddr, interval=90)
            if not itemFlag:
                flag = itemFlag
                if "zh" == lang:
                    errMsg += u"\n解析控制器（" + str(ipAddr) + u"）日志文件失败。"
                else:
                    errMsg += u"\nFailed to pare the logs file of controller " + str(ipAddr) + u"."
            else:
                PY_LOGGER.info("[1068EResLeak] Peer dictinfo is:" + str(peerDictInfo))
                if not _isRecordPass(PY_LOGGER, peerDictInfo):
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器（" + str(ipAddr) + u"）存在资源泄露风险。"
                    else:
                        errMsg += u"\nThe controller " + str(ipAddr) + u" exist 1068E leak risk."
                    cliRet += "\nController " + str(ipAddr) + " :\n"
                    for lineInfo in sorted(list(set(uiDisplay))):
                        cliRet += lineInfo + "\n"
        
        if flag:
            PY_LOGGER.info("Inspect[1068EResLeak] pass!")
            cliRet = NO_INFO_MSG
            return flag, cliRet, errMsg
                  
        return flag, cliRet, errMsg
   
    except:
        PY_LOGGER.error("Inspect[BackLostFrame] Catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, getExceptionMsg(lang)
    finally:
        changeAnyMode2Cli(cli)
   
