# -*- coding: UTF-8 -*-
from constant import * 

def _getUnitMode(deviceType, proVer):
    """
    # *****************************************************************************************#
    # 函数名称: _getUnitMode(deviceType, proVer)
    # 功能说明: 获取5000V100R001格式版本信息
    # 输入参数: deviceType：S5300格式，proVer：V100R001C01格式
    # 返 回 值: 5000V100R001格式版本信息
    # *****************************************************************************************#
    """
    unitMode = ""
    
    if deviceType and proVer and len(deviceType) >= 5:
        deviceType = deviceType.replace("E", "").strip()
        if "S26" == deviceType[0:2] or "S68" == deviceType[0:2]: 
            deviceType = deviceType[1:2] + "00"
        else:
            deviceType = deviceType[1:1] + "000"
        proVer = proVer[0:7]
        unitMode = deviceType + proVer
    return unitMode if unitMode and 12 == len(unitMode) else ""
    
def getDeviceMode(py_java_env, cli=None):
    """
    # *****************************************************************************************#
    # 函数名称: getDeviceMode(py_java_env, cli = None)
    # 功能说明: 获取5000V100R001格式版本信息
    # 输入参数: py_java_env, cli = None
    # 返 回 值: 5000V100R001格式版本信息
    # *****************************************************************************************#
    """
    devMode = ""
    
    deviceType = py_java_env.get("devInfo").getDeviceType()
    proVer = py_java_env.get("devInfo").getProductVersion()
    
    devMode = _getUnitMode(deviceType, proVer)
    if not devMode and cli:
        return devMode
    else:
        return devMode
    
