# -*- coding: UTF-8 -*-
import os
import re
import time
import datetime
import traceback
from cbb.frame.util.tar_util import decompress_tar_all_file
from constant import * 
from modeMgt import * 
from cTV1R1 import *
import cliMgt

CMD_IS_NOT_EXSIST_RET = "The command name is invalid|command format is wrong|Command :.*not exist|Command format is not right"
SELF_DEBUG_CMD_LIST = ["os_cli", "os_cli /tmp/"]
CLI_RET_END_FLAG = ":/>"

def getTypeAndVer(py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: getTypeAndVer(py_java_env)
    # 功能说明: 根据框架接口获取产品型号和R版本
    # 输入参数: py_java_env
    # 输出参数: 产品型号和R版本
    # *****************************************************************************************#
    """
    productVer = str(py_java_env.get("devInfo").getProductVersion())
    deviceType = str(py_java_env.get("devInfo").getDeviceType())
    return deviceType + productVer

# *******************************私有函数定义，仅供此文件内部调用*******************************#
def _getHeartbeatIp(cli, py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: _getHeartbeatIp(cli, py_java_env)
    # 功能说明: 获取对端心跳IP地址（需要确定使用之前为debug模式）
    # 输入参数: cli, py_java_env
    # 返 回 值: 对端心跳IP地址，获取无效时返回为空
    # *****************************************************************************************#
    """
    ip = py_java_env.get("heartIp") 
    if ip:
        return ip
       
    cliRet = cliMgt.execCmd(cli, "ifconfig")
    
    cliRetList = cliRet.splitlines()
    canFind = False
    
    #产品不同获取心跳IP关键字不同，2015/03/09 modified Begin
    heartBeatEthName = ""
    if "S2600V100R001" in getTypeAndVer(py_java_env):
        heartBeatEthName = "eth0 "
    else:
        heartBeatEthName = "bond0 "
      
    for lineInfo in cliRetList:
        lineInfo = lineInfo.strip()
        if lineInfo.startswith(heartBeatEthName):
            canFind = True
            continue
        try:
            #可以查找心跳IP了
            if canFind and lineInfo.startswith("inet addr:"):
                ip = lineInfo.split("Bcast")[0].replace("inet addr:", "").strip()
                if ip.endswith(".10"):
                    ip = ip[:ip.rfind(".")] + ".11"
                elif ip.endswith(".11"):
                    ip = ip[:ip.rfind(".")] + ".10"
                py_java_env.put("heartIp", ip)    
                break    
        except:
            return ""
    #产品不同获取心跳IP关键字不同，2015/03/09 modified End
    return ip

def switchToLocal(cli, PY_LOGGER):
    """
    # *****************************************************************************************#
    # 函数名称: switchToLocal(cli, py_java_env,PY_LOGGER)
    # 功能说明: 返回本端控制器
    # 输入参数: cli, py_java_env
    # 返 回 值: 
    # *****************************************************************************************#
    """
    try:    
        if not changeAnyMode2Cli(cli):
            raise Exception("Peer switch to Cli mode Failed")
			
        cliRet = cliMgt.execCmd(cli, "exit")
        if re.search("y/n", cliRet, re.IGNORECASE):
            cliRet = cliMgt.execCmd(cli, "y")

        if not re.search("closed", cliRet, re.IGNORECASE):
            raise Exception("Peer switch to Local Failed")
        
        if not changeAnyMode2Cli(cli):
            raise Exception("Local switch to Cli mode Failed")
    except:
        PY_LOGGER.error("[switchToLocal] catch except of trace back:" + str(traceback.format_exc()))
        cli.reConnect()
        return
    
#某些版本执行远程私有命令时需要带上绝对路径 modified 2015/04/07 Begin
def _getSelfCmdTryPathLst(cli, selfCmd):
    """
    # *****************************************************************************************#
    # 函数名称: _getSelfCmdTryPathLst(cli, selfCmd)
    # 功能说明: 获取私有命令应该尝试的路径,首先为默认路径，然后为绝对路径。
    # 输入参数: cli, selfCmd
    # 返 回 值: 路径列表
    # *****************************************************************************************#
    """
    tryPathList = [selfCmd]
    #传入命令为os_cli /tmp时特殊处理
    cliRet = cliMgt.execCmd(cli, "which " + selfCmd.split()[0])
    cliRetList = cliRet.splitlines()
    
    #找出私有命令所有的绝对路径
    for line in cliRetList[1:-1]:
        line = line.strip()
        if line.endswith(selfCmd.split()[0]):
            tryPathList.append(line[:-len(selfCmd.split()[0])] + selfCmd)
    
    #若是没有找到，则添加所有已知的绝对路径
    if 1 == len(tryPathList):
        tryPathList.append("/OSM/bin/" + selfCmd)
        tryPathList.append("/OSM/script/" + selfCmd)
        tryPathList.append("/OSM/bin/script/" + selfCmd)
    
    return tryPathList
#某些版本执行远程私有命令时需要带上绝对路径 modified 2015/04/07 End

def _sendMmlCmd2Peer(cli, mmlCmd, py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: _sendMmlCmd2Peer(cli, mmlCmd, py_java_env)
    # 功能说明: 发送mml命令到对端执行并获取CLI回显结果（必须保证在进入前为debug模式）
    # 输入参数: cli, mmlCmd, py_java_env
    # 返 回 值: True or False
    # *****************************************************************************************#
    """
    flag = False
    cliRet = ""
    sshPort = str(py_java_env.get("devInfo").getPort())
    
    #获取心跳IP地址
    heartBeat = _getHeartbeatIp(cli, py_java_env)
    if not heartBeat:
        return flag, cliRet
    
    #某些版本执行远程私有命令时需要带上绝对路径 modified 2015/04/07 Begin
    itemCliRet = ""
    cmdPathLst = _getSelfCmdTryPathLst(cli, "mml")
    for cmdPath in cmdPathLst:
        itemCliRet = cliMgt.execCmd(cli, "ssh admin@" + heartBeat + " -p " + sshPort + " \"echo -e '" + mmlCmd + "\\nexit\\n' | " + cmdPath + "\"")
        cliRet = itemCliRet
        
        if re.search("yes/no", itemCliRet, re.IGNORECASE):
            itemCliRet = cliMgt.execCmd(cli, "yes")
            cliRet += itemCliRet
            
        if re.search("y/n", itemCliRet, re.IGNORECASE):
            itemCliRet = cliMgt.execCmd(cli, "y")
            cliRet += itemCliRet
            
        if not re.search("Password:", itemCliRet, re.IGNORECASE):
            return flag, cliRet

        #回显存在两个结束符问题，正则指定结束符 modified 20140107 Begin
        itemCliRet = cli.execCmdWithConditions(str(py_java_env.get("devInfo").getLoginUser().getPassword()), \
                                               {"timeout":300, "recordLog":False, "sshJudge":":.*#\s*$"})
        #回显存在两个结束符问题，正则指定结束符 modified 20140107 End
    
        #命令执行成功直接跳出
        if re.search("command not found", itemCliRet, re.IGNORECASE) or re.search("bash.*No such file or directory", itemCliRet, re.IGNORECASE):
            continue
        else:
            break
    #某些版本执行远程私有命令时需要带上绝对路径 modified 2015/04/07 End
    
    cliRet += itemCliRet
    if re.search("spu ui>|MML>", itemCliRet, re.IGNORECASE):
        flag = True
        return flag, cliRet
    
    return flag, cliRet
       
#filePath为远端的路径
def _getDeviceFile(cli, py_java_env, deviceMsgDir, PY_LOGGER, isGetDouble=True):
    """
    # *****************************************************************************************#
    # 函数名称: _getDeviceFile(cli, py_java_env, deviceMsgDir, PY_LOGGER, isGetDouble = True)
    # 功能说明: 获取阵列指定路径文件（必须保证在进入前为debug模式）
    # 输入参数: cli, py_java_env, deviceMsgDir, PY_LOGGER, isGetDouble = True
    # 返 回 值: flag, localDirName, peerDirName
    # *****************************************************************************************#
    """
    try:
        
        sftp = py_java_env.get("sftp")
        
        fileName = os.path.basename(deviceMsgDir)
        PY_LOGGER.info("[getDeviceFile]Device message file is: " + str(deviceMsgDir))
        
        localDirName = ""
        peerDirName = ""
        
        #本地文件temp路径是否存在
        if not os.path.exists(LOCAL_TEMP_DIR):
            os.mkdir(LOCAL_TEMP_DIR)

        #获取本端文件到本地
        localDirName = LOCAL_TEMP_DIR + getLocalIpAddr(py_java_env) + "_local_" + fileName
        PY_LOGGER.info("[getDeviceFile]Local dir is:" + str(localDirName))
        
        #文件已存在，无需获取
        if not os.path.exists(localDirName):
            initSftp(sftp)
            sftp.getFile(deviceMsgDir, LOCAL_TEMP_DIR, None)
            os.rename(LOCAL_TEMP_DIR + fileName, localDirName)
        
        #双控，获取双控时，外面需保证为双控环境
        if isGetDouble:
            peerDirName = LOCAL_TEMP_DIR + str(getPeerIpAddr(cli, py_java_env)) + "_peer_" + fileName
            PY_LOGGER.info("[getDeviceFile]Peer dir is:" + str(localDirName))
            
            #对端文件已在本地直接返回
            if os.path.exists(peerDirName):
                return True, localDirName, peerDirName
            
            #获取对端文件到本地
            if scpPeerFile(cli, deviceMsgDir, py_java_env):
                initSftp(sftp)
                sftp.getFile(LOCAL_DEVICE_TEMP_PATH + fileName, LOCAL_TEMP_DIR, None)
                
                os.rename(LOCAL_TEMP_DIR + fileName, peerDirName)
                if isDevFileExsit(py_java_env, LOCAL_DEVICE_TEMP_PATH, fileName):
                    PY_LOGGER.info("[getDeviceFile] Delete device file: " + str(LOCAL_DEVICE_TEMP_PATH + fileName))
                    sftp.deleteFile(LOCAL_DEVICE_TEMP_PATH + fileName) 
            else:
                PY_LOGGER.info("[getDeviceFile]Copy peer file(" + str(LOCAL_DEVICE_TEMP_PATH + fileName) + ") failed.")
                return False, localDirName, peerDirName
        
        return True, localDirName, peerDirName
    
    except:
        PY_LOGGER.error("[getDeviceFile] catch except of trace back:" + str(traceback.format_exc()))
        return False, localDirName, peerDirName
    
# *******************************公有函数定义，可供此文件外部调用*******************************#
def getCurTime():
    """
    # *****************************************************************************************#
    # 函数名称: getCurTime()
    # 功能说明: 获取当前时间
    # 输入参数: 无
    # 返 回 值: 当前时间，单位秒
    # *****************************************************************************************#
    """
    curTime = str(time.time())
    return int(curTime[0:curTime.find(".")])

def getCurDevTime(cli):
    """
    # *****************************************************************************************#
    # 函数名称: getCurDevTime(cli)
    # 功能说明: 获取系统当前时间，执行失败时以本地时间为准（bebug模式下）
    # 输入参数: cli
    # 输出参数: 20140628145802格式时间戳
    # *****************************************************************************************#
    """
    cliRet = cliMgt.execCmd(cli, "date +%Y%m%d%H%M%S")
    
    cliRetList = cliRet.splitlines()
    for lineInfo in cliRetList:
        if re.match("^[0-9]{14}", lineInfo.strip()):
            return lineInfo.strip()
        
    #系统时间获取失败则以当前工具时间为准
    return time.strftime("%Y%m%d%H%M%S")

def getLocaTmplFilePath(py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: getLocaTmplFilePath(py_java_env)
    # 功能说明: 获取本地临时存放分析文件的目录，时间戳以记录的本次工具启动时间为准
    # 输入参数: py_java_env
    # 输出参数: 本地临时路径
    # *****************************************************************************************#
    """
    return str(LOCAL_TEMP_DIR + formatSec2TimeStamp(int(py_java_env.get("startTime"))) + "_" + getLocalIpAddr(py_java_env) + os.path.sep)

def getDevTmpFilePath(py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: getDevTmpFilePath(py_java_env)
    # 功能说明: 获取阵列上面临时存放目录，时间戳以记录的本次工具启动时间为准
    # 输入参数: py_java_env
    # 输出参数: 阵列本端路径
    # *****************************************************************************************#
    """
    return str(LOCAL_DEVICE_TEMP_PATH + formatSec2TimeStamp(int(py_java_env.get("startTime"))) + "_ToolTmp/")

def formatSec2TimeStamp(timeSec):
    """
    # *****************************************************************************************#
    # 函数名称: formatSec2TimeStamp(timeSec)
    # 功能说明: 秒（即距离1970年7月1日的秒数）格式化为20140628145802时间戳格式
    # 输入参数: timeSec（秒）
    # 输出参数: 20140628145802格式时间戳（字符串）
    # *****************************************************************************************#
    """
    if not timeSec:
        return ""
    
    curTimeStamp = time.localtime(int(timeSec))
    return str(curTimeStamp.tm_year) + str(curTimeStamp.tm_mon).zfill(2) + str(curTimeStamp.tm_mday).zfill(2) \
                + str(curTimeStamp.tm_hour).zfill(2) + str(curTimeStamp.tm_min).zfill(2) + str(curTimeStamp.tm_sec).zfill(2)

def formatTimeStamp2Sec(timeStamp):
    """
    # *****************************************************************************************#
    # 函数名称: formatTimeStamp2Sec(timeStamp)
    # 功能说明: 格式化20140628145802格式时间戳为秒（即距离1970年7月1日的秒数便于统一换算）
    # 输入参数: timeStamp（时间戳）
    # 输出参数: seconds（整数秒）
    # *****************************************************************************************#
    """
    if not timeStamp:
        return -1
    
    timeStamp = str(timeStamp)
    dateTime = datetime.datetime.strptime(timeStamp, "%Y%m%d%H%M%S")
    return int(time.mktime(dateTime.timetuple()))

def getDevVer(cli):
    """
    # **************************************************************************** #
    # 函数名称: getDevVer(cli)
    # 功能说明: 获取设备软件版本号，进入前确定在CLI模式下
    # 输入参数: cli
    # 输出参数: SoftwareVersion
    # **************************************************************************** # 
    """
    cliRet = ""
    try:
        deviceVer = ""
        
        #不同的版本，CLI命令可能不一样，挑选出当前版本支持的CLI命令并获得对应回显结果 
        cmd, cliRet = getSupportCliRet(cli, ["showallversion", "showallver"])
        
        startIndex = getLocation(cliRet, "Software Version", P_Contain)
        if -1 == startIndex:
            return "", cliRet
        
        #获取回显开始的起始位置
        endIndex = getLocation(cliRet, "----------------", P_Contain, startIndex)
        if -1 == endIndex:
            return "", cliRet
        
        #第二个参数传入[]表示获取所有key值对应的value
        formatFunction = cHandleTypeList(cliRet, ["Controller", "Soft Version", "Software Version"], areaIndex=[startIndex, endIndex])
        listDict = formatFunction.handle()
        
        if not listDict:
            #兼容R5版本
            endIndex = getLocation(cliRet, "==========", P_Contain, startIndex)
            if -1 == endIndex:
                return "", cliRet
            
            #第二个参数传入[]表示获取所有key值对应的value
            formatFunction = cHandleTypeList(cliRet, ["Controller", "Soft Version", "Software Version"], areaIndex=[startIndex, endIndex])
            listDict = formatFunction.handle()
        
        #获取产品软件版本号
        for dictInfo in listDict:
            deviceVer = dictInfo.get("Soft Version")
            if not deviceVer:
                deviceVer = dictInfo.get("Software Version")
                
            if isValidVal(deviceVer):
                return deviceVer, cliRet
            
        return "", cliRet
    
    except:
        return "", cliRet
    
def getDevModel(cli, py_java_env):
    """
    # **************************************************************************** #
    # 函数名称: getDevModel(cli, py_java_env)
    # 功能说明: 获取设备的版本号类型
    # 输入参数: cli, py_java_env
    # 输出参数: deviceType
    # **************************************************************************** # 
    """
    cliRet = ""
    deviceVer = ""
    
    devModel = DevModel.UnKnown
    curMode = getCurrentMode(cli)
    
    try:
        
        #先从框架里面获取当前的产品版本
        devModel = py_java_env.get("devModel")
        if devModel and DevModel.UnKnown != devModel:
            return devModel, cliRet
        
        if not changeAnyMode2Cli(cli):
            return DevModel.UnKnown, cliRet
        
        
        deviceVer, cliRet = getDevVer(cli)
        
        if not deviceVer:
            return DevModel.UnKnown, cliRet
        
        #标准版本号转换
        deviceVer = deviceVer.replace(".", "").replace("T", "")
        
        #根据设备类型和版本号归类
        #S5000
        if deviceVer.startswith(S5000_VERSION):
            #S5000 V1R1需要区分OSM版本和ISM版本
            if deviceVer.startswith(S5000R1_VERSION):
                if deviceVer >= S5000R1_ISM_VERSION:
                    devModel = DevModel.S5000ISM
                else:
                    devModel = DevModel.S5000OSM
            #特殊的：S5000 V1R2版本与OSM版本处理一致
            else:
                devModel = DevModel.S5000OSM
        
        #S2000（只有V1R1版本）
        elif deviceVer.startswith(S2000_VERSION):
            if deviceVer >= S2000R1_ISM_VERSION:
                devModel = DevModel.S2000ISM
            else:
                devModel = DevModel.S2000OSM
        #S2600    
        elif deviceVer.startswith(S2600_VERSION):
            if deviceVer >= S2600R2_NEW_VERSION:
                devModel = DevModel.S2600NEW
            else:
                devModel = DevModel.S2600OLD
        
        py_java_env.put("devModel", devModel)
        return devModel, cliRet
        
    except:
        return DevModel.UnKnown, cliRet
    finally:
        change2AimMode(cli, py_java_env, curMode)
 
def getDevModelVer(cli, py_java_env):   
    """
    # *****************************************************************************************#
    # 函数名称: getDevModelVer(cli, py_java_env)
    # 功能说明: 获取当前版本是ISM还是OSM版本
    # 输入参数: cli, py_java_env
    # 返 回 值: ISM_VER，OSM_VER，UNKOWN_VER
    # *****************************************************************************************#
    """
    devModel, cliRet = getDevModel(cli, py_java_env)
    
    if devModel:
        devModel = str(devModel)
        
        if devModel in ISM_VER_LIST:
            return ISM_VER, cliRet
        elif devModel in OSM_VER_LIST:
            return OSM_VER, cliRet
    return UNKOWN_VER, cliRet      
        
def getSysModeState(cli, py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: getSysModeState(cli, py_java_env)
    # 功能说明: 系统是否为双控（调用时尽量保证在CLI模式下）
    # 输入参数: cli, py_java_env
    # 返 回 值: sysMode, cliRet
    # *****************************************************************************************#
    """
    curMode = getCurrentMode(cli)
    lang = py_java_env.get("lang")
    sysMode = MODE_UNKOWN
    cliRet = ""
    errMsg = ""
    try:
        #通过mml命令判断单双控，2014/09/12 modified Begin
        #切换MML模式
        flag, cliRet, errMsg = changeAnyMode2Mml(cli, py_java_env)
        if not flag:
            return MODE_UNKOWN, cliRet, errMsg
        
        cliRet = cliMgt.execCmd(cli, "sys status")
        lines = cliRet.splitlines()
        for line in lines:
            if line.strip().startswith("Double Or Single"):
                currentSysMode = line[line.find(":"):].lower()
                if "single" in currentSysMode:
                    sysMode = MODE_SINGLE
                elif "double" in currentSysMode:
                    sysMode = MODE_DOUBLE
        
        if sysMode == MODE_UNKOWN:
            if "zh" == lang:
                errMsg = u"\n系统状态异常。"
            else:
                errMsg = u"\nThe system is abnormal."
        #通过mml命令判断单双控，2014/09/12 modified End
        return sysMode, cliRet, errMsg
        
    except:
        return MODE_UNKOWN, cliRet, getExceptionMsg(lang)
    finally:
        change2AimMode(cli, py_java_env, curMode)

def isValidVal(val):
    """
    # *****************************************************************************************#
    # 函数名称: isValidVal(val）
    # 功能说明: 判断key对应的value值是否有效
    # 输入参数: val
    # 输出参数: True or False
    # *****************************************************************************************#
    """
    return True if val and re.search("[a-zA-Z0-9]+", val) else False

def isInTimeSpan(occurTimeSec, curTimeSec, spanDays=180):
    """
    # **************************************************************************** #
    # 函数名称: isInTimeSpan(occurTimeSec, curTimeSec, spanDays=180)
    # 功能说明: 是否在时间跨度范围内
    # 输入参数: occurTimeSec, curTimeSec, spanDays=180
    # 输出参数: True or False
    # **************************************************************************** # 
    """
    return True if (int(curTimeSec) - int(occurTimeSec)) <= int(spanDays) * 24 * 60 * 60 else False

def isDevFileExsit(py_java_env, tempPath, fileName):
    """
    # *****************************************************************************************#
    # 函数名称: isDevFileExsit(py_java_env, tempPath, fileName)
    # 功能说明: 判断deviceDir文件（绝对路径）在阵列上面是否存在
    # 输入参数: py_java_env, tempPath, fileName
    # 输出参数: True or False
    # *****************************************************************************************#
    """
    sftp = py_java_env.get("sftp")
    initSftp(sftp)
    return sftp.isFileExist(tempPath, fileName)

def isEnoughMem(cli, py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: isEnoughMem(cli, py_java_env)
    # 功能说明: 判断系统空闲内存是否足够
    # 输入参数: cli, py_java_env
    # 输出参数: flag, cliRet, errMsg
    # *****************************************************************************************#
    """
    flag = True
    cliRet = ""
    lang = py_java_env.get("lang")
    
    curMode = getCurrentMode(cli)
    try:
        memFreeSize = 0
        
        flag, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
        if flag:
            #清理阵列缓存信息
            cliMgt.execCmd(cli, "echo \"freepages\" > /proc/osp/bsp")
            cliRet = cliMgt.execCmd(cli, "free -m")
            cliRetList = cliRet.splitlines()
            for lineInfo in cliRetList:
                lineInfo = lineInfo.strip()
                if lineInfo.startswith("Mem:"):
                    memFreeSize = int(lineInfo.split()[3])
        
        if memFreeSize <= MAX_FREE_MEM:
            flag = False
            if "zh" == lang:
                errMsg = u"\n系统空闲内存不足" + str(MAX_FREE_MEM) + u"M，无法下载文件。"
            else:
                errMsg = u"\nNot have enough memory(" + str(MAX_FREE_MEM) + u"M), can't download the file. "
        
        return flag, cliRet, errMsg       
    except:
        return False, cliRet, getExceptionMsg(lang)
    finally:
        change2AimMode(cli, py_java_env, curMode)

def mkLocalTmpPath(fileDir):
    """
    # *****************************************************************************************#
    # 函数名称: mkLocalTmpPath(fileDir)
    # 功能说明: 创建本地临时目录
    # 输入参数: fileDir
    # 输出参数: 无
    # *****************************************************************************************#
    """
    if not os.path.exists(fileDir):
        os.mkdir(fileDir)
    return 

def mkDevTmpPath(cli, py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: mkDevTmpPath(cli, py_java_env)
    # 功能说明: 在阵列上面创建临时目录（进入前确保在debug模式下）
    # 输入参数: cli, py_java_env
    # 输出参数: 无
    # *****************************************************************************************#
    """
    devTmpPath = getDevTmpFilePath(py_java_env)
    cliMgt.execCmd(cli, "mkdir " + LOCAL_DEVICE_TEMP_PATH)
    cliMgt.execCmd(cli, "mkdir " + devTmpPath)
    return 

def preCheckCliRet(cmd, cliRet, lang, necessaryData=False):
    """
    # *****************************************************************************************#
    # 函数名称: preCheckCliRet(cmd, cliRet, lang, necessaryData = False):
    # 功能说明: 查询当前获取的Cli信息是否有效
    # 输入参数: cmd，cliRet, lang 
    #           necessaryData：系统中必须包含的配置为True（如控制器、框等）（boolean）
    # 输出参数: preRet（CLI回显初步判断，取值范围：RET_OK，RET_SUC，RET_FAIL）, errMsg
    # *****************************************************************************************#
    """
    preRet = RET_FAIL
    errMsg = ""
    
    if cliRet:
        #异常模式，直接返回CLI回显错误
        if re.search("-bash|power on", cliRet, re.IGNORECASE):
            if "zh" == lang:
                errMsg = u"\nCLI模式错误。"
            else:
                errMsg = u"\nThe CLI mode is incorrect."
            return RET_FAIL, errMsg
        
        if re.search(CMD_IS_NOT_EXSIST_RET, cliRet, re.IGNORECASE):
            if "zh" == lang:
                errMsg = u"\n\'" + str(cmd) + u"\'命令格式错误。"
            else:
                errMsg = u"\nThe \'" + str(cmd) + u"\' command format is incorrect."
            return RET_FAIL, errMsg
        
        #命令回文大于4行，说明必然有数据，返回CLI回显信息正确，具体需要后续逻辑判断是否通过
        lineList = cliRet.splitlines()   
        if len(lineList) >= 4:
            return RET_OK, errMsg
         
        #命令执行后回显只有两行，说明命令执行成功没有回显信息（老产品老版本查询LUN无LUN是这样显示）
        if len(lineList) == 2 and not necessaryData:
            return RET_SUC, errMsg
        
        #showiscsiip命令特殊处理
        if cmd == "showiscsiip" and len(lineList) == 3 and not re.search("error", cliRet, re.IGNORECASE) \
            or re.search("Error showiscsiip: Message can't reachable!", cliRet, re.IGNORECASE):
            return RET_SUC, errMsg
        
        #系统中必须包含的配置（如控制器、框等比大于4行）
        if necessaryData:
            preRet = RET_FAIL 
        elif re.search(CLI_NORMAL_INFO, cliRet, re.IGNORECASE):
            preRet = RET_SUC
    #回显为空
    else:
       preRet = RET_FAIL 
    
    if RET_FAIL == preRet:
        if "zh" == lang:
            errMsg = u"\n\'" + str(cmd) + u"\'命令执行结果无效。"
        else:
            errMsg = u"\nThe output of the \'" + str(cmd) + u"\' command is invalid."
    return preRet, errMsg

def getSupportCliRet(cli, cmdList, withLog=True):
    """
    # *****************************************************************************************#
    # 函数名称: getSupportCliRet(cli, cmdList, withLog = True）
    # 功能说明: 传入多个CLI支持命令，选择一个当前版本支持的命令并返回（调用时保证在CLI模式下）
    # 输入参数: cli, cmdList（CLI命令列表）, withLog = True
    # 输出参数: cmd, cliRet
    # *****************************************************************************************#
    """
    
    #入参判断
    cmd = ""
    cliRet = ""
    if not cli or not cmdList:
        return cmd, cliRet
    
    for cmd in cmdList:
        if withLog:
            cliRet = cliMgt.execCmd(cli, cmd)
        else:
            cliRet = cliMgt.execCmdNoLog(cli, cmd)
        if not re.search(CMD_IS_NOT_EXSIST_RET, cliRet, re.IGNORECASE):
            return cmd, cliRet
    return cmd, cliRet

def getLoginName(py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: getLoginName(py_java_env)
    # 功能说明: 获取登录设备名
    # 输入参数: py_java_env
    # 返 回 值: userName
    # *****************************************************************************************#
    """
    return str(py_java_env.get("devInfo").getLoginUser().getUserName())

def getIpAddrlist(cli, py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: getIpAddrlist(cli, py_java_env)
    # 功能说明: 获取IP地址列表（调用时保证在CLI模式下）
    # 输入参数: cli, py_java_env
    # 返 回 值: IP地址列表
    # *****************************************************************************************#
    """
    ipAddrList = []
    
    ip = getLocalIpAddr(py_java_env)
    if ip:
        ipAddrList.append(ip)
    
    ip = getPeerIpAddr(cli, py_java_env)
    if ip:
        ipAddrList.append(ip)
    
    return ipAddrList

def getLocalIpAddr(py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: getLocalIpAddr(py_java_env)
    # 功能说明: 通过框架获取本地IP地址
    # 输入参数: py_java_env
    # 返 回 值: localIpAddr
    # *****************************************************************************************#
    """
    return str(py_java_env.get("devInfo").getIp())

def getPeerIpAddr(cli, py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: getPeerIpAddr(cli, py_java_env)
    # 功能说明: 获取对端IP地址（调用时保证在CLI模式下）
    # 输入参数: cli, py_java_env
    # 返 回 值: peerIpAddr
    # *****************************************************************************************#
    """
    #先从框架提供的全局变量中获取
    peerIp = py_java_env.get("devInfo").getPeerIp()
    if peerIp:
        return peerIp
    
    #再从框架自己保存的全局变量中获取
    peerIp = py_java_env.get("peerIp")
    if peerIp:
        return peerIp
    
    curMode = getCurrentMode(cli)

    try:

        peerIp = ""
        lang = py_java_env.get("lang")
        localIp = str(py_java_env.get("devInfo").getIp())
        
        if not changeAnyMode2Cli(cli):
            return peerIp
        
        cmd = "showctrlip"
        cliRet = cliMgt.execCmd(cli, cmd)
        #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
        preCheck, errMsg = preCheckCliRet(cmd, cliRet, lang)
        if RET_FAIL == preCheck:
            return peerIp
        
        formatFunction = cHandleTypeList(cliRet)
        listDict = formatFunction.handle()
        
        for dictInfo in listDict:
            if localIp != dictInfo.get("IP Address"):
                peerIp = str(dictInfo.get("IP Address"))
                break
        py_java_env.put("peerIp", peerIp)
        return peerIp
    except:
        return peerIp
    finally:
        change2AimMode(cli, py_java_env, curMode)
        

def getKeyInfoInLog(localFileDir, keyWord):
    """
    # *****************************************************************************************#
    # 函数名称: getKeyInfoInLog(localFileDir, keyWord)
    # 功能说明: 从message文件中获取带有关键字信息的所有累加行信息
    # 输入参数: localFileDir, keyWord
    # 输出参数: msg
    # *****************************************************************************************#
    """
    msg = ""
    
    f = open(localFileDir, "r")

    for lineInfo in f:
        if re.search(keyWord, lineInfo):
            msg += lineInfo + "\n"
    f.close()
    return msg


def scpPeerFile(cli, devicePeerDir, py_java_env, deviceTmpDir=LOCAL_DEVICE_TEMP_PATH):
    """
    # *****************************************************************************************#
    # 函数名称: scpPeerFile(cli, devicePeerDir, py_java_env)
    # 功能说明: 通过心跳IP拷贝对端文件到本段指定目录
    # 输入参数: cli, devicePeerDir, py_java_env
    # 返 回 值: 对端心跳IP地址，获取无效时返回为空
    # *****************************************************************************************#
    """
    curMode = getCurrentMode(cli)
    sshPort = str(py_java_env.get("devInfo").getPort())
    try:
        flag, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
        if not flag:
            return False
        
        #获取心跳IP地址
        heartBeat = _getHeartbeatIp(cli, py_java_env)
        if not heartBeat:
            return False
        
        itemCliRet = cliMgt.execCmd(cli, "scp -P " + sshPort + " admin@" + str(heartBeat) + ":" + str(devicePeerDir) + " " + deviceTmpDir)
        cliRet = itemCliRet
        if re.search("Are you sure you want to continue connecting (yes/no)?", itemCliRet, re.IGNORECASE):
            itemCliRet = cliMgt.execCmd(cli, "yes")
            cliRet += itemCliRet
            
        if not re.search("Password:", cliRet, re.IGNORECASE):
            return False
        
        pwd = str(py_java_env.get("devInfo").getLoginUser().getPassword())
        cliRet = cliMgt.execCmdNoLog(cli, pwd)
        
        if re.search("No such file or directory", cliRet, re.IGNORECASE):
            return False
        
        if not re.search(os.path.basename(devicePeerDir), cliRet, re.IGNORECASE) and \
           not re.search("get file size successed", cliRet, re.IGNORECASE):
            return False
        return True
    except:
        return False
    finally:
        change2AimMode(cli, py_java_env, curMode)

def delDevLocalFile(cli, py_java_env, devFileDir):
    """
    # *****************************************************************************************#
    # 函数名称: deleteDevFile(cli, py_java_env, devFileDir)
    # 功能说明: 删除阵列指定目录下面的文件（debug模式下）
    # 输入参数: cli, py_java_env, devFileDir
    # 返 回 值: True or False
    # *****************************************************************************************#
    """
    curMode = getCurrentMode(cli)
    try:
        
        iRet = changeAnyMode2Debug(cli, py_java_env)
        if not iRet[RET_FLAG]:
            return False
        
        cmd = "rm -rf " + str(devFileDir)
        cliMgt.execCmd(cli, cmd)
        
        if "log_reset.txt" == os.path.basename(devFileDir):
            baseDir = os.path.dirname(devFileDir) if "/" == os.path.dirname(devFileDir)[-1] else os.path.dirname(devFileDir) + "/"
            cliMgt.execCmd(cli, "rm -rf " + baseDir + "log_bios.txt")
            cliMgt.execCmd(cli, "rm -rf " + baseDir + "log_coredump.txt")
            cliMgt.execCmd(cli, "rm -rf " + baseDir + "log_feeddog.txt")
        return True
    except:
        return False
    finally:
        change2AimMode(cli, py_java_env, curMode)
   
def delDevRemoteFile(cli, py_java_env, devFileDir, PY_LOGGER):
    """
    # *****************************************************************************************#
    # 函数名称: deleteRemoteDevFile(cli, py_java_env, devFileDir,PY_LOGGER)
    # 功能说明: 删除阵列对端指定目录下面的文件（debug模式下）
    # 输入参数: cli, py_java_env, devFileDir,PY_LOGGER
    # 返 回 值: True or False
    # *****************************************************************************************#
    """
    curMode = getCurrentMode(cli)
    try:
        
        iRet = changeAnyMode2Debug(cli, py_java_env)
        if not iRet[RET_FLAG]:
            return False
        
        
        cmd = "rm -rf " + str(devFileDir)
        sendDebugCmd2Peer(cli, cmd, py_java_env, PY_LOGGER)
        
        if "log_reset.txt" == os.path.basename(devFileDir):
            baseDir = os.path.dirname(devFileDir) if "/" == os.path.dirname(devFileDir)[-1] else os.path.dirname(devFileDir) + "/"
            sendDebugCmd2Peer(cli, "rm -rf " + baseDir + "log_bios.txt", py_java_env, PY_LOGGER)
            sendDebugCmd2Peer(cli, "rm -rf " + baseDir + "log_coredump.txt", py_java_env, PY_LOGGER)
            sendDebugCmd2Peer(cli, "rm -rf " + baseDir + "log_feeddog.txt", py_java_env, PY_LOGGER)
        return True
    except:
        return False
    finally:
        change2AimMode(cli, py_java_env, curMode)
              
def mvLocalDevFile2Local(cli, py_java_env, ipAddr, fromDir):
    """
    # *****************************************************************************************#
    # 功能说明: 获取阵列fromDir目录下面的文件到本地临时目录下
    # 输入参数: cli, py_java_env, ipAddr, fromDir
    # 返 回 值: True or False及获取后保存到本地的绝对路径信息
    # *****************************************************************************************#
    """
    try:
        sftp = py_java_env.get("sftp")
        
        fileName = os.path.basename(fromDir)
        
        localFilePath = getLocaTmplFilePath(py_java_env)
        
        newLocalFileDir = localFilePath + ipAddr + "_" + fileName
        
        #本地文件已存在，无需获取
        if os.path.exists(newLocalFileDir):
            return True, newLocalFileDir
        initSftp(sftp)
        sftp.getFile(fromDir, localFilePath, None)
        os.rename(localFilePath + fileName, newLocalFileDir)
        return os.path.exists(newLocalFileDir), newLocalFileDir
    except:
        if os.path.exists(newLocalFileDir):
            try:
                os.remove(newLocalFileDir)
            except:
                return False, ""
        return False, ""

        
def mvPeerDevFile2Local(cli, py_java_env, ipAddr, fromDir):
    """
    # *****************************************************************************************#
    # 功能说明: 获取对端阵列fromDir目录下面的文件到本端阵列/tmp/目录下，然后获取到本地临时目录下
    # 输入参数: cli, py_java_env, ipAddr, fromDir
    # 返 回 值: True or False及获取后保存到本地的绝对路径信息
    # *****************************************************************************************#
    """
    sftp = py_java_env.get("sftp")

    fileName = os.path.basename(fromDir)
    
    localFilePath = getLocaTmplFilePath(py_java_env)
    
    newLocalFileDir = localFilePath + ipAddr + "_" + fileName
    
    #本地文件已存在，无需获取
    if os.path.exists(newLocalFileDir):
        return True, newLocalFileDir
        
    #拷贝对端文件到本端/tmp/临时目录下
    if not scpPeerFile(cli, fromDir, py_java_env, LOCAL_DEVICE_TEMP_PATH):
        return False, "....."
    
    return mvLocalDevFile2Local(cli, py_java_env, ipAddr, LOCAL_DEVICE_TEMP_PATH + fileName)

def sendDebugCmd2Peer(cli, debugCmd, py_java_env, PY_LOGGER):
    """
    # *****************************************************************************************#
    # 功能说明: 发送debug命令到对端执行并获取CLI回显结果（进入前需要保证为双控正常）
    # 输入参数: cli, debugCmd, py_java_env
    # 返 回 值: flag, cliRet,errMsg
    # *****************************************************************************************#
    """
    flag = False
    cliRet = ""
    errMsg = ""
    curMode = getCurrentMode(cli)
    lang = py_java_env.get("lang")
    sshPort = str(py_java_env.get("devInfo").getPort())
    
    try:
        #获取心跳IP地址
        heartBeat = _getHeartbeatIp(cli, py_java_env)
        if not heartBeat:
            PY_LOGGER.error("[sendDebugCmd2Peer] Getting heart beat ip address invalid(" + str(heartBeat) + ").")
            if "zh" == lang:
               errMsg = u"\n获取心跳IP地址无效。" 
            else:
               errMsg = u"\nThe obtained heart beat IP address is invalid."  
            return False, cliRet, errMsg
        
        flagItem, cliRet1, errMsg = changeAnyMode2Debug(cli, py_java_env)
        if not flagItem:
            PY_LOGGER.error("[sendDebugCmd2Peer] change to debug mode failed.")
            return False, cliRet1, errMsg
        
        #某些版本执行远程私有命令时需要带上绝对路径 modified 2015/04/07 Begin
        defaultTryCmdLst = [debugCmd]
        isSelfCmd = False
        if debugCmd in SELF_DEBUG_CMD_LIST:
            defaultTryCmdLst = _getSelfCmdTryPathLst(cli, debugCmd)
            PY_LOGGER.info("[sendDebugCmd2Peer] Self cmd, get Try path list:" + str(defaultTryCmdLst))
            isSelfCmd = True

        for debugCmdParam in defaultTryCmdLst:         
            itemCliRet = cliMgt.execCmd(cli, "ssh admin@" + heartBeat + " -p " + sshPort + " " + debugCmdParam)
            cliRet = cliRet1 + itemCliRet
            
            if re.search("Are you sure you want to continue connecting (yes/no)?", itemCliRet, re.IGNORECASE):
                itemCliRet = cliMgt.execCmd(cli, "yes")
                cliRet += itemCliRet
                
            if re.search("Password:", itemCliRet, re.IGNORECASE):
                itemCliRet = cliMgt.execCmdNoLog(cli, str(py_java_env.get("devInfo").getLoginUser().getPassword()))
                
                #命令失败继续执行其它带绝对路径的命令
                if isSelfCmd and (re.search("command not found", itemCliRet, re.IGNORECASE) or re.search("bash.*No such file or directory", itemCliRet, re.IGNORECASE)):
                    continue
                
                cliRet += itemCliRet
             
                if not re.search("Password:", itemCliRet, re.IGNORECASE) and not re.search("Too many authentication failures", itemCliRet, re.IGNORECASE):
                    flag = True
                    return flag, cliRet, errMsg
                else:
                    flag = False
                    break
        #某些版本执行远程私有命令时需要带上绝对路径 modified 2015/04/07 End
        
        if not flag:
            if "zh" == lang:
                errMsg = u"\n发送命令" + str(debugCmd) + u"到对端失败。"
            else: 
                errMsg = u"\nFailed to send the \'" + str(debugCmd) + "\' command to the peer."  
        return flag, cliRet, errMsg
    except:
        PY_LOGGER.error("[sendDebugCmd2Peer] catch except of trace back:" + str(traceback.format_exc()))
        if "zh" == lang:
            errMsg = u"\n发送命令" + str(debugCmd) + u"到对端异常。"
        else: 
            errMsg = u"\nSend cmd \'" + str(debugCmd) + "\' to peer catch exception."  
        return False, cliRet, errMsg
    finally:
        change2AimMode(cli, py_java_env, curMode)
  

def sendDebugCmd2PeerInDebugMode(cli, debugCmd, py_java_env, PY_LOGGER, timeOut=0):
    """
    # *****************************************************************************************#
    # 函数名称: sendDebugCmd2PeerInDebugMode(cli, debugCmd, py_java_env)
    # 功能说明: 发送debug命令到对端执行并获取CLI回显结果（进入前需要保证为双控正常）
    # 输入参数: cli, debugCmd, py_java_env
    # 返 回 值: flag, cliRet,errMsg
    # *****************************************************************************************#
    """
    flag = False
    cliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    sshPort = str(py_java_env.get("devInfo").getPort())
    
    try:
        #获取心跳IP地址
        heartBeat = _getHeartbeatIp(cli, py_java_env)
        if not heartBeat:
            PY_LOGGER.error("[sendDebugCmd2Peer] Getting heart beat ip address invalid(" + str(heartBeat) + ").")
            if "zh" == lang:
                errMsg = u"\n获取心跳IP地址无效。" 
            else:
                errMsg = u"\nThe obtained heart beat IP address is invalid."  
            return False, cliRet, errMsg
        
        if timeOut:
            itemCliRet = cliMgt.execCmdWithTimout(cli, "ssh admin@" + heartBeat + " -p " + sshPort + " \"" + debugCmd + "\"", timeOut)
        else:
            itemCliRet = cliMgt.execCmd(cli, "ssh admin@" + heartBeat + " -p " + sshPort + " \"" + debugCmd + "\"")
        
        cliRet += itemCliRet
        
        if re.search("Are you sure you want to continue connecting (yes/no)?", itemCliRet, re.IGNORECASE):
            if timeOut:
                itemCliRet = cliMgt.execCmdWithTimout(cli, "yes", timeOut)
            else:
                itemCliRet = cliMgt.execCmd(cli, "yes")
            cliRet += itemCliRet
            
        if re.search("Password:", itemCliRet, re.IGNORECASE):
            if timeOut:
                itemCliRet = cliMgt.execCmdNoLogTimout(cli, str(py_java_env.get("devInfo").getLoginUser().getPassword()), timeOut)
            else:
                itemCliRet = cliMgt.execCmdNoLog(cli, str(py_java_env.get("devInfo").getLoginUser().getPassword()))
            
            cliRet += itemCliRet
         
            if not re.search("Password:", itemCliRet, re.IGNORECASE) and not re.search("Too many authentication failures", itemCliRet, re.IGNORECASE):
                flag = True
                return flag, cliRet, errMsg
            else:
                flag = False
                
        if not flag:
            if "zh" == lang:
                errMsg = u"\n发送命令" + str(debugCmd) + u"到对端失败。"
            else: 
                errMsg = u"\nFailed to send the \'" + str(debugCmd) + "\' command to the peer."  
        return flag, cliRet, errMsg
    except:
        PY_LOGGER.error("[sendDebugCmd2Peer] catch except of trace back:" + str(traceback.format_exc()))
        if "zh" == lang:
            errMsg = u"\n发送命令" + str(debugCmd) + u"到对端异常。"
        else: 
            errMsg = u"\nSend cmd \'" + str(debugCmd) + "\' to peer catch exception."  
        return False, cliRet, errMsg
 
 
def execMmlCmdLocalBefore(cli, mmlCmdList, py_java_env, PY_LOGGER, isDouble=True, isIgnorePeer=False):
    """
    # *****************************************************************************************#
    # 函数名称: execMmlCmd(cli, mmlCmd, py_java_env, PY_LOGGER, isDouble = True)
    # 功能说明: 发送MML命令并获取回显信息,本端先执行
    # 输入参数: cli, mmlCmd, py_java_env, PY_LOGGER, isDouble = True
    # 返 回 值: 失败：False, cliRet, errMsg
    #           成功：True，localCliret, peerCliRet
    # *****************************************************************************************#
    """
    flag = True
    cliRet = ""
    errMsg = ""
    localCliRet = ""
    peerCliRet = ""
    
    curMode = getCurrentMode(cli)
    lang = py_java_env.get("lang")
    
    try:
        #将传进来的单个命令组成列表
        if type(mmlCmdList) == type("str"):
            mmlCmdList = [mmlCmdList]
        
        #本端进入MML模式，发送MML命令
        PY_LOGGER.info("[execMmlCmd] start to send mml cmd to local.")
        flag, cliRet, errMsg = changeAnyMode2Mml(cli, py_java_env)
        if not flag:
            PY_LOGGER.error("[execMmlCmd] change to mml mode failed.")
            return False, cliRet, errMsg
        for mmlCmd in mmlCmdList:
            localCliRet += "\n" + cliMgt.execCmd(cli, mmlCmd)
        
        #若是双控，且需要发送到对端执行
        if isDouble:
            mmlCmdMany = ""
            PY_LOGGER.info("[execMmlCmd] start to send mml cmd to peer.")
            flag, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
            if not flag:
                PY_LOGGER.error("[execMmlCmd] change to debug mode failed.")
                return False, cliRet, errMsg
            else:
                #组装多条命令
                mmlCmdMany = "\\n".join(mmlCmdList)
                    
                #发送MML命令到对端
                peerFlag, peerCliRet = _sendMmlCmd2Peer(cli, mmlCmdMany, py_java_env)
                if not isIgnorePeer and not peerFlag:
                    flag = False
                    PY_LOGGER.error("[execMmlCmd] send mml cmd to peer failed.")
                    if "zh" == lang:
                        errMsg = u"\n发送命令" + str(", ".join(mmlCmdList)) + u"到对端失败。"
                    else: 
                        errMsg = u"\nFailed to send the \'" + str(", ".join(mmlCmdList)) + u"\' command to the peer."   
                    return False, peerCliRet, errMsg
     
        return True, localCliRet, peerCliRet
    
    except:
        PY_LOGGER.error("[execMmlCmd] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, errMsg
    finally:
        change2AimMode(cli, py_java_env, curMode)
        
        
def execMmlCmd(cli, mmlCmd, py_java_env, PY_LOGGER, isDouble=True, isIgnorePeer=False):
    """
    # *****************************************************************************************#
    # 函数名称: execMmlCmd(cli, mmlCmd, py_java_env, PY_LOGGER, isDouble = True)
    # 功能说明: 发送MML命令并获取回显信息
    # 输入参数: cli, mmlCmd, py_java_env, PY_LOGGER, isDouble = True
    # 返 回 值: 失败：False, cliRet, errMsg
    #           成功：True，localCliret, peerCliRet
    # *****************************************************************************************#
    """
    flag = True
    cliRet = ""
    errMsg = ""
    localCliRet = ""
    peerCliRet = ""
    
    curMode = getCurrentMode(cli)
    
    lang = py_java_env.get("lang")
    try:
        #若是双控，且需要发送到对端执行
        if isDouble:
            PY_LOGGER.info("[execMmlCmd] start to send mml cmd to peer.")
            flag, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
            if not flag:
                PY_LOGGER.error("[execMmlCmd] change to debug mode failed.")
                return False, cliRet, errMsg
            else:
                #发送MML命令到对端
                peerFlag, peerCliRet = _sendMmlCmd2Peer(cli, mmlCmd, py_java_env)
                if not isIgnorePeer and not peerFlag:
                    flag = False
                    PY_LOGGER.error("[execMmlCmd] send mml cmd to peer failed.")
                    if "zh" == lang:
                        errMsg = u"\n发送命令" + str(mmlCmd) + u"到对端失败。"
                    else: 
                        errMsg = u"\nFailed to send the \'" + str(mmlCmd) + u"\' command to the peer."   
                    return False, peerCliRet, errMsg
        
        #本端进入MML模式，发送MML命令
        PY_LOGGER.info("[execMmlCmd] start to send mml cmd to local.")
        flag, cliRet, errMsg = changeAnyMode2Mml(cli, py_java_env)
        if not flag:
            PY_LOGGER.error("[execMmlCmd] change to mml mode failed.")
            return False, cliRet, errMsg
        
        localCliRet = cliMgt.execCmd(cli, mmlCmd)
        return True, localCliRet, peerCliRet
    
    except:
        PY_LOGGER.error("[execMmlCmd] catch except of trace back:" + str(traceback.format_exc()))
        return False, cliRet, errMsg
    finally:
        change2AimMode(cli, py_java_env, curMode)


# *******************************界面显示函数定义，保持界面显示风格一致************************#

def getParseExceptionMsg(lang):
    """
    # *****************************************************************************************#
    # 函数名称: getParseExceptionMsg(lang)
    # 功能说明: CLI命令解析异常时提示
    # 输入参数: lang
    # 返 回 值: errMsg
    # *****************************************************************************************#
    """
    if "zh" == lang:
        errMsg = u"\nCLI回显解析异常。"
    else:
        errMsg = u"\nParse cli result abnomral."
    return errMsg
  
def getExceptionMsg(lang):
    """
    # *****************************************************************************************#
    # 函数名称: getExceptionMsg(lang)
    # 功能说明: 巡检异常时调用此接口统一显示界面风格
    # 输入参数: lang
    # 返 回 值: errMsg
    # *****************************************************************************************#
    """
    if "zh" == lang:
        errMsg = u"\n查询结果异常。"
    else:
        errMsg = u"\nQuery result is abnormal."
    return errMsg

def getSysModeFailedMsg(lang):
    """
    # *****************************************************************************************#
    # 函数名称: getSysModeFailedMsg(lang)
    # 功能说明: 巡检异常时调用此接口统一显示界面风格
    # 输入参数: lang
    # 返 回 值: errMsg
    # *****************************************************************************************#
    """
    if "zh" == lang:
        errMsg = u"\n系统状态异常。"
    else:
        errMsg = u"\nThe system is abnormal."
    return errMsg

def getSysTimeFailedMsg(lang):
    """
    # *****************************************************************************************#
    # 函数名称: getSysTimeFailedMsg(lang)
    # 功能说明: 获取系统时间失败
    # 输入参数: lang
    # 返 回 值: errMsg
    # *****************************************************************************************#
    """
    if "zh" == lang:
        errMsg = u"\n获取系统时间失败。"
    else:
        errMsg = u"\nFailed to get system time."
    return errMsg

def getFileFaildMsg(lang, isLocal, fileDir=None):
    """
    # *****************************************************************************************#
    # 函数名称: getFileFaildMsg(lang, isLocal, fileDir = None)
    # 功能说明: 获取文件失败时打印
    # 输入参数: lang, fileDir = None
    # 返 回 值: errMsg
    # *****************************************************************************************#
    """
    if fileDir:
        if "zh" == lang:
            errMsg = u"\n获取" + (u"本端" if isLocal else u"对端") + u"文件（" + str(fileDir) + u"）失败。"
        else:
            errMsg = u"\nFailed to obtain " + u"local" if isLocal else u"peer" + u" file(" + str(fileDir) + u")."
    else:
        if "zh" == lang:
            errMsg = u"\n获取" + (u"本端" if isLocal else u"对端") + u"文件失败。"
        else:
            errMsg = u"\nFailed to obtain " + u"local" if isLocal else u"peer" + u" file."
    return errMsg


def decompressTar(filePath, depressPath):
    decompress_tar_all_file(filePath, depressPath, "r:tar")


def heartToPeerCtrl(cli, py_java_env, PY_LOGGER, timeOut=0):
    """
    # *****************************************************************************************#
    # 函数名称: heartToPeerCtrl(cli, py_java_env,PY_LOGGER)
    # 功能说明: 心跳到对端控制器（进入前需要保证为双控正常）
    # 输入参数: cli, py_java_env, PY_LOGGER
    # 返 回 值: flag, cliRet,errMsg
    # *****************************************************************************************#
    """
    flag = False
    cliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    sshPort = str(py_java_env.get("devInfo").getPort())
    
    try:
        flagItem, cliRet, errMsg = changeAnyMode2Debug(cli, py_java_env)
        if not flagItem:
            PY_LOGGER.error("[heartToPeerCtrl] change to debug mode failed.")
            return False, cliRet, errMsg
        #获取心跳IP地址
        heartBeat = _getHeartbeatIp(cli, py_java_env)
        if not heartBeat:
            PY_LOGGER.error("[heartToPeerCtrl] Getting heart beat ip address invalid(" + str(heartBeat) + ").")
            if "zh" == lang:
               errMsg = u"\n获取心跳IP地址无效。" 
            else:
               errMsg = u"\nThe obtained heart beat IP address is invalid."  
            return False, cliRet, errMsg
        
        if timeOut:
            itemCliRet = cliMgt.execCmdWithTimout(cli, "ssh admin@" + heartBeat + " -p " + sshPort, timeOut)
        else:
            itemCliRet = cliMgt.execCmd(cli, "ssh admin@" + heartBeat + " -p " + sshPort)
        
        cliRet += itemCliRet
        
        if re.search("Are you sure you want to continue connecting (yes/no)?", itemCliRet, re.IGNORECASE):
            if timeOut:
                itemCliRet = cliMgt.execCmdWithTimout(cli, "yes", timeOut)
            else:
                itemCliRet = cliMgt.execCmd(cli, "yes")
            cliRet += itemCliRet
        if re.search("Password:", itemCliRet, re.IGNORECASE):
            if timeOut:
                itemCliRet = cliMgt.execCmdNoLogTimout(cli, str(py_java_env.get("devInfo").getLoginUser().getPassword()), timeOut)
            else:
                itemCliRet = cliMgt.execCmdNoLog(cli, str(py_java_env.get("devInfo").getLoginUser().getPassword()))
            
            cliRet += itemCliRet
         
            if not re.search("Password:", itemCliRet, re.IGNORECASE) and (not re.search("Too many authentication failures", itemCliRet, re.IGNORECASE))\
                and (not re.search("logining", itemCliRet, re.IGNORECASE)) and itemCliRet.strip().endswith(">"):
                flag = True
                return flag, cliRet, errMsg
            else:
                flag = False
                
        if not flag:
            if "zh" == lang:
                errMsg = u"\n心跳到对端失败。"
            else: 
                errMsg = u"\nFailed to heart to the peer."  
        return flag, cliRet, errMsg
    except:
        PY_LOGGER.error("[heartToPeerCtrl] catch except of trace back:" + str(traceback.format_exc()))
        if "zh" == lang:
                errMsg = u"\n心跳到对端失败。"
        else: 
            errMsg = u"\nFailed to heart to the peer."  
        return False, cliRet, errMsg

def initSftp(sftp):
    """
    # *****************************************************************************************#
    # 函数名称: initSftp(sftp):
    # 功能说明: 初始化sftp连接，
    # 输入参数: sftp
    # 返 回 值: 
    # *****************************************************************************************#
    """
    
    try:
        if not sftp.listFiles('/OSM/log/cur_debug'):
            sftp.reConnect()
    except:
        sftp.reConnect()
        
def getVerticalCliRet(cliRet, splitChar):
    '''
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
    @param cliRet: cli回显
        splitChar: 指定的分隔符
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    cliRetList = cliRet.encode("utf8").splitlines()
    dictList = []
    lineDict = {}
    for line in cliRetList:
        if CLI_RET_END_FLAG in line:
            break
        
        if re.search("^-+\r*\n*$", line):
            dictList.append(lineDict.copy())
            lineDict.clear()
            
        fields = line.split(splitChar)
        if len(fields) < 2:
            continue
        
        key = fields[0].strip().decode("utf8")
        value = ":".join(fields[1:len(fields)]).strip().decode("utf8")
        
        if lineDict.has_key(key):
            key += "_" + str(str(lineDict.keys()).count(key + "_") + 1)
        lineDict.setdefault(key, value)
    
    if len(lineDict) > 0:
        dictList.append(lineDict.copy())
    
    return dictList

def getLocalCtrlID(cli,py_java_env):
    """
    # *****************************************************************************************#
    # 函数名称: chkLocalCtrlID(cli,py_java_env)
    # 功能说明: 根据回显结果返回本端归属ID信息
    # 输入参数: cli 
    # 输入参数: py_java_env
    # 返 回 值: True, cliRet, localCtrlID, errMsg  
    # *****************************************************************************************#
    """
    
    localCtrlID = ""
    #获取控制器的信息，识别当前控制器是A还是B
    cliRet = cliMgt.execCmd(cli,"showctrlip")
    lang = py_java_env.get("lang")
    #判断CLI命令执行结果是否有效，有效才进行后续的逻辑判断
    preRet, errMsg = preCheckCliRet('showctrlip', cliRet, lang)
    if RET_OK != preRet:
        return False, cliRet, localCtrlID, errMsg
    devNode = py_java_env.get("devInfo")
    currentIP = devNode.getIp()
    retList = cliRet.splitlines()

    for line in retList:
        if re.search(currentIP,line,re.IGNORECASE):
            localCtrlID = line.split()[0]
            break
    return True, cliRet, localCtrlID, errMsg

def getHorizontalNostandardCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    @注：该方法用于解析老产品（V100R005C00及之后版本）业务资源检查回显公共方法
    '''
    try:
        Dict = {}
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_line = re.compile("[a-zA-Z\s]+[:=][\s]*[\d]+") 
            findall_lineList = reg_line.findall(line)
            split_Mark_Colon =":"
            split_Mark_Equal ="="
            for item in findall_lineList:
                key = ""
                val = ""
                if split_Mark_Colon in item:
                    list = item.split(split_Mark_Colon)
                    key = list[0].strip()
                    val = list[1].strip()
                    Dict.setdefault(key,val)
                if split_Mark_Equal in item:
                    list = item.split(split_Mark_Equal)
                    key = list[0].strip()
                    val = list[1].strip()
                    Dict.setdefault(key,val)
        return Dict
    except:
        return {}    
    