# -*- coding: UTF-8 -*-
import re
import os
import shutil
import traceback
from common.utils import *

#########################################
#      巡检前置脚本
# 巡检前检查设备是否正常，目前登录的用户模式
#########################################

# **************************************************************************** #
# 函数名称: isChinese
# 功能说明: 判断当前语言是否为中文
# 输入参数: 无
# 输出参数: True or False
# **************************************************************************** # 
def isChinese():
    lang = py_java_env.get("lang")
    if "zh" == lang:
        return True
    return False

def init(devObj):
    """
    # *****************************************************************************************#
    # 函数名称: init(devObj, py_java_env)
    # 功能说明: 供preinspect.py脚本调用，清理及初始化全局变量保存于py_java_env中
    # 输入参数: devObj, py_java_env
    # 输出参数: isInvalid, errMsg
    # *****************************************************************************************#
    """
    flag = True
    
    cli = devObj.get("ssh") 
    
    #删除本地temp目录下面的临时文件
    PY_LOGGER.info("Inspect[preinspect] Delete tmp dir!")
    #清除误码时兼容命令fc clear err，2014/09/12 modified Begin
    clearErrorCmds = ["fc c e","fc clear err"]
    for cmd in clearErrorCmds:
        #误码清除，防止在巡检项中需要长时间等待
        iRet = execMmlCmd(cli, cmd, py_java_env, PY_LOGGER, True)
        if iRet[0] and "-1-port not exist" in iRet[1] and "-1-port not exist" in iRet[2]:
            py_java_env.put("clearCode", "errCode")
            break
    #清除误码时兼容命令fc clear err，2014/09/12 modified End
    #保存本次工具运行的时间
    py_java_env.put("startTime", getCurTime())
    
    #创建本地临时存放文件
    localTmpPath = getLocaTmplFilePath(py_java_env)
    if os.path.exists(localTmpPath):
        if not shutil.rmtree(localTmpPath, ignore_errors=True):
            PY_LOGGER.error("Inspect[preinspect] Remove temp file " + str(localTmpPath) + "failed!")
            return False
        PY_LOGGER.info("Inspect[preinspect] Remove temp file " + str(localTmpPath) + "success!")
    
    return flag


#设置异常返回的提示信息，涉及到中英文

res_desc_zh = {'success': ur'系统检查通过',
               'except':  ur'系统检查异常',
               'initFailed':  ur'工具初始化失败'
               }
                
res_desc_en = {'success': r'System check done',
               'except':  r'System check except',
               'initFailed':  r'Failed to initate tool'
               }
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

def execute(devObj):
    """
    # **************************************************************************** #
    # 函数名称: execute
    # 功能说明: 执行巡检脚本之前判断，判断系统是否处于正常状态
    # 输入参数: cliRet
    # 输出参数: True or False
    # **************************************************************************** # 
    """
    try:
        lang = ""
        if isChinese():
            lang = "zh"
        else:
            lang = "en"
            
        cli = devObj.get("ssh")
            
        cliRet = cliMgt.execCmd(cli, "showsys")   
        preRet, errMsg = preCheckCliRet("showsys", cliRet, lang)
        if RET_FAIL == preRet:
            raise Exception("Maybe System is upgrading or abnormal.")
            
        if init(devObj):
             return ('', dict(flag=True, des=res_desc[lang]['success']))
        else:
             return ('', dict(flag=False, des=res_desc[lang]['initFailed']))
                 
    except Exception, exception:
        PY_LOGGER.error("Inspect[preinspect] catch except of trace back:" + str(traceback.format_exc()))
        return ('', dict(flag=False, des=res_desc[lang]['except']))
