# -*- coding: UTF-8 -*-

import re

# **************************************************************************** #
# 函数名称: switchValidVersion
# 功能说明: 将版本号转化成有效的版本号（17位：V100R002C00SPC001 或者11位：V100R005C02）
# 输入参数: version
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def switchValidVersion(version):
    temp = ""
    
    startIndex = version.index("V100")
    if re.search("SPC", version, re.IGNORECASE):
        endIndex = startIndex + 17  #格式：V100R002C00SPC001
    else:
        endIndex = startIndex + 11  #格式：V100R005C02
    
    #提取有效的版本号信息
    temp = version[startIndex: endIndex]
    
    return temp

# *************************************************************#
# 函数名称: execute
# 功能说明: 查询工具是否支持此版本
# 其 他   :  无
# *************************************************************#
def execute(dataDict):

    dev = dataDict.get("dev")
    deviceType = dev.getDeviceType()
    systemVersion = dev.getProductVersion()
    
    #规范系统SPC版本号
    systemVersion = switchValidVersion(systemVersion)
    #获取SPC版本号字段
    spcVersion = systemVersion[-6:]
    
    #所有V1R5C02全满足要求
    if systemVersion.startswith("V100R005C02"):
        return True
    #所有V1R5C30全满足要求
    elif systemVersion.startswith("V100R005C30"):
        return True
    #所有V100R002版本全支持
    elif systemVersion.startswith("V100R002"):
        return True
    #版本号长度不足，返回错误
    elif len(systemVersion) != 17:
        return False
    #所有V1R1全不支持
    elif systemVersion.startswith("V100R001"):
        return False
    #V1R5 SP700及后续版本支持
    elif systemVersion.startswith("V100R005"):
		return True
    else:
        return False
