# -*- coding: UTF-8 -*-

import traceback
import re
from comm import modelManager
from comm.cTV1R1 import parseVertical
import common
# **************************************************************************** #
# 函数名称: execute
# 功能说明: BBU电量检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    bbuId = ""
    bbuPower = ""
    controllerId = ""
    errMsg = ""
    logger = PY_LOGGER
    
    cliRet = cli.execCmd("showbbu")
    list = cliRet.splitlines()
        #判断cli信息是否有效
    if not common.checkCliInfoValid(cliRet, True):
        flag = False
        if lang == "zh":
            errMsg = u"\n获取BBU信息无效。"
        else:
            errMsg = "\nGet BBU information invalid."
        return (flag, cliRet, errMsg)  
    
    listDict = parseVertical(cliRet).getResult() 
    for dictInfo in listDict:
        controllerId = dictInfo.get("Controller Id")
        bbuId = dictInfo.get("Bbu Id")
        bbuPower = dictInfo.get("Bbu Power")
        logger.info("bbuPower:"+unicode(bbuPower))
        if bbuPower != "Sufficient":
            flag = False
            if "zh" == lang:
                errMsg += u"\nBBU（" + ((u"Controller ID：" + unicode(controllerId) + u"，") if controllerId else "" )+ u"BBU ID：" + unicode(bbuId) + u"）的电量不足。"
            else:
                errMsg += "\nBBU("+(("Controller ID: " + unicode(controllerId) +", ") if controllerId else "" )+"BBU ID: " + unicode(bbuId)+ ") power is insufficient."
                    
    return (flag, cliRet, errMsg)