# -*- coding: UTF-8 -*-
import traceback
import re
from comm import modelManager
from comm.cTV1R1 import parseVertical
import common
import hardware

NO_CHECK = "NOCHECK"

def execute(cli):
    """
    Create date        : 2015/03/24
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    errMsg = ""
    bbuId = ""
    cliRet = ""
    lang = py_java_env.get("lang")
    logger = PY_LOGGER
        
    if not modelManager.changeCli2Developer(cli, py_java_env):
        if lang == "zh":
            errMsg += (u"\n进入developer模式失败，失败的原因可能为：" 
                       + u"\n（1）添加设备时未输入调试密码。"
                       + u"\n（2）添加设备时输入的调试密码无效。")
        else:
            errMsg += ("\nFailed to log in to the developer mode, the causes may be:" 
                       + "\n(1) You did not enter a debugging password when adding the device."
                       + "\n(2) The debug password entered is incorrect.")
        return (False, cliRet, errMsg)
    else:
        logger.info('Switch to developer mode successfully.')
        bbulifeCliRet = cli.execCmd("showbbulife")
        cliRet += bbulifeCliRet
        modelManager.changeAnyModel2Cli(cli)
        #判断cli信息是否有效
        if not common.checkCliInfoValid(bbulifeCliRet,False):
            flag = False
            if lang == "zh":
                errMsg = u"\n获取BBU信息无效。"
            else:
                errMsg = "\nGet BBU information invalid."
            return (flag, cliRet, errMsg)
        
        if re.search("Command.*not exist|no right", bbulifeCliRet, re.IGNORECASE):
            if lang == "zh":
                errMsg = (u"\nshowbbulife命令执行失败，原因可能为：" 
                       + u"\n（1）当前登录用户不为超级管理员。"
                       + u"\n（2）当前版本不支持此命令。")
            else:
                errMsg = ("\nThe showbbulife command failed to be executed, the reason may be:" 
                           + "\n(1) The currently logged in user is not super administrator."
                           + "\n(2) The currently version does not support this command.")
            return (NO_CHECK, cliRet, errMsg)
        
        listDict = parseVertical(cliRet).getResult() 
		#获取首个不为空的BOM编码值
        standardBomCode = hardware.getItemFromELabel("BBU", bbulifeCliRet, "No") 
        for dictInfo in listDict:
            controllerId = dictInfo.get("Controller Id")
            bbuId = dictInfo.get("Bbu Id")
            remainLife = unicode(dictInfo.get("Remain Life(Days)"))
            logger.info("RemainLife:" + unicode(remainLife))
            #如果remainLife只包含数字并且值小于90
            if remainLife.isdigit() and int(remainLife) < 90:
                flag = False
                if "zh" == lang:
                    errMsg += u"\nBBU（" + ((u"Controller ID：" + unicode(controllerId) + u"，") if controllerId else "") + u"BBU ID：" + unicode(bbuId) + u"）剩余寿命不足90天，请尽快更换BBU。"
                    if standardBomCode:
                        errMsg += u"\n硬件（Controller ID：" + unicode(controllerId) + u"，BBU ID：" + unicode(bbuId)\
                              + u"）的BOM编码（" + standardBomCode + u"）。" 
                    else:
                        errMsg += u"\n无法获取硬件（Controller ID" + unicode(controllerId) + u"，BBU ID：" + unicode(bbuId)\
                              + u"）的BOM编码。" 
                else:
                    errMsg += "\nThe remaining service life of BBU(" + (("Controller ID: " + unicode(controllerId) + ", ") if controllerId else "") + "BBU ID: " + unicode(bbuId) + ") is shorter than 90 days, replace the BBU as soon as possible."
                    if standardBomCode:
                        errMsg += u"\nBOM number of hardware(Controller ID:" + unicode(controllerId) + u", BBU ID: " + unicode(bbuId)\
                              + u"):" + standardBomCode + u"."
                    else:
                        errMsg += u"\nCannot obtain the BOM number of the hardware(Controller ID:" + unicode(controllerId)  + u", BBU ID: " +  unicode(bbuId)\
                                          + u")." 

        return (flag, cliRet, errMsg)                 
