# -*- coding: UTF-8 -*-

from comm.cTV1R1 import parseVertical
import common
import hardware
# **************************************************************************** #
# 函数名称: execute
# 功能说明: BBU状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    bbuId = ""
    bbuStatus = ""
    controllerId = ""
    errMsg = ""
    logger = PY_LOGGER 
    cliRet = cli.execCmd("showbbu")
    list = cliRet.splitlines()
    #判断cli信息是否有效
    if not common.checkCliInfoValid(cliRet, True):
        flag = False
        if lang == "zh":
            errMsg = u"\n获取BBU信息无效。"
        else:
            errMsg = "\nGet BBU information invalid."
        return (flag, cliRet, errMsg) 
    #获取首个不为空的BOM编码值
    standardBomCode = hardware.getItemFromELabel("BBU", cliRet, "No")
    listDict = parseVertical(cliRet).getResult() 
    for dictInfo in listDict:
        controllerId = dictInfo.get("Controller Id")
        bbuId = dictInfo.get("Bbu Id")
        bbuStatus = dictInfo.get("Status")
        logger.info("BBUStatus is:"+unicode(bbuStatus))
        if bbuStatus != "Normal":
            flag = False
            if "zh" == lang:
                errMsg += u"\nBBU（" + ((u"Controller ID：" + unicode(controllerId) + u"，") if controllerId else "") + u"BBU ID：" + unicode(bbuId) + u"）的状态存在异常（" + bbuStatus + u"）。"
                if standardBomCode:
                    errMsg += u"\n硬件（Controller ID：" + unicode(controllerId) + u"，BBU ID：" + unicode(bbuId)\
                          + u"）的BOM编码（" + standardBomCode + u"）。" 
                else:
                    errMsg += u"\n无法获取硬件（Controller ID" + unicode(controllerId) + u"，BBU ID：" + unicode(bbuId)\
                          + u"）的BOM编码。" 
                    
            else:
                errMsg += "\nBBU(" + (("Controller ID: " + unicode(controllerId) + ", ") if controllerId else "") + "BBU ID: " + unicode(bbuId) + ") is abnormal(" + bbuStatus + ")."
                if standardBomCode:
                    errMsg += u"\nBOM number of hardware(Controller ID:" + unicode(controllerId) + u", BBU ID: " + unicode(bbuId)\
                          + u"):" + standardBomCode + u"."
                else:
                    errMsg += u"\nCannot obtain the BOM number of the hardware(Controller ID:" + unicode(controllerId)  + u", BBU ID: " +  unicode(bbuId)\
                                      + u")." 

    return (flag, cliRet, errMsg)
