# -*- coding: UTF-8 -*-
import common
import traceback
import re

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 检查系统中是否存在BST（硬盘坏块标记）
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    @summary: 检查系统中是否存在BST（硬盘坏块标记）
    """
    cliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    
    try:
        
        cliRet = cli.execCmd("showdiskbst")
        if not common.checkCliInfoValid(cliRet, False):
            errMsg = common.getMsg(lang, "latencylunio.command.faile", {"zh":u"硬盘坏块标记", "en":"hard disk bad sector tag"}.get(lang))
            return (common.RESULT_NOCHECK, cliRet, errMsg)  

        if re.search("command operates successfully", cliRet, re.IGNORECASE) and re.search("no information", cliRet, re.IGNORECASE):
            return (True, cliRet, "")

        errMsg += common.getMsg(lang, "device.exit.bst")
        return (False, cliRet, errMsg)

    except Exception:
        errMsg = common.getMsg(lang, "query.result.abnormal") 
        PY_LOGGER.error("Inspect[DiskFWVersion] catch except of trace back:" + str(traceback.format_exc()))
        return (common.RESULT_NOCHECK, cliRet, errMsg)