# -*- coding: UTF-8 -*-
import re
import common
import traceback
from time import sleep
from comm.cTV1R1 import parseVertical
from comm.cTV1R1 import ParseException
from common import getParseExceptErrMsg

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 误码检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    lang = py_java_env.get("lang")
    logger = PY_LOGGER
    PY_JAVA_ENV = py_java_env
    iSCSI_cliRet_list = []
    FC_cliRet_list = []
    SAS_cliRet_list = []
    
    #首次查询误码
    iSCSI_cliRet_list.append(cli.execCmd("showiscsiber"))
    FC_cliRet_list.append(cli.execCmd("showfcber"))
    SAS_cliRet_list.append(cli.execCmd("showsasber"))
    
    common.refreshProcess(PY_JAVA_ENV, 2, logger)
    
    singleStep = 80 / 20
    currentProcess = 5
    for i in range(20):
        sleep(3)
        currentProcess +=singleStep
        common.refreshProcess(PY_JAVA_ENV, currentProcess, logger)    

    #等待60秒后重新查询误码
    iSCSI_cliRet_list.append(cli.execCmd("showiscsiber"))
    FC_cliRet_list.append(cli.execCmd("showfcber"))
    SAS_cliRet_list.append(cli.execCmd("showsasber"))
    
    common.refreshProcess(PY_JAVA_ENV, 90, logger)
    
    #拼接回文信息,按iSCSI,FC,SAS排序
    cliRet = "\n".join(iSCSI_cliRet_list + FC_cliRet_list + SAS_cliRet_list)
    
    common.refreshProcess(PY_JAVA_ENV, 92, logger)
    try:
        #检查三种接口卡是否存在误码
        iSCSICheckFlag, iSCSICheckErrorMsgList = checkBitErrors(iSCSI_cliRet_list, "iSCSI", lang)
        FCCheckFlag, FCCheckErrorMsgList = checkBitErrors(FC_cliRet_list, "FC", lang)
        SASCheckFlag, SASCheckErrorMsgList = checkBitErrors(SAS_cliRet_list, "SAS", lang)            
    except ParseException, e:
        PY_LOGGER.error("[BitError]get trace back: " + unicode(traceback.format_exc()))
        return False, cliRet, getParseExceptErrMsg(lang)
    common.refreshProcess(PY_JAVA_ENV, 95, logger)
    #检查结果:当三种接口卡都不存在误码时才通过
    flag = iSCSICheckFlag and FCCheckFlag and SASCheckFlag
    #拼接详细错误信息
    errMsg = "\n" + "\n".join(iSCSICheckErrorMsgList + FCCheckErrorMsgList + SASCheckErrorMsgList)
    
    return flag, cliRet, errMsg
    common.refreshProcess(PY_JAVA_ENV, 100, logger)

# **************************************************************************** #
# 函数名称: checkBitErrors
# 功能说明: 检查是否存在误码,cliRetList长度要求为2
# 输入参数: cliRetList,type, lang
# 输出参数: 无
# 返 回 值: flag, errMsgList
# **************************************************************************** # 
def checkBitErrors(cliRetList, portType, lang):
    """iSCSI Port cli回显信息格式
    #======================================================
    #                 iSCSI Port Bit Error                 
    #------------------------------------------------------
    #  Control ID                   | A
    #  Interface Module ID          | 0
    #  Port ID                      | 0
    #  Link Status                  | Link Down
    #  Number of Error Packets      | 0
    #  Number of Lost Packets       | 0
    #  Number of Overflowed Packets | 0
    #  Start Time                   | 2011-04-03 03:25:01
    #------------------------------------------------------
    """
    
    """FC Port cli回显信息格式
    ===============================================
                   FC Port Bit Error
    -----------------------------------------------
      Control ID            | A
      Interface Module ID   | 0
      Port ID               | P0
      Link Status           | Link Up
      Lost Signals          | 0
      Link Errors Codes     | 0
      Lost Synchronizations | 0
      Failed Connections    | 0
      Start Time            | 2012-12-12 18:11:48
    -----------------------------------------------
    """
    
    """SAS Port cli回显信息格式
    #========================================================
    #                   SAS Port Bit Error                   
    #--------------------------------------------------------
    #  Control ID                     | A
    #  Interface Module ID            | 0
    #  Port ID                        | 0
    #  Link Status                    | Link Up
    #  Number of Invalid DWORD Errors | 0
    #  Number of Consist Errors       | 0
    #  Number of Loss of DWORD Errors | 0
    #  Number of PHY Reset Errors     | 0
    #  Start Time                     | 2011-04-05 15:32:49
    #--------------------------------------------------------
    """
    
    flag = True
    errMsgList = [] 
    
    #判断cli信息是否有效
    if (not common.checkCliInfoValid(cliRetList[0], False)
        or not common.checkCliInfoValid(cliRetList[-1], False)):
        flag = False
        if lang == "zh":
            errMsg = u"%s端口误码信息无效。" % portType
        else:
            errMsg = "Invalid %s port bit errors information." % portType
        errMsgList.append(errMsg)
        return flag, errMsgList
        
    #第一次执行命令的回显解析结果
    bitErrorsDictList_first = parseVertical(cliRetList[0]).getResult() 
    bitErrorsDictList_lastly = parseVertical(cliRetList[-1]).getResult() 
    
    portBitErrorsDict_first = {} 
    portBitErrorsDict_lastly = {}
    
    for bitErrors_first in bitErrorsDictList_first:
        ctrlID_first = bitErrors_first.get("Control Id", "")
        moduleID_first = bitErrors_first.get("Interface Module Id", "")
        portID_first = bitErrors_first.get("Port Id", "")
        numOfError_first = ""
        if portType == "iSCSI":
            numOfError_first = bitErrors_first.get("Number Of Error Packets", "")
        elif portType == "FC":
            numOfError_first = bitErrors_first.get("Link Errors Codes", "")
        elif portType == "SAS":
            numOfError_first = bitErrors_first.get("Number Of Consist Errors", "")
        else:
            pass
        portBitErrorsDict_first[(ctrlID_first, moduleID_first, portID_first)] = numOfError_first
    
    for bitErrors_lastly in bitErrorsDictList_lastly:
        ctrlID_lastly = bitErrors_lastly.get("Control Id", "")
        moduleID_lastly = bitErrors_lastly.get("Interface Module Id", "")
        portID_lastly = bitErrors_lastly.get("Port Id", "")
        numOfError_lastly = ""
        if portType == "iSCSI":
            numOfError_lastly = bitErrors_lastly.get("Number Of Error Packets", "")
        elif portType == "FC":
            numOfError_lastly = bitErrors_lastly.get("Link Errors Codes", "")
        elif portType == "SAS":
            numOfError_lastly = bitErrors_lastly.get("Number Of Consist Errors", "")
        else:
            pass
        portBitErrorsDict_lastly[(ctrlID_lastly , moduleID_lastly, portID_lastly)] = numOfError_lastly
    
    if portBitErrorsDict_first.keys() != portBitErrorsDict_lastly.keys():
        if "zh" == lang:
            errMsg = u"两次获取的%s端口不一致。" % portType
        else:
            errMsg = "%s ports obtained at both times are different."% portType
        errMsgList.append(errMsg) 
        return False, errMsgList
        
    for key in portBitErrorsDict_first:
        if portBitErrorsDict_first.get(key) != portBitErrorsDict_lastly.get(key):
            flag = False
            if "zh" == lang:
                errMsg = u"%s端口（Control ID：%s，Interface Module ID：%s，Port ID：%s）存在误码。" % (portType, key[0], key[1], key[2])
            else:
                errMsg = "Error packets are generated at the system %s port (Control ID: %s, Interface Module ID: %s, Port ID: %s)." % (portType, key[0], key[1], key[2])
            errMsgList.append(errMsg) 
                
    
    return flag, errMsgList
