# -*- coding: UTF-8 -*-
import os
from common import getCurSystemVersion
from common import getCurHotPatchVersion

# **************************************************************************** #
# 函数名称: execute
# 功能说明: CLI无法登录
# 输入参数: ssh连接
# **************************************************************************** # 
def execute(cli):
    flag = True
    errMsg = ""
    lang = py_java_env.get("lang")
    
    cliLoginPatch = {
                    'V100R002C00SPC011':'V100R002C00SPHb04',
                    'V100R002C00SPC012':'V100R002C00SPHc04',
                    'V100R002C00SPC013':'V100R002C00SPHd01',
                    'V100R002C00SPC015':'V100R002C00SPHf01',
                    'V100R002C00SPCg00':'V100R002C00SPHg01',
                    
                    'V100R002C01SPC011':'V100R002C01SPHb04',
                    'V100R002C01SPC012':'V100R002C01SPHc04',
                    'V100R002C01SPC013':'V100R002C01SPHd01',
                    'V100R002C01SPC015':'V100R002C01SPHf01',
                    'V100R002C01SPCg00':'V100R002C01SPHg01',
                    
                    'V100R005C00SPC003':'V100R005C00SPH301',
                    'V100R005C00SPC500':'V100R005C00SPH501',
                   }
    
    flag, sysSpcVersion, cliRet, errMsg = getCurSystemVersion(cli, lang)
    if not flag:
        return (flag, cliRet, errMsg)
    
    if ('V100R002C00SPC006' <= sysSpcVersion <= 'V100R002C00SPC010'
        or 'V100R002C01SPC002' <= sysSpcVersion <= 'V100R002C01SPC007'
        or sysSpcVersion in ['V100R002C00SPC014', 'V100R005C00SPC400', 'V100R005C01SPC100']
        or sysSpcVersion in cliLoginPatch):
        #部分版本支持补丁修复，检查是否安装有特定补丁
        if sysSpcVersion in cliLoginPatch:
            patchFlag, curPatchVersion, hotPatchVerInfo, patchErrMsg = getCurHotPatchVersion(cli, lang)
            cliRet += '\n' + hotPatchVerInfo
            #获取热补丁版本失败
            if not patchFlag:
                return (False, cliRet, patchErrMsg)
            
            if curPatchVersion[:11] == cliLoginPatch.get(sysSpcVersion)[:11] and curPatchVersion >= cliLoginPatch.get(sysSpcVersion):
                return (True, cliRet, errMsg)
        
        if lang == "zh":
            errMsg = u"\n系统长时间运行后，可能存在无法登录设备进行管理的风险。"
        else:
            errMsg = "\nAfter long-term system running, there are risks where users fail to log in to the device."
        return ('WARNING', cliRet, errMsg)
    else:
        return (True, cliRet, errMsg)
