# -*- coding: UTF-8 -*-

from time import sleep
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: CPU利用率检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    logger = PY_LOGGER
    PY_JAVA_ENV = py_java_env
    errMsg = "" 
    allcliRet = ''

    ctrlAcpuUtilityList = []
    ctrlBcpuUtilityList = []
    controllerUsageDict = {"A":[], "B":[]}
    common.refreshProcess(PY_JAVA_ENV, 2, logger)
    
    currentProcess = 5
    singleStep = 15
    
    try:
        for times in range(5):
            currentProcess += singleStep
            common.refreshProcess(PY_JAVA_ENV, currentProcess, logger)
            #初始化CPU利用率信息
            CPUUtility = 0
            cliRet = cli.execCmd("showcontroller")
            allcliRet += '\n' + cliRet
            list = cliRet.splitlines()
            if len(list) < 7:
                if "zh" == lang:
                    errMsg = u"\n未取到有效的控制器信息。"
                else:
                    errMsg = "\nFailed to get valid controller information."
                return (False, cliRet, errMsg)
            
            controllerID = ""
            for field in list:
                field = field.replace(" ", "").replace("|", "")
                if field.startswith("ControllerID"):
                    controllerID = field.replace("ControllerID", "")
                elif field.startswith("CPUUtility(%)"):                
                    CPUUtility = int(field.replace("CPUUtility(%)", "")) 
                    #指定控制器CPU利用率信息取得
                    if 'A' == controllerID:
                        ctrlAcpuUtilityList.append(CPUUtility)
                    elif 'B' == controllerID:
                        ctrlBcpuUtilityList.append(CPUUtility)
                    else:
                        break
                    
            #每5秒获取一次利用率信息    
            sleep(5)
        
        #将各控制器信息写入对应的列表       
        controllerUsageDict["A"] = ctrlAcpuUtilityList 
        controllerUsageDict["B"] = ctrlBcpuUtilityList 
        failFlag = False
        warnFlag = False
        for controllerID in controllerUsageDict:
            cpuUtilityList = controllerUsageDict[controllerID]
            checkRet, errInfo = checkCpuUsage(controllerID, cpuUtilityList, lang)
            errMsg += errInfo
            if checkRet == "False":
                failFlag = True
            elif checkRet == "WARNING":
                warnFlag = True
        
        #给出检查结果
        if failFlag:
            flag = False
        elif warnFlag:
            flag = "WARNING"
              
        return (flag, allcliRet, errMsg)
    #命令执行失败，检查结果为不通过
    except Exception, exception:
        return (False, allcliRet, "")
    finally:
        common.refreshProcess(PY_JAVA_ENV, 100, logger)


def checkCpuUsage(controllerID, cpuUtilityList, lang):
    """
    @summary: 检查利用率是否超过标准
    """
    errMsg = ""
    flag = ""
    countGe80 = 0
    countGe90 = 0
    
    #计数超过80%和90%的利用率个数
    for value in cpuUtilityList:
        if value > 80:
            countGe80 += 1
        if value > 90:
            countGe90 += 1
      
    #利用率大于90%的大于等于3个时，不通过      
    if countGe90 >= 3:
        cpuUsage = u"90%"
        flag = "False"
             
    #否则利用率大于80%的大于等于3个时，建议优化
    elif countGe80 >=3:
        cpuUsage = u"80%"
        flag = "WARNING"
    
    #存在不通过或建议优化情况
    if flag != "":
        if "zh" == lang:
            errMsg += u"\n控制器：%s的CPU使用率为%s" % (controllerID,cpuUtilityList)\
                    + u"，存在3次CPU利用率超过阈值%s，阵列处于工作繁忙状态。" % (cpuUsage)
        else:
            errMsg += "\nThe CPU Utility of controller: %s is %s. " %(controllerID,cpuUtilityList)\
                    + "The value exceeds the threshold %s for three times, " % (cpuUsage)\
                    + "and the storage array is overloaded." 

    return (flag, errMsg)
    
    