# -*- coding: UTF-8 -*-
import traceback
import re
from comm import modelManager
from comm.cTV1R1 import parseVertical
import common
SERVICE_RESOURCSE_SPEC = 60
SERVICE_RESOURCSE_INTERVAL = 10

def execute(cli):
    """
    Cache资源检查
    1 showcachepartition -pr 0回显中计算每个控制器写页面(write alloced/Write page quota -high water level)/1-high water level 每10秒执行一次，检查1分钟共7次，如果5次超过50%则巡检不通过；
    2 showcachepartition -pr 0回显中计算每个控制器刷盘并发请求数write disk req count/destage max req每10秒执行一次，检查1分钟共7次，如果5次超过90%则巡检不通过；
    3 showcachepartition -pr 0回显中计算每个控制器刷盘并发页面数write disk page /destage max page每10秒执行一次，检查1分钟共7次，如果5次超过90%则巡检不通过；
    4 showcachepartition -pr 0回显中计算每个控制器离散chunk数discrete dirty chunk /discrete dirty limit每10秒执行一次，检查1分钟共7次，如果5次超过90%则巡检不通过；
    """
    logger = PY_LOGGER
    contex = py_java_env
    try:
        flag = True
        errMsg = ""
        lang = py_java_env.get("lang")
        sysSpcVersion = ""
        cliRet = ""
        cliRetAll = ""
        #判断产品版本，V100R005C00SPC700版本之前则不涉及
        (flag, sysSpcVersion, cliRet, errMsg) = common.getCurSystemVersion(cli, lang)
        
        if not flag:
            return (flag, cliRet, errMsg)
        
        cliRetAll += cliRet
        if sysSpcVersion < "V100R005C00SPC700":
            return common.RESULT_NOSUPPORT ,cliRetAll ,errMsg
        #V100R005C00和V100R005C01属于同一个级别，V100R005C01SPC700版本之前为不涉及
        if "V100R005C01" in sysSpcVersion and sysSpcVersion < "V100R005C01SPC700":
            return common.RESULT_NOSUPPORT ,cliRetAll ,errMsg
        
        # 刷新进度条
        common.refreshProcess(contex, 3, logger) 
               
        #进入Developer模式
        flag = modelManager.changeCli2Developer(cli, contex)
        if not flag:
            flag = False
            errMsg = common.getMsg(lang, "enter.developer.fail")
            return (flag, cliRetAll, errMsg)
        
        # 刷新进度条
        common.refreshProcess(contex, 5, logger)
        
        flag, cliRet, errMsg= common.checkCacheResourse(cli,lang,SERVICE_RESOURCSE_SPEC,SERVICE_RESOURCSE_INTERVAL,logger, contex)
        
        cliRetAll += cliRet
        #退出Developer模式进入CLI模式
        modelManager.changeAnyModel2Cli(cli)
        
        common.refreshProcess(contex, 96, logger) 
           
        return (flag, cliRetAll, errMsg)
        
    except Exception, exception:
        logger.error(str(exception))
        return (False, cliRet, common.getMsg(lang, "query.result.abnormal"))
    finally:
                # 刷新进度条
        common.refreshProcess(contex, 100, logger)
