# -*- coding: UTF-8 -*-
from java.io import File
from java.lang import Exception

from com.huawei.ism.tool.obase.exception import ToolException

from comm import compressionManager
from comm import modelManager
import os
import re
import common
import traceback
import time
#定义两处全局变量 用于 慢盘关键字解析 判定
RETURN_SLOW = "returnSlow"
SLOW_CRICLE = "slowCricle"
#定义两个全局map 用于存储慢盘 框槽号与错误时间点
HANDPANTOTIME_MAP = {}
ALLHANDPANTOTIME_MAP = {}
#分别定义两个全局map，用于存储不同关键字解析出的慢盘数据
RETURNHAND_MAP = {}
SOLWHAND_MAP = {}

MEM_LIMIT_MAP = {
        'V100R005C01SPC700': 'V100R005C01SPH705',
        'V100R005C00SPC700': 'V100R005C00SPH705',
        'V100R005C01SPC900': 'V100R005C01SPH905',
        'V100R005C00SPC900': 'V100R005C00SPH905',
    }


def execute(cli):

    flag = True
    logger = PY_LOGGER
    lang = py_java_env.get("lang")
    sftp = py_java_env.get("sftp")
    devNode = py_java_env.get("devInfo")
    errMsg = ""
    allCliRet = ""
    cliRet = ""
    numberInt10 = 10
    numberInt30 = 30
    numberInt70 = 70

    try:
        #步骤2 检查系统当前版本
        (vsersionFlag, allCliRet, errMsg) = checkCurSystemVersion(cli, lang, logger, allCliRet)
        if vsersionFlag != True:
            return (vsersionFlag, allCliRet, errMsg)
        common.refreshProcess(py_java_env, numberInt10, logger)

        #若在本地文件中 15分钟内 有进行过一键日志收集，则直接使用，不再下载
        (isFileData, deCompressDestDir) = checkLocalFileData(logger, devNode)
        if isFileData != True:
            #步骤3 进入小系统
            changeFlag = modelManager.changeCliModel2Minisystem(cli, py_java_env)
            if changeFlag != True:
                modelManager.changeAnyModel2Cli(cli, sftp)
                errMsg = common.getMsg(lang, "diskslow.enter.model.false")
                return (common.RESULT_NOCHECK, allCliRet, errMsg)

            #步骤4 执行free -m确认当前控制器空闲内存        
            (freeMemFlag, allCliRet, errMsg) = getFreeMemInMinisystem(cli, lang, logger, allCliRet)
            if freeMemFlag != True:
                modelManager.changeAnyModel2Cli(cli, sftp)
                return (freeMemFlag, allCliRet, errMsg)

            #步骤5 退出小系统，重建CLI连接
            modelManager.changeAnyModel2Cli(cli, sftp)
            logger.info("[changeAnyModel2Cli] Have exit the small system, Reconnect the device.")
            common.refreshProcess(py_java_env, numberInt30, logger)

            #步骤6 在CLI命令行下执行"datacollect"命令收集存储日志至临时文件夹    
            (dataCollectFlag, dataCollectRet, errMsg, deCompressDestDir) = compressionManager.getDataCollectDecompressDir(py_java_env, cli, logger)
            allCliRet += "\n" + dataCollectRet
            if dataCollectFlag != True:
                return (common.RESULT_NOCHECK, allCliRet, errMsg)
            common.refreshProcess(py_java_env, numberInt70, logger)

        #步骤7-12 对下载日志进行解析，找出慢盘框槽号         
        (collectFilesFlag, outFrameSlotUsersID, errMsg, allCliRet) = checkCollectFiles(deCompressDestDir, logger, lang, allCliRet)
        if collectFilesFlag != True:
            return (collectFilesFlag, allCliRet, errMsg)

        #步骤13 config , 通过 外部框槽号，确定 硬盘对应raid 组
        if outFrameSlotUsersID:
            (definedHardRaidFlag, errMsg, configAllLine) = defineHardpanToRaidGroup(outFrameSlotUsersID, deCompressDestDir, logger, lang, allCliRet)
            allCliRet += configAllLine
            return (definedHardRaidFlag, allCliRet, errMsg)

        return (flag, allCliRet, errMsg)

    except (ToolException, Exception) as e:
        logger.error(str(e))
        return (common.RESULT_NOCHECK, allCliRet, common.getMsg(lang, "query.result.abnormal"))
    finally:
        logger.info("Finally end configured to determine whether reconnection.")
        modelManager.changeAnyModel2Cli(cli, sftp)

def checkLocalFileData(logger, devNode):
    '''
    @summary: 查询对应的本地临时文件中是否存在 
    @param logger: 日志信息
    @return: 
            False:不存在有近期搜集的日志
            True:存在近期收集日志
            dataCollectDir：日志路径
    '''
    devNodeCollectList = []
    dataCollectDir = ""

    #构造本地临时文件路径    
    root = "pytemp" + os.sep
    if os.path.exists(root):
        dataCollectList = os.listdir(root)
        devNodeSN = devNode.getDeviceSerialNumber()

        if len(dataCollectList) == 0:
            logger.info("[checkLocalFileData] Local file dataCollect is null.")
            return (False, dataCollectDir)

        #查询本地文件中 是否存在有相同设备SN号采集的日志        
        for dataCollect in dataCollectList:
            if devNodeSN in dataCollect:
                fileNameList = dataCollect.split('_')

                #如何文件名字解析错误，则返回                
                if len(fileNameList) < 2:
                    logger.info("[checkLocalFileData] dataCollect file defined name is error.")
                    return (False, dataCollectDir)

                createFileTime = fileNameList[1]
                devNodeCollectList.append(createFileTime)

        logger.info("[checkLocalFileData] DevNode datacollect list is %s." % devNodeCollectList)
        if len(devNodeCollectList) > 0 :
            try:
                #对文件 建立时间排序，将最 新时间 提到首位            
                devNodeCollectList = sorted(devNodeCollectList, cmp = None, key = None, reverse = True)
                newCreateFileTime = devNodeCollectList[0]

                #计算 系统当前时间            
                curTime = time.strftime('%Y%m%d%H%M%S', time.localtime(time.time()))

                timeDifference = common.getTimeDifferenceMinutes(newCreateFileTime, curTime, logger)
                if timeDifference != "":
                    if int(timeDifference) <= 900:
                        dataCollectDir = root + devNodeSN + "_" + newCreateFileTime + os.sep + "datacollect"
                        #若路径内文件数超过三份，证明此路径有效         
                        if os.path.exists(dataCollectDir):
                            if len(os.listdir(dataCollectDir)) >= 3 :
                                logger.info("[checkLocalFileData] DataCollectDir is %s." % dataCollectDir)
                                return (True, dataCollectDir)
            except:
                logger.error("[checkLocalFileData] Get dataCollect is :" + str(traceback.format_exc()))
                return(False, dataCollectDir)

    return (False, dataCollectDir)
def defineHardpanToRaidGroup(outFrameSlotUsersID, deCompressDestDir, logger, lang, allCliRet):
    '''
    @summary: 对 config 文件进行解析，通过 外部框槽号，确定 硬盘对应raid 组
    @param outFrameSlotUsersID: 慢盘对应的 外部框槽号
    @return: 
            False:一个raid组中一块慢盘，确认慢盘
            RESULT_WARNING:一个raid组中多块慢盘，业务压力大
            errMsg：错误消息
    '''
    errMsg = ""
    controllerFileName = ""
    raidIdAndDiskMap = {}
    handpanToRaidGroup = {}
    configAllLine = ""

    logger.info("[defineHardpanToRaidGroup] Defined hardpan to raidGroup is start.")
    for folderName in os.listdir(deCompressDestDir):
        if not folderName.startswith("DebugLog"):
            logger.info("[defineHardpanToRaidGroup] Open file : Config.")
            (isFindOrOpenFlag, fileInfoLists, errMsg) = findAndOpenFile("Config", deCompressDestDir, folderName, logger, lang)
            if isFindOrOpenFlag != True:
                return (isFindOrOpenFlag, errMsg, configAllLine)
            break

    countLine = -1
    for line in fileInfoLists:
        countLine += 1
        try:
            if "Member Disk List:" in line:
                framlStolIdStr = line[line.find("Member Disk List:") + len("Member Disk List:") :-1]
                framlStolIdList = framlStolIdStr.split(";")

                if len(framlStolIdList) < 1:
                    return (common.RESULT_NOCHECK, errMsg, configAllLine)

                if len(framlStolIdList[0].split(",")) < 2:
                    return (common.RESULT_NOCHECK, errMsg, configAllLine)

                raidIdLine = fileInfoLists[countLine - 11]
                if "RAID ID" in raidIdLine:
                    configAllLine += "\n" + raidIdLine
                    configAllLine += "\n" + line
                    raidIdList = raidIdLine.split(":")

                    if len(raidIdList) < 2:
                        return (common.RESULT_NOCHECK, errMsg, configAllLine)

                    raidId = raidIdList[1]
                    if "\n" in raidId:
                        raidId = raidId.replace("\n", "")

                    raidIdAndDiskMap.setdefault(raidId, framlStolIdList)
        except:
            logger.error("[defineHardpanToRaidGroup] Defined Config Member disk list :" + str(traceback.format_exc()))
            continue

    logger.info("[defineHardpanToRaidGroup] Defined raidIdAndDiskMap is : %s" % raidIdAndDiskMap)
    #如果    raidIdAndDiskMap 解析后为空，则证明 解析失败
    if raidIdAndDiskMap == {}:
        errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
        return (common.RESULT_NOCHECK, errMsg, configAllLine)

    #找出 慢盘 框槽号 对应的Raid id    
    for raidId in raidIdAndDiskMap.keys():
        raidDiskList = raidIdAndDiskMap.get(raidId)
        # 在 raid 组中的disk 列表中 对 慢盘 disk列表 取交集        
        handpanToRaidlist = list(set(outFrameSlotUsersID).intersection(set(raidDiskList)))
        #如果  交集  项不为空，则证明该raid ID 下存在慢盘
        if handpanToRaidlist:
            handpanToRaidGroup.setdefault(raidId, handpanToRaidlist)

    #如果    handpanToRaidGroup 解析后为空，则证明 解析失败
    if handpanToRaidGroup == {}:
        errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
        return (common.RESULT_NOCHECK, errMsg, configAllLine)

    logger.info("[defineHardpanToRaidGroup] Defined handpanToRaidGroup is : %s" % handpanToRaidGroup)
    (flag, fileInfoLine, errMsg) = confirmErrMsg(handpanToRaidGroup, deCompressDestDir, fileInfoLists, logger, lang)
    configAllLine += "\n" + fileInfoLine

    return (flag, errMsg, configAllLine)

def confirmErrMsg(handpanToRaidGroup, deCompressDestDir, fileInfoLists, logger, lang):
    '''
    @summary: 确认慢盘 最终返回的 报错信息
    @param handpanToRaidGroup: 慢盘及对应的raid ID
    @return: 
            False:RAID组（ID:%S）硬盘（x,y）响应慢。
            RESULT_WARNING:响应慢，请收集存储性能数据后联系技术工程师处理。
            errMsg：错误消息
    '''
    handpanRaidToDiskIdMap = {}
    isHandpanFlag = False
    vocationalHighPressureRaidId = []
    isVocationaFlag = False
    errMsg = ""
    fileInfoLine = ""

    for raidId in handpanToRaidGroup.keys():
        handpanDiskList = handpanToRaidGroup.get(raidId)
        if len(handpanDiskList) == 1:
            handpanRaidToDiskIdMap.setdefault(raidId, handpanDiskList[0])
        else:
            vocationalHighPressureRaidId.append(raidId)

    logger.info("[handpanToRaidGroup] Defined handpanRaidToDiskIdMap is : %s" % handpanRaidToDiskIdMap)
    logger.info("[handpanToRaidGroup] Defined vocationalHighPressureRaidId is : %s" % vocationalHighPressureRaidId)

    #若存在 raid组中 有单一慢盘，则存入字典    
    if len(handpanRaidToDiskIdMap) > 0:

        #步骤13 查找慢盘SN
        ischeckConfigDiskSN, handpanRaidToDiskIdMap, configLine, errMsgConfig = checkConfigDiskSN(handpanRaidToDiskIdMap, fileInfoLists, logger, lang)
        fileInfoLine += configLine
        if ischeckConfigDiskSN != True:
            return (common.RESULT_NOCHECK, fileInfoLine, errMsgConfig)

        #步骤14-16
        if len(handpanRaidToDiskIdMap) > 0:
            isCheckEventFiles, handpanRaidToDiskIdMap, errMsgEvent, eventAllLine = checkEventFiles(handpanRaidToDiskIdMap, deCompressDestDir, logger, lang)
            fileInfoLine += eventAllLine
            if isCheckEventFiles != True:
                return (common.RESULT_NOCHECK, fileInfoLine, errMsgEvent)

        if len(handpanRaidToDiskIdMap) > 0:
            isHandpanFlag = True
            for raidId in handpanRaidToDiskIdMap.keys():
                errMsg += common.getMsg(lang, "diskslow.raid.has.hanpandisk", (raidId, handpanRaidToDiskIdMap.get(raidId)[0]))

    #若存在 raid组中 有多个慢盘，则存入列表
    if len(vocationalHighPressureRaidId) > 0:
        isVocationaFlag = True
        errMsg += common.getMsg(lang, "diskslow.raid.has.highpressure", ",".join(vocationalHighPressureRaidId))

    if isHandpanFlag and isVocationaFlag:
        logger.info("[handpanToRaidGroup] Slow disk exists and heavy business pressure two scenarios.")
        return (False, fileInfoLine, errMsg)

    if isHandpanFlag:
        logger.info("[handpanToRaidGroup] The service has handpan.")
        return (False, fileInfoLine, errMsg)

    if isVocationaFlag:
        logger.info("[handpanToRaidGroup] The service pressure scenarios.")
        return (common.RESULT_WARNING, fileInfoLine, errMsg)

    logger.info("[handpanToRaidGroup] Abnormal scenarios.")
    return (True, fileInfoLine, "")

def checkEventFiles(handpanRaidToDiskIdMap, deCompressDestDir, logger, lang):
    '''
    @summary: 确认慢盘 在event文件中 是否存在install 和 remove
    @param handpanToRaidGroup: 慢盘及对应的raid ID SN号
    @param deCompressDestDir: 文件路径
    @param logger: 日志文件
    @return:
            errMsg：错误消息
    '''
    removeRaid = []
    errMsg = ""
    eventAllLine = ""

    logger.info("[checkEventFiles]")
    for folderName in os.listdir(deCompressDestDir):
        if not folderName.startswith("DebugLog"):
            logger.info("[checkEventFiles] Open file : Event.")
            (isFindOrOpenFlag, fileInfoLists, errMsg) = findAndOpenFile("Event", deCompressDestDir, folderName, logger, lang)
            if isFindOrOpenFlag != True:
                return (isFindOrOpenFlag, handpanRaidToDiskIdMap, errMsg, eventAllLine)
            break

    raidList = handpanRaidToDiskIdMap.keys()
    except_counter = 0
    for raid in raidList:
        framlSoltId = handpanRaidToDiskIdMap.get(raid)[0]
        diskSN = handpanRaidToDiskIdMap.get(raid)[1]
        global ALLHANDPANTOTIME_MAP
        errorTime = ALLHANDPANTOTIME_MAP.get(framlSoltId)

        insertedKeywork = "inserted. sn is %s" % diskSN.lower()
        removedKeywork = "removed. sn is %s" % diskSN.lower()


        for fileLine in fileInfoLists:
            try:
                fileTime = re.search(r"(\d{4}-\d{1,2}-\d{1,2}\s\d{1,2}:\d{1,2}:\d{1,2})", fileLine).group().strip()
                if errorTime <= fileTime:
                    if insertedKeywork in fileLine.lower():
                        eventAllLine += "\n" + fileLine
                        handpanRaidToDiskIdMap.pop(raid)
                        logger.info("%s is install ,so delete " % diskSN)
                        break

                    if removedKeywork in fileLine.lower():
                        eventAllLine += "\n" + fileLine
                        removeRaid.append(raid)
                        break
            except:
                except_counter += 1

    reverFileInfoLists = list(reversed(fileInfoLists))

    if (len(removeRaid) > 0) and (len(handpanRaidToDiskIdMap) > 0):
        for raid in removeRaid:
            framlSoltId = handpanRaidToDiskIdMap.get(raid)[0]
            diskSN = handpanRaidToDiskIdMap.get(raid)[1]
            global ALLHANDPANTOTIME_MAP
            errorTime = ALLHANDPANTOTIME_MAP.get(framlSoltId)

            insertedKeywork = "inserted. sn is %s" % diskSN.lower()
            removedKeywork = "removed. sn is %s" % diskSN.lower()

            except_counter = 0
            for fileLine in reverFileInfoLists:
                try:
                    fileTime = re.search(r"(\d{4}-\d{1,2}-\d{1,2}\s\d{1,2}:\d{1,2}:\d{1,2})", fileLine).group().strip()
                    if errorTime <= fileTime:
                        if removedKeywork in fileLine.lower():
                            eventAllLine += "\n" + fileLine
                            handpanRaidToDiskIdMap.pop(raid)
                            logger.info("%s is install ,so delete " % diskSN)
                            break

                        if insertedKeywork in fileLine.lower():
                            eventAllLine += "\n" + fileLine
                            logger.info("The %s is Removed last. " % diskSN)
                            break
                except:
                    except_counter += 1

    return (True, handpanRaidToDiskIdMap, errMsg, eventAllLine)

def checkConfigDiskSN(handpanRaidToDiskIdMap, fileInfoLists, logger, lang):
    '''
    @summary: 确认慢盘 对应的sn号
    @param handpanToRaidGroup: 慢盘及对应的raid ID SN号
    @param fileInfoLists: 文件路径
    @param logger: 日志文件
    @return:
            errMsg：错误消息
    '''
    errMsg = ""
    isCheckDiskSN = False
    countSNLines = 0
#    handpanRaidToDiskIdMap
#    构造{raid:0,5,SN}
    framlSoltToSnMap = {}
#    {0,5:SN}
    handpanFrSoltToSN = {}
#    {0,5:SN}
    configLine = ""

    for fileLine in fileInfoLists:
        if "##### disk key info #####" in fileLine.lower():
            isCheckDiskSN = True
            continue

        if isCheckDiskSN:
            if "###################" in fileLine.lower():
                break

            if countSNLines == 0:
                countSNLines = 1
                continue

            framlSoltAndSNList = fileLine.split()

            if len(framlSoltAndSNList) < 10:
                continue

            framlSoltId = "%s,%s" % (framlSoltAndSNList[0].strip(), framlSoltAndSNList[1].strip())
            diskSN = framlSoltAndSNList[9].strip()
            if diskSN and diskSN != "--":
                framlSoltToSnMap.setdefault(framlSoltId, diskSN)
            configLine += "\n" + fileLine

    #若此处map为空，则证明为成功解析框槽号对应的SN号    
    logger.info("[checkConfigDiskSN] FramlSoltToSnMap %s" % framlSoltToSnMap)
    if len(framlSoltToSnMap) == 0:
        errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
        return (common.RESULT_NOCHECK, handpanRaidToDiskIdMap, configLine, errMsg)

    raidList = handpanRaidToDiskIdMap.keys()
    for raidId in raidList:
        framlSoltId = handpanRaidToDiskIdMap.get(raidId)
        if framlSoltId in framlSoltToSnMap:
            diskSN = framlSoltToSnMap.get(framlSoltId)
            handpanRaidToDiskIdMap[raidId] = [framlSoltId, diskSN]
        else:
            handpanRaidToDiskIdMap.pop(raidId)

    logger.info("[checkConfigDiskSN] handpanRaidToDiskIdMap %s" % handpanRaidToDiskIdMap)
    #若此处 验证map 为空，则证明raid组中无慢盘    
    if len(handpanRaidToDiskIdMap) == 0:
        return (True, handpanRaidToDiskIdMap, configLine, errMsg)

    return (True, handpanRaidToDiskIdMap, configLine, errMsg)

def checkCollectFiles(deCompressDestDir, logger, lang, allCliRet):
    '''
    @summary: 对 dataCollect 压缩包中文件进行解析，如有慢盘，则找出对应框槽号
    @param deCompressDestDir: 端dataCollect 压缩包 文件路径
    @param logger: 日志信息
    @param lang: 语言判断
    @return: 
            True:无慢盘
            RESULT_NOCHECK:无相关文件，或 解析文件失败
            errMsg：错误消息
    '''
    logger.info("[checkCollectFiles] check checkCollectFiles start.")
    global RETURN_SLOW
    global SLOW_CRICLE
    errMsg = ""
    messagesFilesIsNull = 0
    outFrameSlotUsersID = []

    if len(os.listdir(deCompressDestDir)) == 0:
        logger.info("[checkCollectFiles] File datacollect is null or less.")
        errMsg = common.getMsg(lang, "datacollect.decompressing.logfile.failed")
        return (common.RESULT_NOCHECK, outFrameSlotUsersID, errMsg, allCliRet)

    for folderName in os.listdir(deCompressDestDir):
        #['xx.xx.xx.xx_MAIN', 'xx.xx.xx.xx', 'DebugLogLib']
        if not folderName.startswith("DebugLog"):
            allInnerUsersID = []
            #步骤7 解析messages文件            
            (isHardpankey, hardpanReturnSlowMap, hardpanSlowCricleMap, messagesFilesIsNull, messageAllLine) = \
                checkMessageFiles(deCompressDestDir, folderName, messagesFilesIsNull, logger, lang)

            allCliRet += "\n" + messageAllLine
            #查询两次后，均无message文件，返回未检查            
            if messagesFilesIsNull == 2:
                logger.info("[checkCollectFiles] Messages files is null in A/B controller.")
                errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
                return (common.RESULT_NOCHECK, outFrameSlotUsersID, errMsg, allCliRet)

            #步骤8-11 检查message文件中，是否存在慢盘报警信息超过阀值，并执行之后检查流程
            # 若 isHardpankey 有值，则证明message文件解析出慢盘信息                       
            if isHardpankey:
                #解析关键字“returnSlow” 流程                
                if hardpanReturnSlowMap:
                    logger.info("[defineRetureSolwRaidGroup] <return slow> Define innerUsersID is strat")

                    #将关键字解析数据 优先赋予全局变量，用于存储 errTime 信息                
                    global RETURNHAND_MAP
                    RETURNHAND_MAP = hardpanReturnSlowMap
                    logger.info("[checkCollectFiles] RETURNHAND_MAP is : %s" % RETURNHAND_MAP)

                    (isDefinedFlag, innerUsersID, errMsg) = defineRetureSolwRaidGroup(deCompressDestDir, folderName, hardpanReturnSlowMap, logger, lang)
                    if isDefinedFlag != True:
                        logger.info("[defineRetureSolwRaidGroup] Get <return slow> innerUsersID is error.")
                        return (isDefinedFlag, outFrameSlotUsersID, errMsg, allCliRet)

                    #同一控制器内 对解析出的框槽号进行累加                    
                    if len(innerUsersID) > 0:
                        allInnerUsersID = innerUsersID

                #解析关键字“slow cricle” 流程
                if hardpanSlowCricleMap:
                    logger.info("[checkCollectFiles] Defined <slow cricle> checking file is start.")

                    global SOLWHAND_MAP
                    SOLWHAND_MAP = hardpanSlowCricleMap
                    logger.info("[checkCollectFiles] SOLWHAND_MAP is : %s" % SOLWHAND_MAP)

                    #步骤9 解析pangea_mmlinfo， 获取scsID
                    (isDefinedFlag, scsIdList, errMsg, pangeaAllLine) = getScsID(deCompressDestDir, folderName, hardpanSlowCricleMap, logger, lang)
                    allCliRet += "\n" + pangeaAllLine

                    if isDefinedFlag != True:
                        logger.info("[getScsID] Get <slow cricle> scsID is error.")
                        return (isDefinedFlag, outFrameSlotUsersID, errMsg, allCliRet)
                    if len(scsIdList) == 0:
                        continue

                    #步骤10 解析emp_mmlinfo，获取 内部框槽号
                    (isDefinedFlag, innerUsersID, errMsg, empAllLine) = defineSlowRaidGroup(deCompressDestDir, folderName, scsIdList, logger, lang)
                    allCliRet += "\n" + empAllLine
                    if isDefinedFlag != True:
                        logger.info("[getScsID] Get <slow cricle> innerUsersID is error.")
                        return (isDefinedFlag, outFrameSlotUsersID, errMsg, allCliRet)

                    #对于两次关键字解析出来的数据 去重                    
                    if len(innerUsersID) > 0:
                        allInnerUsersID = list(set(allInnerUsersID) | set(innerUsersID))
            else:
                #当次检查message文件中，无慢盘报警
                logger.info("[checkCollectFiles] This checked has no handpans in %s ." % folderName)
                continue

            if len(allInnerUsersID) == 0:
                logger.info("[checkCollectFiles] This error : hardpankeyWordMap can not defined keyWork.")
                continue

            #去重后赋值给全局变量  HANDPANTOTIME_MAP             
            evaluationHandpanToTimeMap()

            #步骤12 emp_mmlinfo. 获取内部框槽号后,推去外部框槽号
            (isFrameIDFlag, outFrameSlotUsersID , errMsg, empAllLine) = \
                getFrameSlotUsersID(outFrameSlotUsersID, allInnerUsersID, deCompressDestDir, folderName, logger, lang)

            allCliRet += empAllLine
            if isFrameIDFlag != True:
                logger.info("[checkCollectFiles] Get outFrameSlotUsersID is error in %s." % folderName)
                return (isFrameIDFlag, outFrameSlotUsersID, errMsg, allCliRet)

    return (True, outFrameSlotUsersID, errMsg, allCliRet)

def evaluationHandpanToTimeMap():
    '''
    @summary: 将变量RETURNHAND_MAP，SOLWHAND_MAP  去重后赋值给全局变量  HANDPANTOTIME_MAP ，
                           若数据重复，则取errTime 时间靠后的 值
                          该 方法无返回值，操作全局变量   
    @param RETURNHAND_MAP：  关键字return 解析出的 {0,2：errTime}
    @param RETURNHAND_MAP： 关键字sloe 解析出的 {0,2：errTime}
    @param HANDPANTOTIME_MAP： 去重后的全局变量
    
    '''
    global HANDPANTOTIME_MAP
    global RETURNHAND_MAP
    global SOLWHAND_MAP

    if (len(RETURNHAND_MAP) > 0) and (len(SOLWHAND_MAP) > 0):
        tempMap = {}
        for reHandpan in RETURNHAND_MAP:
            for handpan in SOLWHAND_MAP:
                #若 慢盘信息重复时,则去重,并保留 errTime时间靠后的时间点                
                if reHandpan == handpan:
                    if RETURNHAND_MAP.get(reHandpan) > SOLWHAND_MAP.get(handpan):
                        tempMap.setdefault(reHandpan, RETURNHAND_MAP.get(reHandpan))
                    else:
                        tempMap.setdefault(reHandpan, SOLWHAND_MAP.get(handpan))

        RETURNHAND_MAP.update(SOLWHAND_MAP)
        RETURNHAND_MAP.update(tempMap)

        HANDPANTOTIME_MAP = RETURNHAND_MAP

    elif len(RETURNHAND_MAP) > 0:
        HANDPANTOTIME_MAP = RETURNHAND_MAP

    elif len(SOLWHAND_MAP) > 0:
        HANDPANTOTIME_MAP = SOLWHAND_MAP

    #关键字 全局变量 使用完后，清空    
    RETURNHAND_MAP = {}
    SOLWHAND_MAP = {}

def getFrameSlotUsersID(outFrameSlotUsersID, innerUsersID, deCompressDestDir, folderName, logger, lang):
    '''
    @summary: 解析emp_mmlinfo. 获取内部框槽号后,推断外部框槽号
    @param outFrameSlotUsersID：  检查两个控制器后 累计的 慢盘 外部框槽号
    @param innerUsersID： 当前控制器对应的 内部框槽号
    @param deCompressDestDir： 文件路径信息
    @param folderName： 控制器文件名
    @param logger： 日志信息
    @return: 
            True: 外部框槽号  解析成功
            RESULT_NOCHECK： 未检查
            outFrameSlotUsersID： 外部框槽号 列表
    '''
    errMsg = ""
    frameSlotUsersID = []
    framlIdMap = {}
    outFrameSlotToErrTime = {}
    empAllLine = ""

    logger.info("[getFrameSlotUsersID] Open file : emp_mmlinfo.")
    (isFindOrOpenFlag, fileInfoLists, errMsg) = findAndOpenFile("emp_mmlinfo", deCompressDestDir, folderName, logger, lang)
    if isFindOrOpenFlag != True:
        logger.info("[getFrameSlotUsersID] Open Or Read file : emp_mmlinfo is error.")
        return (isFindOrOpenFlag, outFrameSlotUsersID, errMsg, empAllLine)

    # 解析line : user, inner, can : [0, 0, xxxxxxxxxx]    
    for line in fileInfoLists:
        if "user, inner," in line:
            empAllLine += "\n" + line
            framlIdList = line[line.find("[") + 1 : line.find("]")].split(",")

            if len(framlIdList) < 2:
                errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
                return (common.RESULT_NOCHECK, outFrameSlotUsersID, errMsg, empAllLine)

            outFramlId = framlIdList[0].strip()
            innerFramlId = framlIdList[1].strip()
            framlIdMap.setdefault(outFramlId, innerFramlId)

    if len(framlIdMap) == 0:
        logger.info("[getFrameSlotUsersID] Defined framlID map is null.")
        errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
        return (common.RESULT_NOCHECK, outFrameSlotUsersID, errMsg, empAllLine)

    #对 硬盘的 内、外 框位号 做替换    
    for innerFramIdkey in framlIdMap.keys():
        for innerUser in innerUsersID:
            #分解出硬盘的内部框位好            
            innerIDList = innerUser.split(',')

            if len(innerIDList) < 1:
                continue

            innerID = innerIDList[0]
            if framlIdMap.get(innerFramIdkey) == innerID:
                #内部框位号 匹配上后，替换为外部框位号                
                outUserID = innerUser.replace(innerID, innerFramIdkey)
                frameSlotUsersID.append(outUserID)

                global HANDPANTOTIME_MAP
                keyList = HANDPANTOTIME_MAP.keys()

                if innerUser in keyList:
                    errorTime = HANDPANTOTIME_MAP.get(innerUser)
                    HANDPANTOTIME_MAP.pop(innerUser)
                    reErrorTime = HANDPANTOTIME_MAP.setdefault(outUserID, errorTime)
                    if reErrorTime != errorTime:
                        outFrameSlotToErrTime.setdefault(outUserID, errorTime)

    logger.info("outFrameSlotToErrTime %s" % outFrameSlotToErrTime)
    logger.info("HANDPANTOTIME_MAP %s" % HANDPANTOTIME_MAP)
    if len(outFrameSlotToErrTime) > 0:
        global HANDPANTOTIME_MAP
        HANDPANTOTIME_MAP.update(outFrameSlotToErrTime)

    #此处对 全局变量  ALLHANDPANTOTIME_MAP 去重  
    global ALLHANDPANTOTIME_MAP
    #若 ALLHANDPANTOTIME_MAP 变量有值，则视为处理第二控制器，且第一控制器有值    
    if len(ALLHANDPANTOTIME_MAP) > 0:
        tempMap = {}
        for allhandpan in ALLHANDPANTOTIME_MAP:
            for handpan in HANDPANTOTIME_MAP:
                #若 慢盘信息重复时,则去重,并保留 errTime时间靠后的时间点                
                if allhandpan == handpan:
                    if ALLHANDPANTOTIME_MAP.get(allhandpan) > HANDPANTOTIME_MAP.get(handpan):
                        tempMap.setdefault(allhandpan, ALLHANDPANTOTIME_MAP.get(allhandpan))
                    else:
                        tempMap.setdefault(allhandpan, HANDPANTOTIME_MAP.get(handpan))

        ALLHANDPANTOTIME_MAP.update(HANDPANTOTIME_MAP)
        ALLHANDPANTOTIME_MAP.update(tempMap)
    # 第一次对任一控制器进行处理时        
    else:
        ALLHANDPANTOTIME_MAP = HANDPANTOTIME_MAP

    if len(frameSlotUsersID) == 0:
        logger.info("[getFrameSlotUsersID] GetUsersID is error , frameSlotUsersID is null. ")
        errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
        return (common.RESULT_NOCHECK, outFrameSlotUsersID, errMsg, empAllLine)

    #在 两次控制器 中 查询到的 框槽号中 去重                    
    if len(outFrameSlotUsersID) > 0:
        outFrameSlotUsersID = list(set(outFrameSlotUsersID) | set(frameSlotUsersID))
    else:
        outFrameSlotUsersID = frameSlotUsersID

    logger.info("[getFrameSlotUsersID] ALLHANDPANTOTIME_MAP is %s " % ALLHANDPANTOTIME_MAP)
    logger.info("[getFrameSlotUsersID] outFrameSlotUsersID is %s " % outFrameSlotUsersID)
    return (True, outFrameSlotUsersID, errMsg, empAllLine)

def defineRetureSolwRaidGroup(deCompressDestDir, folderName, hardpankeyWordMap, logger, lang):
    '''
    @summary: 解析  关键字 “return slow” , 已 disk ID 确定慢盘 内部框槽号
    @param hardpanReturnSlowMap： 日志文件中  慢盘对应 的关键字
    @return: 
            True: 确定 慢盘内部框槽号
            RESULT_NOCHECK： 未检查
            innerUsersID ： 慢盘内部框槽号
    '''
    #待确定的框槽号
    innerUsersID = []
    errMsg = ""

    #获取慢盘disk ID ,这里获取的list列表中关键字，分为：硬盘add，或硬盘disk ID
    hardpanDiskIDist = hardpankeyWordMap.keys()

    for hardpanDisk in hardpanDiskIDist:

        try:
            slotID = str(int(hardpanDisk) % 32)
            framlID = str(int(hardpanDisk) / 32)
            innerUsersStr = "%s%s%s" % (framlID, ',', slotID)
            innerUsersID.append(innerUsersStr)

            #更新 RETURNHAND_MAP 存储数据 【0,2：时间戳】            
            global RETURNHAND_MAP
            hardpanDiskList = RETURNHAND_MAP.keys()

            if hardpanDisk in hardpanDiskList:
                errorTime = RETURNHAND_MAP.get(hardpanDisk)
                #将 无用数据删除后，重新更新数据,数据存储统一                
                RETURNHAND_MAP.pop(hardpanDisk)
                RETURNHAND_MAP.setdefault(innerUsersStr, errorTime)
        except:
            logger.error("[defineRetureSolwRaidGroup] Get slotID is error:" + str(traceback.format_exc()))
            logger.error("[defineRetureSolwRaidGroup] Define hardpanDisk %s is error." % hardpanDisk)
            continue

    logger.info("[defineRetureSolwRaidGroup] <return slow> innerUsersID is : %s" % innerUsersID)
    if  len(innerUsersID) == 0:
        errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
        return (common.RESULT_NOCHECK, innerUsersID, errMsg)

    return (True, innerUsersID , errMsg)

def getScsID(deCompressDestDir, folderName, hardpankeyWordMap, logger, lang):
    '''
    @summary: 解析  关键字 “slow cricle” , 以慢盘  addr 确定慢盘 对应scs ID
    @param hardpanReturnSlowMap： 日志文件中  慢盘对应 的关键字
    @param deCompressDestDir：文件路径信息
    @param folderName： 控制器文件名
    @param logger： 日志信息
    @return: 
            True: 确定 慢盘scsId 
            RESULT_NOCHECK： 未检查
            scsIdList ： 慢盘 对应 scs ID 列表
    '''
    #待确定的框槽号
    scsIdList = []
    errMsg = ""
    pangeaAllLine = ""

    logger.info("[getScsID] Open file : pangea_mmlinfo.")
    (isFindOrOpenFlag, fileInfoLists, errMsg) = findAndOpenFile("pangea_mmlinfo", deCompressDestDir, folderName, logger, lang)
    if isFindOrOpenFlag != True:
        return (isFindOrOpenFlag, scsIdList, errMsg, pangeaAllLine)

    #获取慢盘add地址,这里获取的list列表中关键字，分为：硬盘add，或硬盘disk ID
    hardpanAddList = hardpankeyWordMap.keys()

    #解析文件关键字
    for hardpanAdd in hardpanAddList:
        for line in fileInfoLists:
            line = line.lower()
            if line.startswith("lport") and (line.find(hardpanAdd) != -1):

                fileLine = line[line.find("lport"):line.find("exp")]
                pangeaAllLine += "\n" + fileLine

                fristIndex = line.find("dev[")
                endIndex = line.find("] addr:")
                if (fristIndex != -1) and (endIndex != -1):
                    #从当前Line中 提取出 scsId 关键字 【9:0:87:0】                
                    tempScsIdList = line[fristIndex + 4:endIndex].split(":")
                    #将scsId 拼接为【9，（空格） 87，                 
                    scsId = "[%s, %s," % (tempScsIdList[0].strip(), tempScsIdList[2].strip())
                    scsIdList.append(scsId)

                    global SOLWHAND_MAP
                    hardpanList = SOLWHAND_MAP.keys()

                    if hardpanAdd in hardpanList:
                        errorTime = SOLWHAND_MAP.get(hardpanAdd)
                        SOLWHAND_MAP.pop(hardpanAdd)
                        SOLWHAND_MAP.setdefault(scsId, errorTime)
                    break

    logger.info("[getScsID] scsIdList is : %s" % scsIdList)
    if len(scsIdList) == 0:
        logger.info("[getScsID] scsIdList is null")
        return (True, scsIdList, "", pangeaAllLine)

    return (True, scsIdList, errMsg, pangeaAllLine)

def defineSlowRaidGroup(deCompressDestDir, folderName, scsIdList, logger, lang):
    '''
    @summary: 解析  关键字 “slow cricle” , 确定慢盘 内部框槽号
    @param hardpanReturnSlowMap： 日志文件中  慢盘对应 的关键字
    @param scsIdList： 慢盘对应 scsID 列表
    @param deCompressDestDir： 文件路径信息
    @param logger： 日志信息
    @return: 
            True: 确定 慢盘内部框槽号
            RESULT_NOCHECK： 未检查
            innerUsersID ： 慢盘内部框槽号
    '''
    #待确定的框槽号
    innerUsersID = []
    errMsg = ""
    empAllLine = ""

    logger.info("[defineSlowRaidGroup] Open file : emp_mmlinfo.")
    (isFindOrOpenFlag, fileInfoLists, errMsg) = findAndOpenFile("emp_mmlinfo", deCompressDestDir, folderName, logger, lang)
    if isFindOrOpenFlag != True:
        return (isFindOrOpenFlag, innerUsersID, errMsg, empAllLine)

    #解析scsID 关键字，提取内部框槽号    
    for scsId in scsIdList:
    #起始行标为-1 ，每解析一行 +1 则第一行以索引0 开始        
        countLines = -1
        for line in fileInfoLists:
            countLines += 1
            if scsId in line:
                try:
                    innerUsersStr = ""

                    #解析到关键字后，上提4行  为要继续解析的 line 
                    empAllLine += "\n" + line
                    countLines = countLines - 4
                    #找到 对应的内部框槽号的 “行”信息                    
                    innerUserStr = fileInfoLists[countLines]
                    empAllLine += innerUserStr
                    #当前行中 切出 内部框槽号                    
                    fristIndex = innerUserStr.find(")")
                    endIndex = innerUserStr.find("state")
                    if (fristIndex != -1) and (endIndex != -1):
                        innerUsers = innerUserStr[fristIndex + 1:endIndex].strip()
                        innerUsersStrlist = innerUsers[1:-1].split(',')

                        if len(innerUsersStrlist) >= 2:
                            framlID = innerUsersStrlist[0].strip()
                            slotID = innerUsersStrlist[1].strip()
                            innerUsersStr = "%s%s%s" % (framlID, ',', slotID)

                        #此处将查询到的内部框槽号 以 '0,2' 字符串形式  的方式存储
                        if innerUsersStr != "":
                            innerUsersID.append(innerUsersStr)

                            global SOLWHAND_MAP
                            scsIdList = SOLWHAND_MAP.keys()

                            if scsId in scsIdList:
                                errorTime = SOLWHAND_MAP.get(scsId)
                                SOLWHAND_MAP.pop(scsId)
                                SOLWHAND_MAP.setdefault(innerUsersStr, errorTime)
                except:
                    logger.error("[defineSlowRaidGroup] Define scsID %s is error." % scsId)
                #应为在文件中 只存在一份关键字，所以在查询到后，可以退出当前关键字的循环，查找下一关键字                
                break

    logger.info("[defineSlowRaidGroup] <slow cricle> innerUsersID is : %s" % innerUsersID)
    if len(innerUsersID) == 0:
        errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
        return (common.RESULT_NOCHECK, innerUsersID, errMsg, empAllLine)

    return (True, innerUsersID , errMsg, empAllLine)

def findAndOpenFile(fileNamekeyWord, deCompressDestDir, folderName, logger, lang):
    '''
    @summary: 查询 及 读取 对应的解析文件
    @param fileNamekeyWord： 解析文件名
    @param deCompressDestDir： 解析文件路径
    @param folderName： 解析控制器文件名
    @return: 
            True: 文件读取成功
            RESULT_NOCHECK： 未检查
            fileInfoLists ： 文件内容
    '''
    errMsg = ""
    fileInfoLists = []
    pangeaTxtName = ""
    messagesroot = ""

    for root, dirs, files in os.walk(deCompressDestDir + os.sep + folderName, False):
        for file in files:
            if fileNamekeyWord in file:
                pangeaTxtName = file
                messagesroot = root
                break

    logger.info("[findAndOpenFile] Find fileName is : %s" % pangeaTxtName)
    if pangeaTxtName == "":
        errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
        return (common.RESULT_NOCHECK, fileInfoLists, errMsg)

    #获取文件 路径
    messagesFilePath = messagesroot + os.sep + pangeaTxtName
    file = ""
    try:
        file = open(messagesFilePath)
        fileInfoLists = file.readlines()
    except:
        logger.error("[findAndOpenFile] Open file %s is error : " + str(traceback.format_exc()))
        errMsg = common.getMsg(lang, "open.messages.file.failed", ("", ""))
        return (common.RESULT_NOCHECK, fileInfoLists, errMsg)
    finally:
        if file:
            file.close()

    if len(fileInfoLists) == 0:
        logger.info("[findAndOpenFile] Read file %s is error or null." % pangeaTxtName)
        errMsg = common.getMsg(lang, "diskslow.lack.abnormal.files")
        return (common.RESULT_NOCHECK, fileInfoLists, errMsg)

    return (True, fileInfoLists , errMsg)

def checkMessageFiles(deCompressDestDir, folderName, messagesFilesIsNull, logger, lang):
    '''
    @summary: 解析messages 文件，只解析当前控制器中最新的一份message
    @param deCompressDestDir: 端 dataCollect 压缩包 文件路径
    @param folderName: message 文件名称
    @return: 
            messagesFilesIsNull: 当前控制器中 无message文件  标示位
            hardpanReturnSlowMap： 日志文件中  慢盘对应 的关键字
    '''
    global RETURN_SLOW
    global SLOW_CRICLE
    messageAllLine = ""
    messagesFileList = []
    fileInfoLists = []
    nullMap = {}

    logger.info("[checkMessageFiles] checking messages files is starting.")
    for root, dirs, files in os.walk(deCompressDestDir + os.sep + folderName, False):
        for file in files:
            if 'messages_' in file:
                #构造messages日志包路径
                messagesroot = root
                messagesFileList.append(file)

    if len(messagesFileList) == 0:
        #当前循环内 +1 ， 代表一个控制器检查结束        
        messagesFilesIsNull += 1
        return (False, nullMap , nullMap, messagesFilesIsNull, messageAllLine)

    #将message日志文件按最新时间进行排列
    messagesFileList = sorted(messagesFileList, cmp = None, key = None, reverse = True)
    logger.info("[checkMessageFiles] MessagesFileList  is " + str(messagesFileList))

    if len(messagesFileList) >= 2:
        number = 1
    else:
        number = 0

    while (number >= 0):
        #解析最新的messages  前两份    文件信息文件
        messagesFilePath = messagesroot + os.sep + messagesFileList[number]
        number -= 1

        file = ""
        try:
            file = open(messagesFilePath)
            fileInfosinge = file.readlines()
            fileInfoLists += fileInfosinge
        except:
            logger.error("[checkMessageFiles] Read messages file :" + str(traceback.format_exc()))
            return (False, nullMap , nullMap, messagesFilesIsNull, messageAllLine)
        finally:
            if file:
                file.close()
    #开始解析messages文件关键字 
    logger.info("[analyzeMessagesHardpan] Analyze messages file is <slow circle> starting.")
    (slowFlag, hardpanSlowCricleMap, messageLine) = analyzeMessagesHardpan(fileInfoLists, "slow circle:", "disk", "slow circle:", logger)
    messageAllLine += messageLine

    logger.info("[analyzeMessagesHardpan] Analyze messages file is <RETURN_SLOW_IO> starting.")
    (returnSlowFlag, hardpanReturnSlowMap, messageLine) = analyzeMessagesHardpan(fileInfoLists, "RETURN_SLOW_IO[", "diskid--", ", lba", logger)
    messageAllLine += messageLine

    #若关键字 有任一情况满足，均返回    
    if slowFlag or returnSlowFlag:
        return (True, hardpanReturnSlowMap, hardpanSlowCricleMap, messagesFilesIsNull, messageAllLine)

    #检查后  当前控制器message信息  无慢盘，返回nullMap    
    return (False, nullMap, nullMap , messagesFilesIsNull, messageAllLine)

def analyzeMessagesHardpan(fileInfoLists, keywords, firstkeyWork, nextkeyWork, logger):
    '''
    @summary: 解析messages文件  慢盘 关键字 ，若 同一硬盘的 慢盘 告警日志 超过10条，则记录 往下解析
    @param fileInfoLists:  message 文件读取内容
    @param keywords: 对应的  慢盘 日志关键字
    @param firstkeyWork: 慢盘日志  截取信息   的前索引位
    @param nextkeyWork: 慢盘日志  截取信息   的后索引位
    @param indexNumber: 慢盘日志  截取信息   的偏移位
    @param logger: 日志信息
    @return: 
            True: 当前控制器 存在慢盘可能，继续检查
            False：当前控制器 无慢盘存在
            hardpanKeyWorksMap: 慢盘对应的关键信息，分为key ： addr  及  disk ID  value: 当前日志同盘内 出现的次数
    '''
    hardpanKeyWorksMap = {}
    messageLine = ""

    for fileInfo in fileInfoLists:
        #找出对应的关键字，及关键字需要的 切割条件        
        if keywords in fileInfo:
            try:
                firstIndex = fileInfo.find(firstkeyWork)
                endIndex = fileInfo.find(nextkeyWork)

                #此处 正则匹配 错误时间点
                errorTime = re.search(r"(\d{4}-\d{1,2}-\d{1,2}\s\d{1,2}:\d{1,2}:\d{1,2})", fileInfo).group().strip()

                if (firstIndex != -1) and (endIndex != -1):
                    hardpankey = fileInfo[firstIndex + len(firstkeyWork):endIndex].strip()
                    #记录关键字出现的次数            
                    if hardpankey in hardpanKeyWorksMap:
                        hardpanKeyWorksMap[hardpankey][0] += 1
                        hardpanKeyWorksMap[hardpankey][1] = errorTime
                        if (hardpanKeyWorksMap[hardpankey][0] == 10):
                            #若关键字该行符合条件，则加入回显信息                        
                            if keywords == "RETURN_SLOW_IO[":
                                #截取日志                            
                                rIndex = fileInfo.find("RAID")
                                eIndex = fileInfo.find("],")
                                if (rIndex != -1) and (eIndex != -1):
                                    infoLine = fileInfo[rIndex:eIndex]
                                    messageLine += "\n" + infoLine
                            else:
                                rIndex = fileInfo.find("port")
                                eIndex = fileInfo.find("io svctm")
                                if (rIndex != -1) and (eIndex != -1):
                                    infoLine = fileInfo[rIndex:eIndex]
                                    messageLine += "\n" + infoLine
                    else:
                        #若关键字未出现过,则加入字典,记录 次数为1                
                        hardpanKeyWorksMap.setdefault(hardpankey, [1, errorTime])

            except:
                logger.error("[analyzeMessagesHardpan] analyze hardpan is error." + str(traceback.format_exc()))
                continue
    #筛选：同一块硬盘 出现报警10次以下，则删除        
    if hardpanKeyWorksMap:
        logger.info("[analyzeMessagesHardpan] hardpanKeyWorksMap before pop is : %s" % hardpanKeyWorksMap)
        for key in hardpanKeyWorksMap.keys():
            if hardpanKeyWorksMap.get(key)[0] < 10:
                hardpanKeyWorksMap.pop(key)

    #这里做个循环，可以把次数踢出,构造{key:2017-12-2}
    for hardpankey in hardpanKeyWorksMap:
        hardpanKeyWorksMap[hardpankey] = hardpanKeyWorksMap[hardpankey][1]

    #若hardpanKeyWorksMap有值，则证明 有存在慢盘的可能，继续检查
    if hardpanKeyWorksMap:
        logger.info("[analyzeMessagesHardpan] hardpanKeyWorksMap is : %s" % hardpanKeyWorksMap)
        return (True, hardpanKeyWorksMap, messageLine)

    #在日志解析中未发现慢盘    
    return (False, hardpanKeyWorksMap, messageLine)

# **************************************************************************** #
# 函数名称: checkLimit4InfModule
# 功能说明: 检查4口FCoE或TOE接口卡，低概率发生OOPS的问题
# 输入参数: devObj
# **************************************************************************** # 
def checkCurSystemVersion(cli, lang, logger, allCliRet):
    '''
    @summary: 检查当前设备版本    及    检查4口FCoE或TOE接口卡，低概率发生OOPS的问题
    @param cli: cli对象
    @param lang: 语言对象
    @param logger: 日志打印对象
    @return:
        flag:
            True: 检查通过
            common.RESULT_NOCHECK: 未检查
        cliRetAll: cli回显
        errMsg: 错误时的消息
    '''
    SYS_PATCH_VER_MAP = {'V100R005C02SPC300': '',
                         'V100R005C30SPC300': '',
                         'V100R005C30SPC500': 'V100R005C30SPH501',
                         'V100R005C30SPC700': 'V100R005C30SPH701',
                         }

    errMsg = ""
    #获取系统版本    
    (versionFalg, sysSpcVersion, cliRet, errMsg) = common.getCurSystemVersion(cli, lang)
    allCliRet += cliRet
    if not versionFalg:
        return (common.RESULT_NOCHECK, allCliRet, errMsg)
    logger.info("[checkLimit4InfModule] system version : %s" % sysSpcVersion)
    (queryOk, cliRet, hotPatchVer) = common.getHotpatchVersion(cli, lang)
    allCliRet += cliRet
    logger.info("[checkLimit4InfModule] Hotpatch version: %s" % hotPatchVer)
    # 查询热补丁有问题，报  获取信息失败
    if not queryOk:
        errMsg = common.getMsg(lang, "query.result.abnormal")
        return (common.RESULT_NOCHECK, allCliRet, errMsg)

    # 增加内存相关检查
    if is_mem_limit_version(sysSpcVersion, hotPatchVer):
        return (common.RESULT_NOCHECK, allCliRet,
                common.getMsg(lang, "diskslow.system.edition.low"))

    # 查看系统版本是否存在于查询版本内
    if sysSpcVersion in SYS_PATCH_VER_MAP:
        # 如果没有补丁要求  或 现有补丁小于需求补丁，则检查T4卡
        needHotPatchVer = SYS_PATCH_VER_MAP.get(sysSpcVersion)
        if needHotPatchVer == '' or needHotPatchVer > hotPatchVer:
            # 无补丁 或 补丁型号小于规定 型号
            (queryOk, cliRet, existFlag) = ifExistT4InfModule(cli, lang, logger)
            allCliRet += cliRet
            logger.info("[checkLimit4InfModule] Exist T4 Interface Module :%s" % str(existFlag))

            # T4卡 查询失败
            if queryOk != True:
                errMsg = common.getMsg(lang, "query.result.abnormal")
                return (common.RESULT_NOCHECK, allCliRet, errMsg)

            # 存在4口FCoE或TOE接口卡，限制
            if existFlag:
                errMsg = common.getMsg(lang, "TOE.or.FCoE.error")
                return (common.RESULT_NOCHECK, allCliRet, errMsg)
        return (True, allCliRet, errMsg)
    # 如版本为 V100R005C30SPC800 则要进行慢盘检查，且避免T4卡检查
    elif sysSpcVersion in "V100R005C30SPC800":
        return (True, allCliRet, errMsg)
    elif sysSpcVersion in MEM_LIMIT_MAP:
        return (True, allCliRet, errMsg)
    # 系统版本不检查
    return (common.RESULT_NOCHECK, allCliRet, common.getMsg(lang, "diskslow.system.edition.low"))


def is_mem_limit_version(p_version, p_patch):
    """
    检查是否内存限制搜集场景
    :param p_version: 版本
    :param p_patch: 补丁
    :return: True 限制搜集，False 可以搜集
    """
    if p_version not in MEM_LIMIT_MAP:
        return False

    return p_patch < MEM_LIMIT_MAP.get(p_version)


def ifExistT4InfModule(cli, lang, logger):
    '''
    @summary: 检查设备上是否存在4口FCoE或TOE接口卡
    @param cli: cli对象
    @param lang: 语言对象
    @param logger: 日志打印对象
    @return:
        flag:
            True: 检查通过
            existFlag : 存在T4卡  ， 未检查
        infModuleInfo: cli回显
        errMsg: 错误时的消息
    '''
    existFlag = False

    infModuleInfo = cli.execCmd("showifmodule")
    lineList = infModuleInfo.splitlines()

    #信息少于7行，查询信息失败
    if len(lineList) < 7:
        if "command operates successfully" in infModuleInfo:
            return (True, infModuleInfo, existFlag)
        return (False, infModuleInfo , existFlag)

    for line in lineList:
        if not line.strip().startswith("Type"):
            continue
        if "4 x 10G FCoE Interface Module" in line or \
            "4 x 10GE Interface Module" in line:
            logger.info("[ifExistT4InfModule] The devNode has T4 FCoE.")
            existFlag = True
            return (True, infModuleInfo, existFlag)

    return (True, infModuleInfo, existFlag)

def getFreeMemInMinisystem(cli, lang, logger, allCliRet):
    '''
    @summary: minisystem模式下查询当前控制器剩余内存,对CLI模式无影响。
    @param cli: cli对象
    @param lang: 语言对象
    @param logger: 日志打印对象
    @param allCliRet: 回显信息
    @return:
        flag:
            True: 检查通过
            common.RESULT_NOCHECK : 内存不足150MB  ， 未检查
        infModuleInfo: cli回显
        errMsg: 错误时的消息
    '''
    cmd = "free -m"
    memRet = cli.execCmd(cmd)
    allCliRet += "\n" + memRet

    for memLine in memRet.splitlines():
        # 'Men'为该行对应的关键字
        try:
            if 'mem:' in memLine.lower():
                if memLine.split() >= 4:
                    freeSpace = memLine.split()[3].strip()
                    if float(freeSpace) < 150 :
                        logger.info("[getFreeMemInMinisystem] free space is %s" % freeSpace)
                        errMsg = common.getMsg(lang, "diskslow.controller.arm.notenough")
                        return (common.RESULT_NOCHECK, allCliRet, errMsg)
                    else:
                        return (True, allCliRet, "")
        except:
            logger.error("Failed to query the remaining memory of the current controller.")
            continue

    errMsg = common.getMsg(lang, "query.result.abnormal")
    return (common.RESULT_NOCHECK, allCliRet, errMsg)
