# -*- coding: UTF-8 -*-

"""云备份任务巡检 20121204 added Begin"""
import re
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 云备份任务巡检
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    admin:/>showcloudbackup
    ===============================================================================
                           Cloud Backup Information
    -------------------------------------------------------------------------------
      Cloud Backup ID    Cloud Backup Name    Running Status        Health Status  
    -------------------------------------------------------------------------------
      0                  CloudBackup001       Copying               Normal         
      1                  CloudBackup002       Copy Completed        Normal         
      2                  CloudBackup003       Recovery Completed    Normal         
      3                  CloudBackup004       Copying               Normal         
    ==============================================================================="""


    flag = True
    cloudBackUpId = ""
    cloudBackUpName = ""
    healthStatus = ""
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showcloudbackup")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."          
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        
        cloudBackUpId = list2[0]
        cloudBackUpName = list2[1]
        
        healthStatus = list2[-1]
        if "Normal" != healthStatus:
            flag = False
            if "zh" == lang:
                errMsg += u"\n云备份任务（ID：" + cloudBackUpId + u"，名称：" + cloudBackUpName + u"）的健康状态存在异常。"
            else:
                errMsg += u"\nThe health status of Cloudbackup task (ID:" + cloudBackUpId + u", name:" + cloudBackUpName + u") is abnormal."

    return (flag, cliRet, errMsg)

"""云备份任务巡检 20121204 added End"""
