# -*- coding: UTF-8 -*-

import traceback
from comm import modelManager
import common


def execute(cli):
    """
            并发资源检查
    1、并发资源检查命令回显收集，每10秒执行一次，持续观察1分钟。          
    """
    #单次执行CLI命令列表
    oncmdlist = ["chglatencyswitch -sw on -c a","chglatencyswitch -sw on -c b"]
    offcmdlist = ["chglatencyswitch -sw off -c a","chglatencyswitch -sw off -c b"]
    #周期执行CLI命令列表
    repecmdlist =["shownbio","showlatency -c a","showlatency -c b","chglatencyswitch -sw on -c a","chglatencyswitch -sw on -c b"]
    SERVICE_RESOURCSE_SPEC = 60
    SERVICE_RESOURCSE_INTERVAL = 10
    logger = PY_LOGGER
    PY_JAVA_ENV = py_java_env
    try:
        flag = True
        errMsg = ""
        lang = py_java_env.get("lang")
        sysSpcVersion = ""
        cliRet = ""
        cliRetAll = ""
        #判断产品版本，V100R005C00SPC700版本之前则不涉及
        (flag, sysSpcVersion, cliRet, errMsg) = common.getCurSystemVersion(cli, lang)
        
        cliRetAll += cliRet
        if not flag:
            return (flag, cliRet, errMsg)
        if sysSpcVersion < "V100R005C00SPC700":
            return common.RESULT_NOSUPPORT ,cliRetAll ,errMsg
        
        #V100R005C00和V100R005C01属于同一个级别，V100R005C01SPC700版本之前为不涉及
        if "V100R005C01" in sysSpcVersion and sysSpcVersion < "V100R005C01SPC700":
            return common.RESULT_NOSUPPORT ,cliRetAll ,errMsg
        
        common.refreshProcess(PY_JAVA_ENV, 1, logger)
        
        #进入Developer模式
        flag = modelManager.changeCli2Developer(cli, PY_JAVA_ENV)
        if not flag:
            flag = False
            errMsg = common.getMsg(lang, "enter.developer.fail")
            return (flag, cliRetAll, errMsg)
        
        common.refreshProcess(PY_JAVA_ENV, 3, logger)
        
        #收集单次oncmdlis的CLI命令回显
        cliRet = common.execCmdLlist(cli,oncmdlist)
        cliRetAll += cliRet
        
        common.refreshProcess(PY_JAVA_ENV, 5, logger)

        #收集周期执行repecmdlist的CLI命令回显
        cliRet = common.repeExecCmdLlist(cli,repecmdlist,SERVICE_RESOURCSE_SPEC,SERVICE_RESOURCSE_INTERVAL, PY_JAVA_ENV, logger, True)
        cliRetAll += cliRet
        
        
        #收集单次offcmdlist的CLI命令回显
        cliRet = common.execCmdLlist(cli,offcmdlist)
        cliRetAll += cliRet
        common.refreshProcess(PY_JAVA_ENV, 97, logger)
        #退出Developer模式进入CLI模式
        modelManager.changeAnyModel2Cli(cli)
        return (flag, cliRetAll, errMsg)
    
        common.refreshProcess(PY_JAVA_ENV, 98, logger)
        
    except Exception, exception:
        logger.error(str(exception))
        return (False, cliRetAll, common.getMsg(lang, "query.result.abnormal"))
    finally:
        common.refreshProcess(PY_JAVA_ENV, 100, logger)